/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop;

import ic2.api.classic.crops.ClassicCrops;
import ic2.core.IC2;
import ic2.core.block.crop.TileEntityCrop;
import ic2.core.block.render.model.ModelCrops;
import ic2.core.platform.lang.ILocaleBlock;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2States;
import ic2.core.platform.textures.models.BaseModel;
import ic2.core.platform.textures.obj.ICustomModeledBlock;
import ic2.core.util.helpers.BlockStateContainerIC2;
import ic2.core.util.obj.IBootable;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCrop
extends BlockContainer
implements IBootable,
IPlantable,
ICustomModeledBlock,
ILocaleBlock {
    public BlockCrop() {
        super(Material.field_151585_k);
        this.func_149711_c(0.8f);
        this.func_149752_b(0.2f);
        this.func_149672_a(SoundType.field_185850_c);
        this.setHarvestLevel("axe", 0);
        this.field_149783_u = true;
    }

    @Override
    public LocaleComp getName() {
        return Ic2BlockLang.cropStick;
    }

    public String func_149739_a() {
        return this.getName().getUnlocalized();
    }

    public String func_149732_F() {
        return this.getName().getLocalized();
    }

    @Override
    public void onLoad() {
        Ic2States.cropStick = this.func_176223_P();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityCrop();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Ic2Items.cropStick.func_77973_b();
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return Ic2Items.cropStick.func_77946_l();
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Deprecated
    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.2, 0.0, 0.2, 0.8, 0.7, 0.8);
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityCrop) {
            return new BlockStateContainerIC2.IC2BlockState(state, IC2.platform.isRendering() ? ((TileEntityCrop)tile).getCurrentEntry() : null);
        }
        return state;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityCrop) {
            ((TileEntityCrop)tile).onBlockDestroyed();
        }
        super.onBlockExploded(world, pos, explosion);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (ClassicCrops.instance.getFarmland(worldIn.func_180495_p(pos.func_177977_b())) == null) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        } else {
            TileEntity tile = worldIn.func_175625_s(pos);
            if (tile == null || !(tile instanceof TileEntityCrop)) {
                return;
            }
            ((TileEntityCrop)tile).onNeighbourChange();
        }
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityCrop) {
            ((TileEntityCrop)tile).onEntityColide(entityIn);
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return ClassicCrops.instance.getFarmland(worldIn.func_180495_p(pos.func_177977_b())) != null && super.func_176196_c(worldIn, pos);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityCrop) {
            return ((TileEntityCrop)tile).getEmittdLight();
        }
        return super.getLightValue(state, world, pos);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityCrop) {
            TileEntityCrop crop = (TileEntityCrop)tile;
            return crop.onRightClick(playerIn, hand);
        }
        return false;
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityCrop) {
            ((TileEntityCrop)tile).onLeftClick(playerIn);
        }
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntity tile = blockAccess.func_175625_s(pos);
        if (tile instanceof TileEntityCrop) {
            return ((TileEntityCrop)tile).getRedstone();
        }
        return 0;
    }

    @Override
    public List<IBlockState> getValidModelStates() {
        return Arrays.asList(this.func_176223_P());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BaseModel getModelFromState(IBlockState state) {
        return new ModelCrops();
    }

    @Override
    public IBlockState getStateFromStack(ItemStack stack) {
        return null;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos);
    }
}

