/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop;

import ic2.api.classic.crops.ClassicBaseSeed;
import ic2.api.classic.crops.ClassicCrops;
import ic2.api.classic.crops.IBaseSeedItem;
import ic2.api.classic.crops.ICropSoil;
import ic2.api.classic.crops.ICustomCropRenderer;
import ic2.api.classic.crops.IFarmland;
import ic2.api.classic.crops.IMultiLayeredCrop;
import ic2.api.crops.BaseSeed;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.api.crops.ICropSeed;
import ic2.core.block.crop.crops.CropArgentum;
import ic2.core.block.crop.crops.CropAurelia;
import ic2.core.block.crop.crops.CropBlueWheat;
import ic2.core.block.crop.crops.CropCacti;
import ic2.core.block.crop.crops.CropCocoa;
import ic2.core.block.crop.crops.CropCoffee;
import ic2.core.block.crop.crops.CropColorFlower;
import ic2.core.block.crop.crops.CropFerru;
import ic2.core.block.crop.crops.CropGlowShroom;
import ic2.core.block.crop.crops.CropHemp;
import ic2.core.block.crop.crops.CropHops;
import ic2.core.block.crop.crops.CropLumilia;
import ic2.core.block.crop.crops.CropMalachite;
import ic2.core.block.crop.crops.CropMelon;
import ic2.core.block.crop.crops.CropMushroom;
import ic2.core.block.crop.crops.CropNetherWart;
import ic2.core.block.crop.crops.CropPotato;
import ic2.core.block.crop.crops.CropPumpkin;
import ic2.core.block.crop.crops.CropRainbowFlower;
import ic2.core.block.crop.crops.CropRedWheat;
import ic2.core.block.crop.crops.CropReed;
import ic2.core.block.crop.crops.CropSapling;
import ic2.core.block.crop.crops.CropSeedFood;
import ic2.core.block.crop.crops.CropStannum;
import ic2.core.block.crop.crops.CropStickReed;
import ic2.core.block.crop.crops.CropTea;
import ic2.core.block.crop.crops.CropTerraWart;
import ic2.core.block.crop.crops.CropVenomilia;
import ic2.core.block.crop.crops.CropWeed;
import ic2.core.block.crop.crops.CropWheat;
import ic2.core.block.crop.misc.Farmlands;
import ic2.core.block.crop.misc.Soils;
import ic2.core.block.crop.renders.CropEntry;
import ic2.core.block.crop.renders.CropQuadStorage;
import ic2.core.block.crop.renders.DefaultCropRenderer;
import ic2.core.block.crop.renders.MultiCropRenderer;
import ic2.core.block.crop.renders.StickRenderer;
import ic2.core.block.machine.low.logic.crops.CropSorters;
import ic2.core.platform.lang.components.base.LangComponentHolder;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.util.helpers.ItemWithMeta;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Ic2Crops
extends ClassicCrops {
    public static Ic2Crops instance;
    private Map<BiomeDictionary.Type, Integer> humidityBiomeBonus = new HashMap<BiomeDictionary.Type, Integer>();
    private Map<BiomeDictionary.Type, Integer> nutrientBiomeBonus = new HashMap<BiomeDictionary.Type, Integer>();
    private Map<ItemWithMeta, BaseSeed> baseSeeds = new LinkedHashMap<ItemWithMeta, BaseSeed>();
    private Map<ResourceLocation, CropCard> crops = new LinkedHashMap<ResourceLocation, CropCard>();
    private Map<ResourceLocation, ItemStack> cardItems = new LinkedHashMap<ResourceLocation, ItemStack>();
    private Map<CropCard, LocaleComp> cardNames = new LinkedHashMap<CropCard, LocaleComp>();
    private Map<CropEntry, CropQuadStorage> quadStorage = new HashMap<CropEntry, CropQuadStorage>();
    private Map<IBlockState, IFarmland> farmlands = new HashMap<IBlockState, IFarmland>();
    private Map<IBlockState, ICropSoil> soils = new HashMap<IBlockState, ICropSoil>();
    private Map<CropCard, ICustomCropRenderer> renders = new HashMap<CropCard, ICustomCropRenderer>();
    private ICustomCropRenderer stickRenderer;
    private Map<ResourceLocation, TextureAtlasSprite> texturesToLoad = new LinkedHashMap<ResourceLocation, TextureAtlasSprite>();
    public static CropCard cropWheat;
    public static CropCard cropPumpkin;
    public static CropCard cropMelon;
    public static CropCard cropYellowFlower;
    public static CropCard cropRedFlower;
    public static CropCard cropBlackFlower;
    public static CropCard cropPurpleFlower;
    public static CropCard cropBlueFlower;
    public static CropCard cropWhiteFlower;
    public static CropCard cropVenomilia;
    public static CropCard cropRainbowFlower;
    public static CropCard cropReed;
    public static CropCard cropStickReed;
    public static CropCard cropCocoa;
    public static CropCard cropFerru;
    public static CropCard cropMalachite;
    public static CropCard cropStannum;
    public static CropCard cropAurelia;
    public static CropCard cropArgentum;
    public static CropCard cropGlowstone;
    public static CropCard cropRedwheat;
    public static CropCard cropBluewheat;
    public static CropCard cropNetherWart;
    public static CropCard cropTerraWart;
    public static CropCard cropGlowWart;
    public static CropCard cropCoffee;
    public static CropCard cropHops;
    public static CropCard cropCarrots;
    public static CropCard cropPotato;
    public static CropCard cropRedMushroom;
    public static CropCard cropBrownMushroom;
    public static CropCard cropCacti;
    public static CropCard cropTea;
    public static CropCard cropHemp;
    public static CropCard cropBeetRoot;
    public static CropCard cropOakSapling;
    public static CropCard cropSpruceSapling;
    public static CropCard cropBirchSapling;
    public static CropCard cropJungleSapling;
    public static CropCard cropAcaciaSapling;
    public static CropCard cropDarkOakSapling;

    public static void init() {
        Ic2Crops crops = new Ic2Crops();
        Crops.instance = crops;
        ClassicCrops.instance = crops;
        instance = crops;
        crops.load();
        CropSorters.instance.init();
    }

    private void load() {
        this.addBiomenutrientsBonus(BiomeDictionary.Type.JUNGLE, 10);
        this.addBiomenutrientsBonus(BiomeDictionary.Type.SWAMP, 10);
        this.addBiomenutrientsBonus(BiomeDictionary.Type.MUSHROOM, 5);
        this.addBiomenutrientsBonus(BiomeDictionary.Type.FOREST, 5);
        this.addBiomenutrientsBonus(BiomeDictionary.Type.RIVER, 2);
        this.addBiomenutrientsBonus(BiomeDictionary.Type.PLAINS, 0);
        this.addBiomenutrientsBonus(BiomeDictionary.Type.SAVANNA, -2);
        this.addBiomenutrientsBonus(BiomeDictionary.Type.HILLS, -5);
        this.addBiomenutrientsBonus(BiomeDictionary.Type.MOUNTAIN, -5);
        this.addBiomenutrientsBonus(BiomeDictionary.Type.WASTELAND, -8);
        this.addBiomenutrientsBonus(BiomeDictionary.Type.END, -10);
        this.addBiomenutrientsBonus(BiomeDictionary.Type.NETHER, -10);
        this.addBiomenutrientsBonus(BiomeDictionary.Type.DEAD, -10);
        this.addBiomehumidityBonus(BiomeDictionary.Type.SWAMP, 5);
        this.addBiomehumidityBonus(BiomeDictionary.Type.WATER, 10);
        this.addBiomehumidityBonus(BiomeDictionary.Type.SAVANNA, -8);
        this.addBiomehumidityBonus(BiomeDictionary.Type.WASTELAND, -5);
        this.addBiomehumidityBonus(BiomeDictionary.Type.END, -7);
        this.addBiomehumidityBonus(BiomeDictionary.Type.NETHER, -10);
        this.registerFarmland(Farmlands.farmland, Blocks.field_150458_ak);
        this.registerFarmland(Farmlands.dirtLand, Blocks.field_150346_d);
        this.registerFarmland(Farmlands.spongeLand, Blocks.field_150360_v);
        this.registerFarmland(Farmlands.souland, Blocks.field_150425_aM);
        this.registerCropSoil((ICropSoil)new Soils.FarmSoil(), Blocks.field_150346_d.func_176223_P());
        this.registerCropSoil((ICropSoil)new Soils.SoulSoil(), Blocks.field_150425_aM.func_176223_P());
        this.registerCropSoil((ICropSoil)new Soils.SpongeSoil(), Blocks.field_150360_v);
        weed = new CropWeed();
        this.registerCrop(weed);
        this.registerCrop(cropWheat);
        this.registerCrop(cropPumpkin);
        this.registerCrop(cropMelon);
        this.registerCrop(cropYellowFlower);
        this.registerCrop(cropRedFlower);
        this.registerCrop(cropBlackFlower);
        this.registerCrop(cropPurpleFlower);
        this.registerCrop(cropBlueFlower);
        this.registerCrop(cropWhiteFlower);
        this.registerCrop(cropVenomilia);
        this.registerCrop(cropRainbowFlower);
        this.registerCrop(cropReed);
        this.registerCrop(cropStickReed);
        this.registerCrop(cropCocoa);
        this.registerCrop(cropFerru);
        this.registerCrop(cropMalachite);
        this.registerCrop(cropStannum);
        this.registerCrop(cropAurelia);
        this.registerCrop(cropArgentum);
        this.registerCrop(cropGlowstone);
        this.registerCrop(cropRedwheat);
        this.registerCrop(cropBluewheat);
        this.registerCrop(cropNetherWart);
        this.registerCrop(cropTerraWart);
        this.registerCrop(cropGlowWart);
        this.registerCrop(cropCoffee);
        this.registerCrop(cropHops);
        this.registerCrop(cropCarrots);
        this.registerCrop(cropPotato);
        this.registerCrop(cropRedMushroom);
        this.registerCrop(cropBrownMushroom);
        this.registerCrop(cropCacti);
        this.registerCrop(cropTea);
        this.registerCrop(cropHemp);
        this.registerCrop(cropBeetRoot);
        this.registerCrop(cropOakSapling);
        this.registerCrop(cropSpruceSapling);
        this.registerCrop(cropBirchSapling);
        this.registerCrop(cropJungleSapling);
        this.registerCrop(cropAcaciaSapling);
        this.registerCrop(cropDarkOakSapling);
        this.registerCropDisplayItem(weed, new ItemStack((Block)Blocks.field_150329_H));
        this.registerCropDisplayItem(cropWheat, new ItemStack(Items.field_151015_O));
        this.registerCropDisplayItem(cropPumpkin, new ItemStack(Blocks.field_150423_aK));
        this.registerCropDisplayItem(cropMelon, new ItemStack(Blocks.field_150440_ba));
        this.registerCropDisplayItem(cropYellowFlower, new ItemStack((Block)Blocks.field_150327_N));
        this.registerCropDisplayItem(cropRedFlower, new ItemStack((Block)Blocks.field_150328_O));
        this.registerCropDisplayItem(cropBlackFlower, new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLACK.func_176767_b()));
        this.registerCropDisplayItem(cropPurpleFlower, new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.PURPLE.func_176767_b()));
        this.registerCropDisplayItem(cropBlueFlower, new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.CYAN.func_176767_b()));
        this.registerCropDisplayItem(cropWhiteFlower, new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.WHITE.func_176767_b()));
        this.registerCropDisplayItem(cropVenomilia, Ic2Items.weedEx.func_77946_l());
        this.registerCropDisplayItem(cropRainbowFlower, Ic2Items.painter.func_77946_l());
        this.registerCropDisplayItem(cropReed, new ItemStack(Items.field_151120_aE));
        this.registerCropDisplayItem(cropStickReed, Ic2Items.stickyResin.func_77946_l());
        this.registerCropDisplayItem(cropCocoa, new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BROWN.func_176767_b()));
        this.registerCropDisplayItem(cropFerru, Ic2Items.ironDust.func_77946_l());
        this.registerCropDisplayItem(cropMalachite, Ic2Items.copperDust.func_77946_l());
        this.registerCropDisplayItem(cropStannum, Ic2Items.tinDust.func_77946_l());
        this.registerCropDisplayItem(cropAurelia, Ic2Items.goldDust.func_77946_l());
        this.registerCropDisplayItem(cropArgentum, Ic2Items.silverDust.func_77946_l());
        this.registerCropDisplayItem(cropGlowstone, new ItemStack((Block)Blocks.field_150362_t));
        this.registerCropDisplayItem(cropRedwheat, new ItemStack(Items.field_151137_ax));
        this.registerCropDisplayItem(cropBluewheat, new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLUE.func_176767_b()));
        this.registerCropDisplayItem(cropNetherWart, new ItemStack(Items.field_151075_bm));
        this.registerCropDisplayItem(cropTerraWart, Ic2Items.terraWart.func_77946_l());
        this.registerCropDisplayItem(cropGlowWart, new ItemStack(Items.field_151114_aO));
        this.registerCropDisplayItem(cropCoffee, Ic2Items.coffeeBeans.func_77946_l());
        this.registerCropDisplayItem(cropHops, Ic2Items.hops.func_77946_l());
        this.registerCropDisplayItem(cropCarrots, new ItemStack(Items.field_151172_bF));
        this.registerCropDisplayItem(cropPotato, new ItemStack(Items.field_151174_bG));
        this.registerCropDisplayItem(cropRedMushroom, new ItemStack((Block)Blocks.field_150337_Q));
        this.registerCropDisplayItem(cropBrownMushroom, new ItemStack((Block)Blocks.field_150338_P));
        this.registerCropDisplayItem(cropCacti, new ItemStack((Block)Blocks.field_150434_aF));
        this.registerCropDisplayItem(cropTea, Ic2Items.teaLeaf.func_77946_l());
        this.registerCropDisplayItem(cropHemp, Ic2Items.hemp.func_77946_l());
        this.registerCropDisplayItem(cropBeetRoot, new ItemStack(Items.field_185163_cU));
        this.registerCropDisplayItem(cropOakSapling, new ItemStack(Blocks.field_150345_g));
        this.registerCropDisplayItem(cropSpruceSapling, new ItemStack(Blocks.field_150345_g, 1, 1));
        this.registerCropDisplayItem(cropBirchSapling, new ItemStack(Blocks.field_150345_g, 1, 2));
        this.registerCropDisplayItem(cropJungleSapling, new ItemStack(Blocks.field_150345_g, 1, 3));
        this.registerCropDisplayItem(cropAcaciaSapling, new ItemStack(Blocks.field_150345_g, 1, 4));
        this.registerCropDisplayItem(cropDarkOakSapling, new ItemStack(Blocks.field_150345_g, 1, 5));
        this.registerBaseSeed(new ItemStack(Items.field_151014_N), cropWheat, 1, 1, 1, 1);
        this.registerBaseSeed(new ItemStack(Items.field_151080_bb), cropPumpkin, 1, 1, 1, 1);
        this.registerBaseSeed(new ItemStack(Items.field_151081_bc), cropMelon, 1, 1, 1, 1);
        this.registerBaseSeed(new ItemStack(Items.field_151075_bm), cropNetherWart, 1, 1, 1, 1);
        this.registerBaseSeed(Ic2Items.terraWart.func_77946_l(), cropTerraWart, 1, 1, 1, 1);
        this.registerBaseSeed(Ic2Items.coffeeBeans.func_77946_l(), cropCoffee, 1, 1, 1, 1);
        this.registerBaseSeed(new ItemStack(Items.field_151120_aE), cropReed, 1, 3, 0, 2);
        this.registerBaseSeed(new ItemStack(Items.field_151100_aR, 1, 3), cropCocoa, 1, 0, 0, 0);
        this.registerBaseSeed(new ItemStack((Block)Blocks.field_150328_O, 4), cropRedFlower, 4, 1, 1, 1);
        this.registerBaseSeed(new ItemStack((Block)Blocks.field_150327_N, 4), cropYellowFlower, 4, 1, 1, 1);
        this.registerBaseSeed(new ItemStack((Block)Blocks.field_150328_O, 4, 8), cropWhiteFlower, 4, 1, 1, 1);
        this.registerBaseSeed(new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)Items.field_151172_bF.getRegistryName())), cropCarrots, 1, 1, 1, 1);
        this.registerBaseSeed(new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)Items.field_151174_bG.getRegistryName())), cropPotato, 1, 1, 1, 1);
        this.registerBaseSeed(new ItemStack((Block)Blocks.field_150337_Q, 4), cropRedMushroom, 3, 1, 1, 1);
        this.registerBaseSeed(new ItemStack((Block)Blocks.field_150338_P, 4), cropBrownMushroom, 3, 1, 1, 1);
        this.registerBaseSeed(new ItemStack(Items.field_185163_cU), cropBeetRoot, 1, 1, 1, 1);
        this.registerBaseSeed(new ItemStack((Block)Blocks.field_150434_aF), cropCacti, 1, 1, 1, 1);
        this.registerBaseSeed(Ic2Items.hempSeeds.func_77946_l(), cropHemp, 1, 1, 1, 1);
        this.registerBaseSeed(new ItemStack(Blocks.field_150345_g), cropOakSapling, 1, 1, 1, 1);
        this.registerBaseSeed(new ItemStack(Blocks.field_150345_g, 1, 1), cropSpruceSapling, 1, 1, 1, 1);
        this.registerBaseSeed(new ItemStack(Blocks.field_150345_g, 1, 2), cropBirchSapling, 1, 1, 1, 1);
        this.registerBaseSeed(new ItemStack(Blocks.field_150345_g, 1, 3), cropJungleSapling, 1, 1, 1, 1);
        this.registerBaseSeed(new ItemStack(Blocks.field_150345_g, 1, 4), cropAcaciaSapling, 1, 1, 1, 1);
        this.registerBaseSeed(new ItemStack(Blocks.field_150345_g, 1, 5), cropDarkOakSapling, 1, 1, 1, 1);
        MinecraftForge.EVENT_BUS.post((Event)new Crops.CropRegisterEvent());
    }

    public void postInit() {
        this.registerBaseSeed(new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)Items.field_151172_bF.getRegistryName())), cropCarrots, 1, 1, 1, 1);
        this.registerBaseSeed(new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)Items.field_151174_bG.getRegistryName())), cropPotato, 1, 1, 1, 1);
        for (Map.Entry<ItemWithMeta, BaseSeed> entry : this.baseSeeds.entrySet()) {
            ResourceLocation loc;
            ItemStack key = entry.getKey().toStack();
            CropCard card = entry.getValue().crop;
            if (card == null || this.cardItems.containsKey(loc = new ResourceLocation(card.getOwner(), card.getId()))) continue;
            this.cardItems.put(loc, key);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerCropTextures(Map<ResourceLocation, TextureAtlasSprite> textures) {
        this.texturesToLoad.putAll(textures);
    }

    @Override
    public void addBiomenutrientsBonus(BiomeDictionary.Type type, int nutrientsBonus) {
        if (type == null) {
            return;
        }
        this.nutrientBiomeBonus.put(type, nutrientsBonus);
    }

    @Override
    public void addBiomehumidityBonus(BiomeDictionary.Type type, int humidityBonus) {
        if (type == null) {
            return;
        }
        this.humidityBiomeBonus.put(type, humidityBonus);
    }

    @Override
    public int getHumidityBiomeBonus(Biome biome) {
        int max = 0;
        for (Map.Entry<BiomeDictionary.Type, Integer> entry : this.humidityBiomeBonus.entrySet()) {
            int next;
            if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)entry.getKey()) || (next = entry.getValue().intValue()) <= max) continue;
            max = next;
        }
        return max;
    }

    @Override
    public int getNutrientBiomeBonus(Biome biome) {
        int max = 0;
        for (Map.Entry<BiomeDictionary.Type, Integer> entry : this.nutrientBiomeBonus.entrySet()) {
            int next;
            if (!BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)entry.getKey()) || (next = entry.getValue().intValue()) <= max) continue;
            max = next;
        }
        return max;
    }

    @Override
    public CropCard getCropCard(String owner, String name) {
        return this.getCropCard(new ResourceLocation(owner, name));
    }

    @Override
    public CropCard getCropCard(ResourceLocation card) {
        if (card == null || card.func_110623_a().equals("empty")) {
            return null;
        }
        return this.crops.get(card);
    }

    @Override
    public CropCard getCropCard(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ICropSeed)) {
            return null;
        }
        return ((ICropSeed)stack.func_77973_b()).getCropFromStack(stack);
    }

    public LocaleComp getCropName(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ICropSeed)) {
            return Ic2Lang.nullKey;
        }
        return this.cardNames.getOrDefault(((ICropSeed)stack.func_77973_b()).getCropFromStack(stack), Ic2Lang.nullKey);
    }

    public LocaleComp getCropName(CropCard card) {
        return this.cardNames.getOrDefault(card, Ic2Lang.nullKey);
    }

    @Override
    public Collection<CropCard> getCrops() {
        return this.crops.values();
    }

    @Override
    public void registerCrop(CropCard crop) {
        if (crop == null) {
            return;
        }
        this.crops.put(new ResourceLocation(crop.getOwner(), crop.getId()), crop);
        LangComponentHolder.LocaleCropComp comp = new LangComponentHolder.LocaleCropComp(crop.getUnlocalizedName());
        this.cardNames.put(crop, comp);
    }

    @Override
    public boolean registerBaseSeed(ItemStack stack, CropCard crop, int size, int growth, int gain, int resistance) {
        if (stack.func_190926_b()) {
            return false;
        }
        ItemWithMeta meta = new ItemWithMeta(stack);
        if (this.baseSeeds.containsKey(meta)) {
            return false;
        }
        this.baseSeeds.put(meta, new ClassicBaseSeed(crop, size, growth, gain, resistance, stack.func_190916_E()));
        return true;
    }

    @Override
    public BaseSeed getBaseSeed(ItemStack stack) {
        return this.getClassicBaseSeed(stack);
    }

    @Override
    public ClassicBaseSeed getClassicBaseSeed(ItemStack stack) {
        ClassicBaseSeed seed;
        if (stack.func_190926_b()) {
            return null;
        }
        if (stack.func_77973_b() instanceof IBaseSeedItem && (seed = ((IBaseSeedItem)stack.func_77973_b()).getBaseSeed(stack)) != null) {
            return seed;
        }
        ItemWithMeta meta = new ItemWithMeta(stack);
        BaseSeed seed2 = this.baseSeeds.get(meta);
        if (seed2 == null) {
            seed2 = this.baseSeeds.get(meta.toWildcard());
        }
        if (seed2 != null) {
            if (seed2 instanceof ClassicBaseSeed) {
                return (ClassicBaseSeed)seed2;
            }
            return new ClassicBaseSeed(seed2);
        }
        return null;
    }

    @Override
    public void registerFarmland(IFarmland land, IBlockState ... state) {
        if (land == null || state == null || state.length <= 0) {
            return;
        }
        for (IBlockState subState : state) {
            this.farmlands.put(subState, land);
        }
    }

    @Override
    public void registerFarmland(IFarmland land, Block ... block) {
        if (land == null || block == null || block.length <= 0) {
            return;
        }
        for (Block subBlock : block) {
            for (IBlockState state : subBlock.func_176194_O().func_177619_a()) {
                this.farmlands.put(state, land);
            }
        }
    }

    @Override
    public IFarmland getFarmland(IBlockState state) {
        return this.farmlands.get(state);
    }

    @Override
    public void registerCropSoil(ICropSoil soil, IBlockState ... state) {
        if (soil == null || state == null || state.length <= 0) {
            return;
        }
        for (IBlockState subState : state) {
            this.soils.put(subState, soil);
        }
    }

    @Override
    public void registerCropSoil(ICropSoil soil, Block ... block) {
        if (soil == null || block == null || block.length <= 0) {
            return;
        }
        for (Block subBlock : block) {
            for (IBlockState state : subBlock.func_176194_O().func_177619_a()) {
                this.soils.put(state, soil);
            }
        }
    }

    @Override
    public ICropSoil getSoil(IBlockState state) {
        return this.soils.get(state);
    }

    @Override
    public Map<IBlockState, IFarmland> getFarmlandMap() {
        return this.farmlands;
    }

    @Override
    public Map<IBlockState, ICropSoil> getSoilMap() {
        return this.soils;
    }

    @Override
    public void registerCropDisplayItem(CropCard card, ItemStack displayItem) {
        if (card == null || displayItem.func_190926_b()) {
            return;
        }
        this.cardItems.put(new ResourceLocation(card.getOwner(), card.getId()), displayItem.func_77946_l());
    }

    @Override
    public ItemStack getDisplayItem(CropCard card) {
        return this.cardItems.get(new ResourceLocation(card.getOwner(), card.getId()));
    }

    @Override
    public Map<ResourceLocation, ItemStack> getDisplayItems() {
        return this.cardItems;
    }

    @Override
    public void registerCustomRenderer(CropCard card, ICustomCropRenderer renderer) {
        if (renderer == null) {
            return;
        }
        if (card == null) {
            this.stickRenderer = renderer;
            return;
        }
        this.renders.put(card, renderer);
    }

    @SideOnly(value=Side.CLIENT)
    public void loadTextures(TextureMap map) {
        for (ResourceLocation location : this.texturesToLoad.keySet()) {
            map.func_174942_a(location);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void createRenderer() {
        if (this.stickRenderer == null) {
            this.stickRenderer = new StickRenderer();
        }
        FaceBakery bake = new FaceBakery();
        Tuple<List<BakedQuad>, List<BakedQuad>> sticks = this.createQuads(0, this.stickRenderer, bake);
        Tuple<List<BakedQuad>, List<BakedQuad>> breed = this.createQuads(1, this.stickRenderer, bake);
        CropQuadStorage stickStorage = new CropQuadStorage();
        CropQuadStorage.renderType = 0;
        stickStorage.putQuads(sticks);
        this.quadStorage.put(new CropEntry(null, 0), stickStorage);
        CropQuadStorage breedStorage = new CropQuadStorage();
        breedStorage.putQuads(breed);
        this.quadStorage.put(new CropEntry(null, 1), breedStorage);
        for (CropCard card : this.crops.values()) {
            int max = card.getMaxSize();
            ICustomCropRenderer render = this.getRenderer(card);
            for (int i = 0; i < max; ++i) {
                Tuple<List<BakedQuad>, List<BakedQuad>> quads = this.createQuads(i, render, bake);
                if (quads == null) continue;
                CropQuadStorage storage = new CropQuadStorage();
                storage.putQuads(sticks);
                storage.putQuads(quads);
                this.quadStorage.put(new CropEntry(card, i + 1), storage);
            }
        }
    }

    private ICustomCropRenderer getRenderer(CropCard card) {
        ICustomCropRenderer render = this.renders.get(card);
        if (render != null) {
            return render;
        }
        if (card instanceof ICustomCropRenderer) {
            return (ICustomCropRenderer)((Object)card);
        }
        if (card instanceof IMultiLayeredCrop) {
            return new MultiCropRenderer((IMultiLayeredCrop)((Object)card));
        }
        return new DefaultCropRenderer(card);
    }

    @SideOnly(value=Side.CLIENT)
    private Tuple<List<BakedQuad>, List<BakedQuad>> createQuads(int stage, ICustomCropRenderer renderer, FaceBakery bake) {
        List<BakedQuad> fancy = renderer.createQuads(stage, true, bake);
        List<BakedQuad> fast = renderer.createQuads(stage, false, bake);
        if (fancy == null || fast == null) {
            return null;
        }
        if (fancy.isEmpty() || fast.isEmpty()) {
            return null;
        }
        return new Tuple(fancy, fast);
    }

    @SideOnly(value=Side.CLIENT)
    public CropQuadStorage getStorage(CropEntry entry) {
        CropQuadStorage quads = this.quadStorage.get(entry);
        if (quads == null) {
            quads = this.quadStorage.get(new CropEntry(null, 0));
            this.quadStorage.put(entry, quads);
        }
        return quads;
    }

    static {
        cropWheat = new CropWheat();
        cropPumpkin = new CropPumpkin();
        cropMelon = new CropMelon();
        cropYellowFlower = new CropColorFlower("Dandelion", "Notch", new String[]{"Yellow", "Flower"}, 15, 11);
        cropRedFlower = new CropColorFlower("Rose", "Notch", new String[]{"Red", "Flower", "Rose"}, 21, 1);
        cropBlackFlower = new CropColorFlower("Blackthorn", "Alblaka", new String[]{"Black", "Flower", "Rose"}, 22, 0);
        cropPurpleFlower = new CropColorFlower("Tulip", "Alblaka", new String[]{"Purple", "Flower", "Tulip"}, 23, 5);
        cropBlueFlower = new CropColorFlower("Cyazint", "Alblaka", new String[]{"Blue", "Flower"}, 24, 6);
        cropWhiteFlower = new CropColorFlower("Daisy", "Razzokk", new String[]{"White", "Flower", "Rose"}, 91, 15);
        cropVenomilia = new CropVenomilia();
        cropRainbowFlower = new CropRainbowFlower();
        cropReed = new CropReed();
        cropStickReed = new CropStickReed();
        cropCocoa = new CropCocoa();
        cropFerru = new CropFerru();
        cropMalachite = new CropMalachite();
        cropStannum = new CropStannum();
        cropAurelia = new CropAurelia();
        cropArgentum = new CropArgentum();
        cropGlowstone = new CropLumilia();
        cropRedwheat = new CropRedWheat();
        cropBluewheat = new CropBlueWheat();
        cropNetherWart = new CropNetherWart();
        cropTerraWart = new CropTerraWart();
        cropGlowWart = new CropGlowShroom();
        cropCoffee = new CropCoffee();
        cropHops = new CropHops();
        cropCarrots = new CropSeedFood("Carrots", "Orange", 50, new ItemStack(Items.field_151172_bF));
        cropPotato = new CropPotato();
        cropRedMushroom = new CropMushroom(true);
        cropBrownMushroom = new CropMushroom(false);
        cropCacti = new CropCacti();
        cropTea = new CropTea();
        cropHemp = new CropHemp();
        cropBeetRoot = new CropSeedFood("BeetRoots", "Purple", 67, new ItemStack(Items.field_185164_cV));
        cropOakSapling = new CropSapling(71, "oakSapling", new ItemStack(Blocks.field_150364_r), new ItemStack(Blocks.field_150345_g, 1, 0));
        cropSpruceSapling = new CropSapling(81, "spruceSapling", new ItemStack(Blocks.field_150364_r, 1, 1), new ItemStack(Blocks.field_150345_g, 1, 1));
        cropBirchSapling = new CropSapling(75, "birchSapling", new ItemStack(Blocks.field_150364_r, 1, 2), new ItemStack(Blocks.field_150345_g, 1, 2));
        cropJungleSapling = new CropSapling(77, "jungleSapling", new ItemStack(Blocks.field_150364_r, 1, 3), new ItemStack(Blocks.field_150345_g, 1, 3));
        cropAcaciaSapling = new CropSapling(73, "acaciaSapling", new ItemStack(Blocks.field_150363_s), new ItemStack(Blocks.field_150345_g, 1, 4));
        cropDarkOakSapling = new CropSapling(79, "dark_oakSapling", new ItemStack(Blocks.field_150363_s, 1, 1), new ItemStack(Blocks.field_150345_g, 1, 5));
    }
}

