/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tile;

import ic2.api.classic.tile.machine.IFuelMachine;
import ic2.core.IC2;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityFuelGeneratorBase;
import ic2.core.block.base.util.info.FuelMachineInfo;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.filters.FluidFilter;
import ic2.core.inventory.filters.InvertedFilter;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2GuiComp;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Resources;
import ic2.core.platform.registry.Ic2Sounds;
import ic2.core.util.math.Box2D;
import ic2.core.util.misc.FluidHelper;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IClickable;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityGeoGenerator
extends TileEntityFuelGeneratorBase
implements IHasGui,
IFluidHandler,
IFuelMachine,
IClickable {
    public static int maxLava = 24000;

    public TileEntityGeoGenerator() {
        super(2);
        this.maxStorage = this.production = IC2.config.getInt("energyGeneratorGeo");
        this.addInfos(new FuelMachineInfo(this));
    }

    @Override
    protected void addSlots(InventoryHandler handler) {
        FluidFilter filter = new FluidFilter(FluidRegistry.LAVA);
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Both, 0, 1);
        handler.registerDefaultSlotsForSide(RotationList.ALL, 0);
        handler.registerInputFilter(filter, 1);
        handler.registerOutputFilter(new InvertedFilter(filter), 1);
        handler.registerInputFilter(CommonFilters.ChargeEU, 0);
        handler.registerSlotType(SlotType.Charge, 0);
        handler.registerSlotType(SlotType.FluidFuel, 1);
    }

    @Override
    public float getFuel() {
        return this.fuel;
    }

    @Override
    public float getMaxFuel() {
        return maxLava;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.geothermalGen;
    }

    @Override
    public ResourceLocation getTexture() {
        return Ic2Resources.geothermalGenerator;
    }

    @Override
    public Box2D getFuelBox() {
        return Ic2GuiComp.generatorFuelBox;
    }

    @Override
    public Box2D getEnergyBox() {
        return Ic2GuiComp.geoGeneratorEnergyBox;
    }

    @Override
    public boolean delayActiveUpdate() {
        return true;
    }

    @Override
    public int getDelay() {
        return 60;
    }

    @Override
    public boolean gainFuel() {
        if (((ItemStack)this.inventory.get(1)).func_190926_b() || maxLava - this.fuel < 1000) {
            return false;
        }
        if (StackUtil.isStackEqual((ItemStack)this.inventory.get(1), Ic2Items.lavaCell)) {
            this.fuel += 1000;
            ((ItemStack)this.inventory.get(1)).func_190918_g(1);
            return true;
        }
        return FluidHelper.drainContainers(this, this, 1);
    }

    @Override
    public boolean needsFuel() {
        return this.fuel <= maxLava;
    }

    @Override
    public ResourceLocation getOperationSoundFile() {
        return Ic2Sounds.geothermalLoop;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{new FluidTankProperties(new FluidStack(FluidRegistry.LAVA, this.fuel), maxLava)};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null || resource.getFluid() != FluidRegistry.LAVA) {
            return 0;
        }
        int toAdd = Math.min(resource.amount, maxLava - this.fuel);
        if (doFill) {
            this.fuel += toAdd;
            this.getNetwork().updateTileGuiField(this, "fuel");
        }
        return toAdd;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource != null && resource.getFluid() == FluidRegistry.LAVA) {
            return this.drain(resource.amount, doDrain);
        }
        return null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        int amount = Math.min(maxDrain, this.fuel);
        if (amount <= 0) {
            return null;
        }
        if (doDrain) {
            this.fuel -= amount;
            this.getNetwork().updateTileGuiField(this, "fuel");
        }
        return new FluidStack(FluidRegistry.LAVA, amount);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? this : super.getCapability(capability, facing));
    }

    @Override
    public boolean hasRightClick() {
        return true;
    }

    @Override
    public boolean onRightClick(EntityPlayer player, EnumHand hand, EnumFacing face, Side side) {
        if (24000 - this.fuel < 1000) {
            return false;
        }
        ItemStack playerStack = player.func_184586_b(hand);
        if (!playerStack.func_190926_b()) {
            if (StackUtil.isStackEqual(playerStack, Ic2Items.lavaCell)) {
                playerStack.func_190918_g(1);
                this.fuel += 1000;
                this.getNetwork().updateTileGuiField(this, "fuel");
                return true;
            }
            ItemStack result = FluidUtil.tryEmptyContainer((ItemStack)playerStack, (IFluidHandler)this, (int)(24000 - this.fuel), (EntityPlayer)player, (boolean)true).getResult();
            if (!result.func_190926_b()) {
                playerStack.func_190918_g(1);
                if (!player.field_71071_by.func_70441_a(result)) {
                    player.func_71019_a(result, false);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasLeftClick() {
        return false;
    }

    @Override
    public void onLeftClick(EntityPlayer player, Side side) {
    }
}

