/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.high;

import com.google.common.base.Strings;
import ic2.api.classic.audio.PositionSpec;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.recipe.ClassicRecipes;
import ic2.api.classic.tile.ITeleporterTarget;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.tile.IEnergyStorage;
import ic2.core.Direction;
import ic2.core.IC2;
import ic2.core.audio.AudioSource;
import ic2.core.block.base.tile.TileEntityBlock;
import ic2.core.entity.boat.EntityClassicBoat;
import ic2.core.inventory.transport.IItemTransporter;
import ic2.core.inventory.transport.TransporterManager;
import ic2.core.platform.registry.Ic2Sounds;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityTeleporter
extends TileEntityBlock
implements ITickable,
ITeleporterTarget {
    @NetworkField(index=3)
    public boolean targetSet;
    @NetworkField(index=4)
    public BlockPos targetPos;
    @NetworkField(index=5)
    public int targetDimension;
    public AudioSource audioSource;
    private int delay;
    private int activeDelay;
    private IEnergyEmitter fake;
    private Set<ITeleporterTarget.TeleportType> receivers = EnumSet.noneOf(ITeleporterTarget.TeleportType.class);
    private boolean updateReceivers = false;

    public TileEntityTeleporter() {
        this.addNetworkFields("targetSet", "targetPos", "targetDimension");
    }

    @Override
    public boolean canSetFacing(EntityPlayer player, EnumFacing facing) {
        return this.getFacing() != facing;
    }

    @Override
    public boolean canRemoveBlock(EntityPlayer player) {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.targetSet = nbt.func_74767_n("TargetSet");
        if (!this.targetSet) {
            this.targetPos = null;
            this.targetDimension = 0;
            return;
        }
        this.targetPos = new BlockPos(nbt.func_74762_e("TargetX"), nbt.func_74762_e("TargetY"), nbt.func_74762_e("TargetZ"));
        this.targetDimension = nbt.func_74762_e("TargetDim");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("TargetSet", this.targetSet);
        if (this.targetSet) {
            nbt.func_74768_a("TargetX", this.targetPos.func_177958_n());
            nbt.func_74768_a("TargetY", this.targetPos.func_177956_o());
            nbt.func_74768_a("TargetZ", this.targetPos.func_177952_p());
            nbt.func_74768_a("TargetDim", this.targetDimension);
        }
        return nbt;
    }

    @Override
    public void setTarget(ITeleporterTarget.TeleporterTarget target) {
        this.targetDimension = target.getDimID();
        this.targetPos = target.getPos();
        this.targetSet = true;
        this.getNetwork().updateTileEntityField(this, "targetSet");
        this.getNetwork().updateTileEntityField(this, "targetPos");
        this.getNetwork().updateTileEntityField(this, "targetDimension");
    }

    @Override
    public boolean hasTarget(ITeleporterTarget.TeleporterTarget target) {
        if (this.targetSet) {
            return this.targetDimension == target.getDimID() && this.targetPos.equals((Object)target.getPos());
        }
        return false;
    }

    @Override
    public BlockPos getPosition() {
        return this.func_174877_v();
    }

    @Override
    public World getWorldObj() {
        return this.func_145831_w();
    }

    @Override
    public void onBlockUpdate(Block block) {
        super.onBlockUpdate(block);
        this.updateReceivers = true;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.isSimulating()) {
            this.updateReceivers = true;
            if (Strings.isNullOrEmpty((String)this.customName)) {
                ITeleporterTarget.TeleporterNameRegistry.removeTeleporter(new ITeleporterTarget.TeleporterTarget(this));
            } else {
                ITeleporterTarget.TeleporterNameRegistry.addTeleporter(new ITeleporterTarget.TeleporterTarget(this), this.customName);
            }
        }
    }

    @Override
    public void setCustomName(String name) {
        super.setCustomName(name);
        if (Strings.isNullOrEmpty((String)name)) {
            ITeleporterTarget.TeleporterNameRegistry.removeTeleporter(new ITeleporterTarget.TeleporterTarget(this));
        } else {
            ITeleporterTarget.TeleporterNameRegistry.addTeleporter(new ITeleporterTarget.TeleporterTarget(this), this.customName);
        }
    }

    @Override
    public void onUnloaded() {
        if (this.isSimulating()) {
            ITeleporterTarget.TeleporterNameRegistry.removeTeleporter(new ITeleporterTarget.TeleporterTarget(this));
        }
        super.onUnloaded();
    }

    @Override
    public boolean canUpdate() {
        return this.isSimulating();
    }

    @Override
    public boolean needsInitialRedstoneUpdate() {
        return true;
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_82737_E() % 40L == 0L || this.updateReceivers) {
            this.updateReceivers = false;
            this.updateReceiverInfo();
        }
        if (!this.targetSet) {
            if (this.getActive()) {
                this.setActive(false);
            }
            return;
        }
        boolean server = this.isSimulating();
        if (server && this.targetSet) {
            this.handleRedstone();
            if (this.delay > 0 && !this.isRedstonePowered()) {
                --this.delay;
            }
            if (this.delay == 0 && this.isRedstonePowered()) {
                World targetWorld = this.getTargetWorld();
                if (targetWorld == null) {
                    this.setActive(false);
                    this.targetSet = false;
                    this.targetPos = null;
                    this.targetDimension = 0;
                    return;
                }
                this.delay = 20;
                this.activeDelay = 10;
                ITeleporterTarget.TeleportType type = this.getSendingType();
                if (type == ITeleporterTarget.TeleportType.None) {
                    return;
                }
                if (type == ITeleporterTarget.TeleportType.Item) {
                    this.handleItems(targetWorld);
                } else if (type == ITeleporterTarget.TeleportType.Fluid) {
                    this.handleFluids(targetWorld);
                } else if (type == ITeleporterTarget.TeleportType.Energy) {
                    this.handleEnergy(targetWorld);
                } else {
                    this.handleEntity(targetWorld);
                }
            } else if (this.activeDelay > 0) {
                --this.activeDelay;
            } else {
                this.setActive(false);
            }
        }
    }

    public void updateReceiverInfo() {
        this.receivers.clear();
        TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(this.getFacing()));
        if (tile == null) {
            this.receivers.add(ITeleporterTarget.TeleportType.Entity);
            return;
        }
        EnumFacing oppo = this.getFacing().func_176734_d();
        if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, oppo) || tile instanceof IInventory) {
            this.receivers.add(ITeleporterTarget.TeleportType.Item);
        }
        if (tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, oppo)) {
            this.receivers.add(ITeleporterTarget.TeleportType.Fluid);
        }
        if (tile instanceof IEnergyStorage || tile instanceof IEnergySink) {
            this.receivers.add(ITeleporterTarget.TeleportType.Energy);
        }
        if (this.receivers.isEmpty()) {
            this.receivers.add(ITeleporterTarget.TeleportType.Entity);
        }
    }

    public void handleEnergy(World targetWorld) {
        TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(this.getFacing()));
        if (!(tile instanceof IEnergyStorage)) {
            return;
        }
        IEnergyStorage storage = (IEnergyStorage)tile;
        int energyProvided = storage.getStored();
        if (energyProvided <= 0) {
            return;
        }
        TileEntity otherTele = targetWorld.func_175625_s(this.targetPos);
        if (!TileEntityTeleporter.isTeleporter(otherTele)) {
            this.setActive(false);
            this.targetSet = false;
            this.targetPos = null;
            this.targetDimension = 0;
            return;
        }
        if (!TileEntityTeleporter.isSameType(otherTele, ITeleporterTarget.TeleportType.Energy)) {
            this.setActive(false);
            return;
        }
        EnumFacing oppo = ((ITeleporterTarget)otherTele).getTeleporterFacing().func_176734_d();
        TileEntity targetTile = targetWorld.func_175625_s(this.targetPos.func_177972_a(oppo.func_176734_d()));
        if (!(targetTile instanceof IEnergyStorage) && !(targetTile instanceof IEnergySink)) {
            return;
        }
        boolean dimSwitch = this.field_145850_b.field_73011_w.getDimension() != this.targetDimension;
        int cost = (int)Math.pow(Math.sqrt(this.getDistance(this.func_174877_v(), this.targetPos)) + 10.0, dimSwitch ? 0.9 : 0.7);
        if (cost > this.getAvailableEnergy()) {
            return;
        }
        this.setActive(true);
        this.useEnergy(cost);
        if (targetTile instanceof IEnergyStorage) {
            IEnergyStorage target = (IEnergyStorage)targetTile;
            int wanted = target.getCapacity() - target.getStored();
            int stored = target.getStored();
            if (wanted <= 0) {
                return;
            }
            if (wanted > energyProvided) {
                wanted = energyProvided;
            }
            target.setStored(stored + wanted);
            energyProvided -= wanted;
        } else {
            IEnergySink sink;
            IEnergyTile targetEnergy = EnergyNet.instance.getTile(targetWorld, this.targetPos.func_177972_a(oppo.func_176734_d()));
            if (targetEnergy instanceof IEnergySink && (sink = (IEnergySink)targetEnergy).acceptsEnergyFrom(this.getEmitter(), oppo)) {
                int left;
                int inject;
                int maxIn = (int)EnergyNet.instance.getPowerFromTier(sink.getSinkTier());
                int wanted = (int)sink.getDemandedEnergy();
                if (wanted < 1) {
                    return;
                }
                for (int i = 0; i < 500 && wanted >= 1 && energyProvided >= 1; energyProvided -= inject - left, ++i) {
                    inject = Math.min(maxIn, Math.min(energyProvided, wanted));
                    left = (int)sink.injectEnergy(oppo, inject, maxIn);
                    wanted = (int)sink.getDemandedEnergy();
                }
            }
        }
        storage.setStored(energyProvided);
    }

    public void handleFluids(World targetWorld) {
        TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(this.getFacing()));
        EnumFacing opposite = this.getFacing().func_176734_d();
        if (tile == null || !ClassicRecipes.teleRegistry.isValidTank(tile) || !tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, opposite)) {
            return;
        }
        IFluidHandler sender = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, opposite);
        if (sender == null) {
            return;
        }
        TileEntity otherTele = targetWorld.func_175625_s(this.targetPos);
        if (!TileEntityTeleporter.isTeleporter(otherTele)) {
            this.setActive(false);
            this.targetSet = false;
            this.targetPos = null;
            this.targetDimension = 0;
            return;
        }
        if (!TileEntityTeleporter.isSameType(otherTele, ITeleporterTarget.TeleportType.Fluid)) {
            this.setActive(false);
            return;
        }
        EnumFacing oppo = ((ITeleporterTarget)otherTele).getTeleporterFacing().func_176734_d();
        TileEntity targetTile = targetWorld.func_175625_s(this.targetPos.func_177972_a(oppo.func_176734_d()));
        if (targetTile == null || !targetTile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, oppo)) {
            return;
        }
        IFluidHandler targetTank = (IFluidHandler)targetTile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, oppo);
        if (targetTank == null) {
            return;
        }
        IFluidTankProperties[] array = sender.getTankProperties();
        if (array == null || array.length == 0) {
            return;
        }
        this.setActive(true);
        boolean dimSwitch = this.field_145850_b.field_73011_w.getDimension() != this.targetDimension;
        double distanceCost = Math.pow(Math.sqrt(this.getDistance(this.func_174877_v(), this.targetPos)) + 10.0, dimSwitch ? 0.9 : 0.7);
        int aviableEnergy = this.getAvailableEnergy();
        int usedEnergy = 0;
        for (int i = 0; i < array.length; ++i) {
            FluidStack simulated;
            IFluidTankProperties prop = array[i];
            FluidStack propFluid = prop.getContents();
            if (!prop.canDrain() || propFluid == null || !prop.canDrainFluidType(propFluid) || (simulated = sender.drain(propFluid, false)) == null) continue;
            int weight = this.getWeightOfFluid(simulated);
            int cost = (int)((double)weight * distanceCost);
            if (cost > aviableEnergy - usedEnergy) break;
            usedEnergy += cost;
            int added = targetTank.fill(simulated.copy(), true);
            if (added <= 0) continue;
            FluidStack realDrain = simulated.copy();
            realDrain.amount = added;
            sender.drain(realDrain, true);
        }
        this.useEnergy(usedEnergy);
    }

    public void handleItems(World targetWorld) {
        TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(this.getFacing()));
        EnumFacing opposite = this.getFacing().func_176734_d();
        if (tile == null || !ClassicRecipes.teleRegistry.isValidInventory(tile) || !tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, opposite)) {
            return;
        }
        IItemHandler sender = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, opposite);
        if (sender == null) {
            return;
        }
        TileEntity otherTele = targetWorld.func_175625_s(this.targetPos);
        if (!TileEntityTeleporter.isTeleporter(otherTele)) {
            this.setActive(false);
            this.targetSet = false;
            this.targetPos = null;
            this.targetDimension = 0;
            return;
        }
        if (!TileEntityTeleporter.isSameType(otherTele, ITeleporterTarget.TeleportType.Item)) {
            this.setActive(false);
            return;
        }
        EnumFacing oppo = ((ITeleporterTarget)otherTele).getTeleporterFacing().func_176734_d();
        TileEntity targetTile = targetWorld.func_175625_s(this.targetPos.func_177972_a(oppo.func_176734_d()));
        if (targetTile == null || !targetTile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, oppo)) {
            return;
        }
        this.setActive(true);
        boolean dimSwitch = this.field_145850_b.field_73011_w.getDimension() != this.targetDimension;
        double distanceCost = Math.pow(Math.sqrt(this.getDistance(this.func_174877_v(), this.targetPos)) + 10.0, dimSwitch ? 0.9 : 0.7);
        int aviableWeight = (int)((double)this.getAvailableEnergy() / distanceCost);
        int usedWeight = 0;
        IItemTransporter transporter = TransporterManager.manager.getTransporter(targetTile, false);
        int slot = 0;
        while (slot < sender.getSlots()) {
            ItemStack compareStack = sender.getStackInSlot(slot);
            if (compareStack.func_190926_b()) {
                ++slot;
                continue;
            }
            ItemStack sendingStack = sender.extractItem(slot, compareStack.func_190916_E(), true);
            if (sendingStack.func_190926_b()) {
                ++slot;
                continue;
            }
            int weight = this.getWeightOfItem(sendingStack);
            if (weight > aviableWeight - usedWeight) break;
            ItemStack injected = transporter.addItem(sendingStack, oppo, true);
            if (injected != null && injected.func_190916_E() > 0) {
                usedWeight += this.getWeightOfItem(injected);
                sender.extractItem(slot, injected.func_190916_E(), false);
                if (!sender.getStackInSlot(slot).func_190926_b()) continue;
                ++slot;
                continue;
            }
            ++slot;
        }
        transporter.onFinishedActions();
        if (usedWeight < 1) {
            usedWeight = 1;
        }
        this.useEnergy((int)((double)usedWeight * distanceCost));
    }

    public void handleEntity(World targetWorld) {
        List entitiesNearby = this.field_145850_b.func_72872_a(Entity.class, new AxisAlignedBB(this.func_174877_v().func_177982_a(-2, -3, -2), this.func_174877_v().func_177982_a(2, 3, 2)));
        if (entitiesNearby.size() > 0) {
            TileEntity otherTele = targetWorld.func_175625_s(this.targetPos);
            if (!TileEntityTeleporter.isTeleporter(otherTele)) {
                this.setActive(false);
                this.targetSet = false;
                this.targetPos = null;
                this.targetDimension = 0;
                return;
            }
            if (!TileEntityTeleporter.isSameType(otherTele, ITeleporterTarget.TeleportType.Entity)) {
                this.setActive(false);
                return;
            }
            this.setActive(true);
            double minDistanceSquared = Double.MAX_VALUE;
            Entity closestEntity = null;
            BlockPos offset = this.field_174879_c.func_177972_a(this.getFacing());
            int x = offset.func_177958_n();
            int y = offset.func_177956_o();
            int z = offset.func_177952_p();
            for (Entity entity : entitiesNearby) {
                double distSquared;
                if (entity.func_184187_bx() != null || entity.field_70128_L || (distSquared = ((double)x - entity.field_70165_t) * ((double)x - entity.field_70165_t) + ((double)y - entity.field_70163_u) * ((double)y - entity.field_70163_u) + ((double)z - entity.field_70161_v) * ((double)z - entity.field_70161_v)) >= minDistanceSquared) continue;
                minDistanceSquared = distSquared;
                closestEntity = entity;
            }
            if (closestEntity == null) {
                return;
            }
            this.teleportEntity(closestEntity, ((ITeleporterTarget)otherTele).getTeleporterFacing());
        }
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("isActive") && this.isActiveChanged()) {
            if (this.audioSource != null && this.audioSource.isRemoved()) {
                this.audioSource = null;
            }
            if (this.audioSource == null) {
                this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, Ic2Sounds.teleporterCharge, true, false, IC2.audioManager.defaultVolume);
            }
            if (this.getActive()) {
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
            } else if (this.audioSource != null) {
                this.audioSource.stop();
            }
        }
        super.onNetworkUpdate(field);
    }

    private void spawnBlueParticles(int count, World world, BlockPos pos) {
        if (this.field_145850_b == null) {
            this.field_145850_b = world;
        }
        for (int i = 0; i < count; ++i) {
            world.func_175688_a(EnumParticleTypes.REDSTONE, (double)((float)pos.func_177958_n() + world.field_73012_v.nextFloat()), (double)((float)(pos.func_177956_o() + 1) + world.field_73012_v.nextFloat()), (double)((float)pos.func_177952_p() + world.field_73012_v.nextFloat()), -1.0, 0.0, 1.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.REDSTONE, (double)((float)pos.func_177958_n() + world.field_73012_v.nextFloat()), (double)((float)(pos.func_177956_o() + 2) + world.field_73012_v.nextFloat()), (double)((float)pos.func_177952_p() + world.field_73012_v.nextFloat()), -1.0, 0.0, 1.0, new int[0]);
        }
    }

    private double getDistance(BlockPos key, BlockPos value) {
        return key.func_177951_i((Vec3i)value);
    }

    public void teleportEntity(Entity entity, EnumFacing side) {
        boolean dimSwitch;
        int weight = TileEntityTeleporter.getWeightOfUser(entity);
        if (weight == 0) {
            return;
        }
        double distance = Math.sqrt(this.getDistance(this.func_174877_v(), this.targetPos));
        int energyCost = (int)((double)weight * Math.pow(distance + 10.0, (dimSwitch = this.field_145850_b.field_73011_w.getDimension() != this.targetDimension) ? 0.9 : 0.7) * 5.0);
        if (energyCost > this.getAvailableEnergy()) {
            return;
        }
        entity.func_184210_p();
        entity.func_184226_ay();
        this.useEnergy(energyCost);
        if (entity instanceof EntityPlayer) {
            IC2.achievements.issueStat((EntityPlayer)entity, "distanceTeleported", (int)distance);
            if (distance >= 1000.0) {
                IC2.achievements.issueStat((EntityPlayer)entity, "teleportFarAway");
            }
        }
        double x = (float)(this.targetPos.func_177958_n() + side.func_82601_c()) + 0.5f;
        double y = (float)(this.targetPos.func_177956_o() + side.func_96559_d()) + 0.5f + entity.func_70047_e();
        double z = (float)(this.targetPos.func_177952_p() + side.func_82599_e()) + 0.5f;
        if (side.func_176740_k().func_176720_b()) {
            y = side.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? (double)this.targetPos.func_177956_o() - 2.5 : (double)((float)this.targetPos.func_177956_o() + entity.func_70047_e());
        }
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            if (!IC2.config.getFlag("TeleporterInventory")) {
                player.field_71071_by.func_70436_m();
            }
            if (dimSwitch) {
                entity.func_70080_a(x, y, z, entity.field_70177_z, entity.field_70125_A);
            } else {
                player.func_70634_a(x, y, z);
            }
        } else if (dimSwitch) {
            entity.func_70080_a(x, y, z, entity.field_70177_z, entity.field_70125_A);
        } else {
            entity.func_70634_a(x, y, z);
        }
        if (dimSwitch) {
            this.switchDimension(entity);
        }
    }

    public void switchDimension(Entity entity) {
        if (entity instanceof EntityPlayerMP) {
            TileEntityTeleporter.transferPlayerToDimension((EntityPlayerMP)entity, this.targetDimension);
        } else {
            TileEntityTeleporter.transferEntityToWorld(entity, (WorldServer)this.field_145850_b, (WorldServer)this.getTargetWorld());
        }
    }

    public static void transferEntityToWorld(Entity entity, WorldServer oldWorld, WorldServer newWorld) {
        oldWorld.func_72973_f(entity);
        entity.field_70128_L = false;
        entity.field_71093_bK = newWorld.field_73011_w.getDimension();
        if (entity.func_70089_S()) {
            entity.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
            newWorld.func_72838_d(entity);
            newWorld.func_72866_a(entity, false);
        }
        entity.func_70029_a((World)newWorld);
    }

    public static void transferPlayerToDimension(EntityPlayerMP player, int dimension) {
        MinecraftServer server = IC2.platform.getServer();
        PlayerList list = server.func_184103_al();
        int oldDim = player.field_71093_bK;
        WorldServer worldserver = server.func_71218_a(player.field_71093_bK);
        player.field_71093_bK = dimension;
        WorldServer worldserver1 = server.func_71218_a(player.field_71093_bK);
        player.field_71135_a.func_147359_a((Packet)new SPacketRespawn(player.field_71093_bK, player.field_70170_p.func_175659_aa(), player.field_70170_p.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
        worldserver.func_72973_f((Entity)player);
        player.field_70128_L = false;
        if (player.func_70089_S()) {
            player.func_70012_b(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
            worldserver1.func_72838_d((Entity)player);
            worldserver1.func_72866_a((Entity)player, false);
        }
        player.func_70029_a((World)worldserver1);
        list.func_72375_a(player, worldserver);
        player.field_71135_a.func_147364_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
        player.field_71134_c.func_73080_a(worldserver1);
        list.func_72354_b(player, worldserver1);
        list.func_72385_f(player);
        for (PotionEffect potioneffect : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), potioneffect));
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, oldDim, dimension);
    }

    public void useEnergy(int cost) {
        ArrayList<IEnergyStorage> energySources = new ArrayList<IEnergyStorage>();
        for (Direction direction : Direction.directions) {
            IEnergyStorage energySource;
            TileEntity target;
            if (direction.toFacing() == this.getFacing() || !((target = direction.applyToTileEntity(this)) instanceof IEnergyStorage) || !(energySource = (IEnergyStorage)target).isTeleporterCompatible(direction.getInverse().toFacing()) || energySource.getStored() <= 0) continue;
            energySources.add(energySource);
        }
        while (cost > 0) {
            int drain = (cost + energySources.size() - 1) / energySources.size();
            Iterator it = energySources.iterator();
            while (it.hasNext()) {
                IEnergyStorage energySource = (IEnergyStorage)it.next();
                if (drain > cost) {
                    drain = cost;
                }
                if (energySource.getStored() <= drain) {
                    cost -= energySource.getStored();
                    energySource.setStored(0);
                    it.remove();
                    continue;
                }
                cost -= drain;
                energySource.addEnergy(-drain);
            }
        }
    }

    public int getAvailableEnergy() {
        long energy = 0L;
        for (Direction direction : Direction.directions) {
            IEnergyStorage storage;
            TileEntity target;
            if (direction.toFacing() == this.getFacing() || !((target = direction.applyToTileEntity(this)) instanceof IEnergyStorage) || !(storage = (IEnergyStorage)target).isTeleporterCompatible(direction.getInverse().toFacing())) continue;
            energy += (long)storage.getStored();
        }
        return energy > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)energy;
    }

    public World getTargetWorld() {
        return IC2.platform.getServer().func_71218_a(this.targetDimension);
    }

    @Override
    public ITeleporterTarget.TeleportType getSendingType() {
        if (!this.targetSet) {
            return ITeleporterTarget.TeleportType.None;
        }
        TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(this.getFacing()));
        if (ClassicRecipes.teleRegistry.isValidInventory(tile)) {
            return ITeleporterTarget.TeleportType.Item;
        }
        if (ClassicRecipes.teleRegistry.isValidTank(tile)) {
            return ITeleporterTarget.TeleportType.Fluid;
        }
        if (tile instanceof IEnergyStorage) {
            return ITeleporterTarget.TeleportType.Energy;
        }
        return ITeleporterTarget.TeleportType.Entity;
    }

    @Override
    public boolean canReceiveType(ITeleporterTarget.TeleportType type) {
        if (this.receivers.isEmpty()) {
            this.updateReceiverInfo();
        }
        return this.receivers.contains((Object)type);
    }

    public int getWeightOfFluid(FluidStack fluid) {
        return 1 + fluid.amount / 10;
    }

    public int getWeightOfItem(ItemStack stack) {
        return 100 * (stack.func_190916_E() / stack.func_77976_d());
    }

    public static int getWeightOfUser(Entity entity) {
        int totalWeight = 0;
        if (entity instanceof EntityItem) {
            ItemStack is = ((EntityItem)entity).func_92059_d();
            totalWeight += 100 * is.func_190916_E() / is.func_77976_d();
        } else if (entity instanceof EntityAnimal || entity instanceof EntityMinecart || entity instanceof EntityBoat || entity instanceof EntityClassicBoat) {
            totalWeight += 100;
        } else if (entity instanceof EntityPlayer) {
            totalWeight += 1000;
            if (IC2.config.getFlag("TeleporterInventory")) {
                InventoryPlayer inv = ((EntityPlayer)entity).field_71071_by;
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack stack = inv.func_70301_a(i);
                    if (stack == null) continue;
                    totalWeight += 100 * stack.func_190916_E() / stack.func_77976_d();
                }
            }
        } else if (entity instanceof EntityGhast) {
            totalWeight += 2500;
        } else if (entity instanceof EntityDragon || entity instanceof EntityWither) {
            totalWeight += 10000;
        } else if (entity instanceof EntityCreature) {
            totalWeight += 500;
        }
        if (IC2.config.getFlag("TeleporterInventory") && entity instanceof EntityLivingBase && !(entity instanceof EntityPlayer)) {
            EntityLivingBase living = (EntityLivingBase)entity;
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                ItemStack item = living.func_184582_a(slot);
                if (item == null) continue;
                totalWeight += 100 * item.func_190916_E() / item.func_77976_d();
            }
        }
        for (Entity rider : entity.func_184188_bt()) {
            totalWeight += TileEntityTeleporter.getWeightOfUser(rider);
        }
        return totalWeight;
    }

    public static boolean isTeleporter(TileEntity tile) {
        return tile instanceof ITeleporterTarget;
    }

    public static boolean isSameType(TileEntity tile, ITeleporterTarget.TeleportType type) {
        if (!(tile instanceof ITeleporterTarget)) {
            return false;
        }
        return ((ITeleporterTarget)tile).canReceiveType(type);
    }

    public IEnergyEmitter getEmitter() {
        if (this.fake == null) {
            this.fake = new IEnergyEmitter(){

                @Override
                public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
                    return true;
                }
            };
        }
        return this.fake;
    }

    public boolean isDimSwitch() {
        return this.targetDimension != this.field_145850_b.field_73011_w.getDimension();
    }

    public double getDistance() {
        if (this.targetSet) {
            if (this.targetPos == null) {
                return 0.0;
            }
            return Math.sqrt(this.getDistance(this.func_174877_v(), this.targetPos));
        }
        return 0.0;
    }

    @Override
    public EnumFacing getTeleporterFacing() {
        return this.getFacing();
    }
}

