/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.high;

import ic2.api.classic.audio.PositionSpec;
import ic2.api.classic.item.ISortedTerraformerBP;
import ic2.api.item.ITerraformingBP;
import ic2.core.IC2;
import ic2.core.audio.AudioSource;
import ic2.core.block.base.tile.TileEntityElecMachine;
import ic2.core.block.machine.high.logic.terraformer.ITerraformerLogic;
import ic2.core.block.machine.high.logic.terraformer.NewTerraformLogic;
import ic2.core.block.machine.high.logic.terraformer.OldTerraformLogic;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.network.PacketManager;
import ic2.core.network.packets.server.BiomeUpdatePacket;
import ic2.core.platform.registry.Ic2Sounds;
import ic2.core.util.helpers.AabbUtil;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IClickable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityTerraformer
extends TileEntityElecMachine
implements ITickable,
IClickable {
    ITerraformerLogic oldLogic = new OldTerraformLogic();
    ITerraformerLogic newLogic = new NewTerraformLogic();
    public AudioSource audioSource = null;
    public int inactiveTicks = 0;

    public TileEntityTerraformer() {
        super(1, 512);
        this.maxEnergy = 100000;
    }

    @Override
    public InventoryHandler getHandler() {
        return null;
    }

    @Override
    public boolean supportsNotify() {
        return false;
    }

    public void func_73660_a() {
        boolean newActive = false;
        ITerraformingBP print = this.getBluePrint();
        if (print != null) {
            int needed = (int)print.getConsume((ItemStack)this.inventory.get(0));
            ITerraformerLogic logic = this.getLogic(print, (ItemStack)this.inventory.get(0));
            if (logic.canRun() && this.hasEnergy(needed)) {
                newActive = true;
                if (logic.work(this.func_145831_w(), this.func_174877_v(), (ItemStack)this.inventory.get(0), print)) {
                    this.useEnergy(needed);
                } else {
                    this.useEnergy(needed / 10);
                }
            }
        }
        if (newActive) {
            this.inactiveTicks = 0;
            this.setActive(true);
        } else if (!newActive && this.getActive() && this.inactiveTicks++ > 60) {
            this.setActive(false);
        }
    }

    public ITerraformingBP getBluePrint() {
        if (!(((ItemStack)this.inventory.get(0)).func_77973_b() instanceof ITerraformingBP)) {
            return null;
        }
        return (ITerraformingBP)((ItemStack)this.inventory.get(0)).func_77973_b();
    }

    public ITerraformerLogic getLogic(ITerraformingBP bp, ItemStack stack) {
        if (bp instanceof ISortedTerraformerBP) {
            return ((ISortedTerraformerBP)bp).needsSortedLogic(stack) ? this.newLogic : this.oldLogic;
        }
        return this.oldLogic;
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("isActive") && this.isActiveChanged()) {
            if (this.audioSource != null && this.audioSource.isRemoved()) {
                this.audioSource = null;
            }
            if (this.audioSource == null) {
                this.audioSource = IC2.audioManager.createSource(this, PositionSpec.Center, Ic2Sounds.terraformerOp, true, false, IC2.audioManager.defaultVolume);
            }
            if (this.getActive()) {
                if (this.audioSource != null) {
                    this.audioSource.play();
                }
            } else if (this.audioSource != null) {
                this.audioSource.stop();
            }
        }
        super.onNetworkUpdate(field);
    }

    @Override
    public void onUnloaded() {
        if (this.isRendering() && this.audioSource != null) {
            IC2.audioManager.removeSources(this);
            this.audioSource = null;
        }
        super.onUnloaded();
    }

    public boolean ejectBlueprint() {
        if (((ItemStack)this.inventory.get(0)).func_190926_b()) {
            return false;
        }
        if (this.isSimulating()) {
            StackUtil.dropAsEntity(this.field_145850_b, this.func_174877_v(), (ItemStack)this.inventory.get(0));
            this.inventory.set(0, (Object)ItemStack.field_190927_a);
            this.oldLogic.reset();
            this.newLogic.reset();
        }
        return true;
    }

    @Override
    public boolean hasLeftClick() {
        return false;
    }

    @Override
    public boolean hasRightClick() {
        return true;
    }

    @Override
    public boolean onRightClick(EntityPlayer player, EnumHand hand, EnumFacing face, Side side) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack != null && stack.func_77973_b() instanceof ITerraformingBP) {
            ITerraformingBP bp = (ITerraformingBP)stack.func_77973_b();
            if (!bp.canInsert(stack, player, this.func_145831_w(), this.func_174877_v())) {
                return false;
            }
            if (side == Side.CLIENT) {
                return true;
            }
            if (!((ItemStack)this.inventory.get(0)).func_190926_b()) {
                this.ejectBlueprint();
            }
            if (player.field_71075_bZ.field_75098_d) {
                this.inventory.set(0, (Object)StackUtil.copyWithSize(stack, 1));
                return true;
            }
            this.inventory.set(0, (Object)stack.func_77979_a(1));
            return true;
        }
        return false;
    }

    @Override
    public void onLeftClick(EntityPlayer player, Side side) {
    }

    @Override
    public boolean hasSpecialAction(EntityPlayer player, EnumFacing facing, Vec3d hit) {
        return !((ItemStack)this.inventory.get(0)).func_190926_b();
    }

    @Override
    public EnumActionResult doSpecialAction(EntityPlayer player, EnumFacing facing, Vec3d hit) {
        if (((ItemStack)this.inventory.get(0)).func_190926_b()) {
            return EnumActionResult.FAIL;
        }
        this.ejectBlueprint();
        return EnumActionResult.SUCCESS;
    }

    @Override
    public double getWrenchDropRate() {
        return 0.75;
    }

    @Override
    public boolean canSetFacing(EntityPlayer player, EnumFacing facing) {
        return false;
    }

    public static BlockPos getFirstSolidBlockFrom(World world, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(pos);
        while (mutable.func_177956_o() > -1) {
            if (world.func_175677_d((BlockPos)mutable, false)) {
                return mutable.func_185334_h();
            }
            mutable.func_189536_c(EnumFacing.DOWN);
        }
        return mutable.func_185334_h();
    }

    public static BlockPos getFirstBlockFrom(World world, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(pos);
        while (mutable.func_177956_o() > 0) {
            if (!world.func_175623_d((BlockPos)mutable)) {
                return mutable.func_185334_h();
            }
            mutable.func_189536_c(EnumFacing.DOWN);
        }
        mutable.func_185336_p(-1);
        return mutable.func_185334_h();
    }

    public static boolean switchGround(World world, IBlockState from, IBlockState to, BlockPos pos, boolean upwards, boolean metaCompare) {
        IBlockState state;
        if (upwards) {
            IBlockState state2;
            BlockPos.MutableBlockPos targetPos = new BlockPos.MutableBlockPos(pos.func_177984_a());
            BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos(pos);
            BlockPos up = targetPos.func_185334_h();
            while (!(world.func_175623_d((BlockPos)checkPos) || (state2 = world.func_180495_p((BlockPos)checkPos)).func_177230_c() != from.func_177230_c() || metaCompare && TileEntityTerraformer.getMetaFromState(state2) != TileEntityTerraformer.getMetaFromState(from))) {
                targetPos.func_189536_c(EnumFacing.DOWN);
                checkPos.func_189536_c(EnumFacing.DOWN);
            }
            if (targetPos.func_177956_o() == up.func_177956_o()) {
                return false;
            }
            world.func_175656_a(targetPos.func_185334_h(), to);
            return true;
        }
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(pos);
        while (!(world.func_175623_d((BlockPos)mutable) || (state = world.func_180495_p((BlockPos)mutable)).func_177230_c() != to.func_177230_c() || metaCompare && TileEntityTerraformer.getMetaFromState(state) != TileEntityTerraformer.getMetaFromState(from))) {
            mutable.func_189536_c(EnumFacing.DOWN);
        }
        if (world.func_175623_d((BlockPos)mutable) || mutable.func_177956_o() < 0) {
            return false;
        }
        state = world.func_180495_p((BlockPos)mutable);
        if (state.func_177230_c() != from.func_177230_c() || metaCompare && TileEntityTerraformer.getMetaFromState(state) != TileEntityTerraformer.getMetaFromState(from)) {
            return false;
        }
        world.func_175656_a(mutable.func_185334_h(), to);
        return true;
    }

    public static Biome getBiomeAt(World world, BlockPos pos) {
        return world.func_180494_b(pos);
    }

    public static void setBiomeAt(World world, BlockPos pos, Biome biome) {
        byte[] biomeArray = world.func_175726_f(pos).func_76605_m();
        int index = (pos.func_177952_p() & 0xF) << 4 | pos.func_177958_n() & 0xF;
        biomeArray[index] = (byte)Biome.func_185362_a((Biome)biome);
        if (IC2.platform.isSimulating()) {
            BiomeUpdatePacket packet = null;
            int maxDistance = IC2.platform.getServer().func_184103_al().func_72372_a() + 16;
            for (EntityPlayer player : world.field_73010_i) {
                int distance = Math.min(Math.abs(pos.func_177958_n() - (int)player.field_70165_t), Math.abs(pos.func_177952_p() - (int)player.field_70161_v));
                if (distance > maxDistance) continue;
                if (packet == null) {
                    packet = new BiomeUpdatePacket(world, new ChunkPos(pos), index, (byte)Biome.func_185362_a((Biome)biome));
                }
                PacketManager.instance.sendToPlayer(packet, player);
            }
        }
    }

    static int getMetaFromState(IBlockState state) {
        return state.func_177230_c().func_176201_c(state);
    }

    public static class AnyFilter
    implements AabbUtil.IBlockFilter {
        public static AabbUtil.IBlockFilter filter = new AnyFilter();

        @Override
        public boolean isValidBlock(IBlockState state) {
            return true;
        }

        @Override
        public boolean isValidBlock(World world, BlockPos pos) {
            return true;
        }

        @Override
        public boolean forceChunkLoad() {
            return false;
        }
    }
}

