/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.low;

import ic2.api.classic.recipe.ClassicRecipes;
import ic2.api.classic.recipe.machine.IMachineRecipeList;
import ic2.api.classic.recipe.machine.MachineOutput;
import ic2.api.classic.tile.MachineType;
import ic2.api.recipe.IRecipeInput;
import ic2.core.block.base.tile.TileEntityBasicElectricMachine;
import ic2.core.block.machine.recipes.entries.UnpackageRecipe;
import ic2.core.inventory.gui.custom.MachineGui;
import ic2.core.item.recipe.AdvRecipeBase;
import ic2.core.item.recipe.entry.RecipeInputItemStack;
import ic2.core.item.recipe.entry.RecipeInputOreDict;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Resources;
import ic2.core.platform.registry.Ic2Sounds;
import ic2.core.util.misc.StackUtil;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class TileEntityExtractor
extends TileEntityBasicElectricMachine {
    public TileEntityExtractor() {
        super(3, 2, 400, 32);
    }

    @Override
    public IMachineRecipeList getRecipeList() {
        return ClassicRecipes.extractor;
    }

    @Override
    public MachineType getType() {
        return MachineType.extractor;
    }

    @Override
    public ResourceLocation getGuiTexture() {
        return Ic2Resources.extractor;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.extractor;
    }

    @Override
    public IMachineRecipeList.RecipeEntry getOutputFor(ItemStack input) {
        return ClassicRecipes.extractor.getRecipeInAndOutput(input, false);
    }

    @Override
    public double getWrenchDropRate() {
        return 0.85f;
    }

    @Override
    public boolean isValidInput(ItemStack par1) {
        if (par1 == null) {
            return false;
        }
        if (ClassicRecipes.extractor.getRecipeInAndOutput(par1, true) != null) {
            return super.isValidInput(par1);
        }
        return false;
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return MachineGui.ExtractorGui.class;
    }

    @Override
    public ResourceLocation getStartSoundFile() {
        return Ic2Sounds.extractorOp;
    }

    @Override
    public ResourceLocation getInterruptSoundFile() {
        return Ic2Sounds.interruptingSound;
    }

    public static void init() {
        TileEntityExtractor.addRecipe("oreCoal", 1, new ItemStack(Items.field_151044_h, 3), 0.3f);
        TileEntityExtractor.addRecipe("oreLapis", 1, new ItemStack(Items.field_151100_aR, 10, 4), 0.5f);
        TileEntityExtractor.addRecipe("oreDiamond", 1, new ItemStack(Items.field_151045_i, 3), 1.0f);
        TileEntityExtractor.addRecipe("oreEmerald", 1, new ItemStack(Items.field_151166_bC, 3), 1.0f);
        TileEntityExtractor.addRecipe(Ic2Items.rubberSapling.func_77946_l(), Ic2Items.rubber.func_77946_l());
        TileEntityExtractor.addRecipe("itemRawRubber", 1, StackUtil.copyWithSize(Ic2Items.rubber, 3), 0.2f);
        TileEntityExtractor.addRecipe("woodRubber", 1, Ic2Items.rubber.func_77946_l(), 0.2f);
        TileEntityExtractor.addRecipe("oreQuartz", 1, new ItemStack(Items.field_151128_bU, 4));
        TileEntityExtractor.addRecipe(new ItemStack(Blocks.field_150351_n), new ItemStack(Items.field_151145_ak, 2), 0.1f);
        TileEntityExtractor.addRecipe(Ic2Items.stickyDynamite.func_77946_l(), Ic2Items.dynamite.func_77946_l());
        TileEntityExtractor.addRecipe(Ic2Items.bioCell.func_77946_l(), Ic2Items.bioFuelCell.func_77946_l(), 0.1f);
        TileEntityExtractor.addRecipe(Ic2Items.woodGasCell.func_77946_l(), Ic2Items.bioFuelCell.func_77946_l(), 0.1f);
        TileEntityExtractor.addRecipe(Ic2Items.hydratedCoalCell.func_77946_l(), Ic2Items.coalFuelCell.func_77946_l(), 0.1f);
        TileEntityExtractor.addRecipe(Ic2Items.waterCell.func_77946_l(), Ic2Items.hydrationCell.func_77946_l(), 0.1f);
        TileEntityExtractor.addRecipe(Ic2Items.scrapBox.func_77946_l(), new UnpackageRecipe(), "ScrapboxUnpacking");
        TileEntityExtractor.addRecipe(new ItemStack((Block)Blocks.field_150327_N, 1, BlockFlower.EnumFlowerType.DANDELION.func_176968_b()), new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.YELLOW.func_176767_b()));
        TileEntityExtractor.addRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.POPPY.func_176968_b()), new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.RED.func_176767_b()));
        TileEntityExtractor.addRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.BLUE_ORCHID.func_176968_b()), new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.LIGHT_BLUE.func_176767_b()));
        TileEntityExtractor.addRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.ALLIUM.func_176968_b()), new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.MAGENTA.func_176767_b()));
        TileEntityExtractor.addRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.HOUSTONIA.func_176968_b()), new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.SILVER.func_176767_b()));
        TileEntityExtractor.addRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.RED_TULIP.func_176968_b()), new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.RED.func_176767_b()));
        TileEntityExtractor.addRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.ORANGE_TULIP.func_176968_b()), new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.ORANGE.func_176767_b()));
        TileEntityExtractor.addRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.WHITE_TULIP.func_176968_b()), new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.SILVER.func_176767_b()));
        TileEntityExtractor.addRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.PINK_TULIP.func_176968_b()), new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.PINK.func_176767_b()));
        TileEntityExtractor.addRecipe(new ItemStack((Block)Blocks.field_150328_O, 1, BlockFlower.EnumFlowerType.OXEYE_DAISY.func_176968_b()), new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.SILVER.func_176767_b()));
        TileEntityExtractor.addRecipe(new ItemStack((Block)Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.SUNFLOWER.func_176936_a()), new ItemStack(Items.field_151100_aR, 6, EnumDyeColor.YELLOW.func_176767_b()));
        TileEntityExtractor.addRecipe(new ItemStack((Block)Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.SYRINGA.func_176936_a()), new ItemStack(Items.field_151100_aR, 6, EnumDyeColor.MAGENTA.func_176767_b()));
        TileEntityExtractor.addRecipe(new ItemStack((Block)Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.ROSE.func_176936_a()), new ItemStack(Items.field_151100_aR, 6, EnumDyeColor.RED.func_176767_b()));
        TileEntityExtractor.addRecipe(new ItemStack((Block)Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.PAEONIA.func_176936_a()), new ItemStack(Items.field_151100_aR, 6, EnumDyeColor.PINK.func_176767_b()));
        TileEntityExtractor.addRecipe(new ItemStack(Items.field_185164_cV, 1), new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.RED.func_176767_b()));
    }

    public static void addRecipe(ItemStack input, ItemStack output) {
        TileEntityExtractor.addRecipe(new RecipeInputItemStack(input), output);
    }

    public static void addRecipe(ItemStack input, int stacksize, ItemStack output) {
        TileEntityExtractor.addRecipe(new RecipeInputItemStack(input, stacksize), output);
    }

    public static void addRecipe(String input, int stacksize, ItemStack output) {
        TileEntityExtractor.addRecipe(new RecipeInputOreDict(input, stacksize), output);
    }

    public static void addRecipe(ItemStack input, ItemStack output, float exp) {
        TileEntityExtractor.addRecipe(new RecipeInputItemStack(input), output, exp);
    }

    public static void addRecipe(ItemStack input, int stacksize, ItemStack output, float exp) {
        TileEntityExtractor.addRecipe(new RecipeInputItemStack(input, stacksize), output, exp);
    }

    public static void addRecipe(String input, int stacksize, ItemStack output, float exp) {
        TileEntityExtractor.addRecipe(new RecipeInputOreDict(input, stacksize), output, exp);
    }

    public static void addRecipe(ItemStack stack, MachineOutput out, String id) {
        ClassicRecipes.extractor.addRecipe((IRecipeInput)new RecipeInputItemStack(stack), out, id);
    }

    public static void addRecipe(IRecipeInput input, ItemStack output) {
        TileEntityExtractor.addRecipe(input, output, 0.0f);
    }

    public static void addRecipe(IRecipeInput input, ItemStack output, float exp) {
        ClassicRecipes.extractor.addRecipe(input, output, exp, AdvRecipeBase.getRecipeID(Arrays.asList(input), Arrays.asList(output), TileEntityExtractor.makeString(output)));
    }

    private static String makeString(ItemStack stack) {
        return stack.func_77977_a();
    }
}

