/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.low;

import com.google.common.base.Strings;
import ic2.api.classic.recipe.ClassicRecipes;
import ic2.api.classic.recipe.machine.IMachineRecipeList;
import ic2.api.classic.recipe.machine.MachineOutput;
import ic2.api.classic.tile.MachineType;
import ic2.api.recipe.IRecipeInput;
import ic2.core.IC2;
import ic2.core.block.base.tile.TileEntityBasicElectricMachine;
import ic2.core.block.machine.recipes.entries.RecipeInputDamaged;
import ic2.core.block.machine.recipes.entries.RecipeOutputRandom;
import ic2.core.block.machine.recipes.entries.ScrapBoxOutput;
import ic2.core.block.machine.recipes.entries.ScrapMetalOutput;
import ic2.core.inventory.gui.custom.MachineGui;
import ic2.core.item.recipe.entry.RecipeInputItemStack;
import ic2.core.item.recipe.entry.RecipeInputOreDict;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Resources;
import ic2.core.platform.registry.Ic2Sounds;
import ic2.core.util.misc.StackUtil;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityRecycler
extends TileEntityBasicElectricMachine {
    public static IMachineRecipeList.RecipeEntry entry = new IMachineRecipeList.RecipeEntry(new RecipeInputItemStack(Ic2Items.scrap, 9), new ScrapBoxOutput(68), "Scrapbox");

    public TileEntityRecycler() {
        super(3, 1, 45, 32);
    }

    @Override
    public IMachineRecipeList getRecipeList() {
        return ClassicRecipes.recycler;
    }

    @Override
    public MachineType getType() {
        return MachineType.recylced;
    }

    @Override
    public ResourceLocation getGuiTexture() {
        return Ic2Resources.recycler;
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return MachineGui.RecyclerGui.class;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.recycler;
    }

    @Override
    public double getWrenchDropRate() {
        return 0.85f;
    }

    @Override
    public ResourceLocation getStartSoundFile() {
        return Ic2Sounds.recyclerOp;
    }

    @Override
    public ResourceLocation getInterruptSoundFile() {
        return Ic2Sounds.interruptingSound;
    }

    @Override
    public IMachineRecipeList.RecipeEntry getOutputFor(ItemStack input) {
        if (StackUtil.isStackEqual(input, Ic2Items.scrap)) {
            return entry;
        }
        return ClassicRecipes.recycler.getRecipeInAndOutput(input, false);
    }

    @Override
    public boolean isValidInput(ItemStack par1) {
        if (par1 == null) {
            return false;
        }
        if (ClassicRecipes.recycler.getRecipeInAndOutput(par1, true) != null) {
            return super.isValidInput(par1);
        }
        return false;
    }

    public static void init() {
        String[] text;
        int i;
        TileEntityRecycler.addRecipe(new ItemStack(Items.field_151078_bh), Ic2Items.fertilizer.func_77946_l(), 0, 1, "compostingFlesh");
        TileEntityRecycler.addRecipe(new ItemStack(Items.field_151138_bX), new ItemStack(Items.field_151042_j, 5), 0.2f, "horserArmorRecyclingIron");
        TileEntityRecycler.addRecipe(new ItemStack(Items.field_151136_bY), new ItemStack(Items.field_151043_k, 5), 0.5f, "horserArmorRecyclingGold");
        TileEntityRecycler.addRecipe(new ItemStack(Items.field_151125_bZ), new ItemStack(Items.field_151045_i, 5), 1.0f, "horserArmorRecyclingDiamond");
        TileEntityRecycler.addRecipe(new ItemStack(Items.field_151143_au), new ItemStack(Items.field_151042_j), 0, 3, "minecartRecycling");
        String[] type = new String[]{"diamond", "iron", "gold"};
        Item[] axe = new Item[]{Items.field_151056_x, Items.field_151036_c, Items.field_151006_E};
        Item[] pickaxe = new Item[]{Items.field_151046_w, Items.field_151035_b, Items.field_151005_D};
        Item[] shovel = new Item[]{Items.field_151047_v, Items.field_151037_a, Items.field_151011_C};
        Item[] hoe = new Item[]{Items.field_151012_L, Items.field_151019_K, Items.field_151013_M};
        Item[] sword = new Item[]{Items.field_151048_u, Items.field_151040_l, Items.field_151010_B};
        Item[] helmet = new Item[]{Items.field_151161_ac, Items.field_151028_Y, Items.field_151169_ag};
        Item[] chestplate = new Item[]{Items.field_151163_ad, Items.field_151030_Z, Items.field_151171_ah};
        Item[] leggings = new Item[]{Items.field_151173_ae, Items.field_151165_aa, Items.field_151149_ai};
        Item[] boots = new Item[]{Items.field_151175_af, Items.field_151167_ab, Items.field_151151_aj};
        ItemStack[] results = new ItemStack[]{new ItemStack(Items.field_151045_i), new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151043_k)};
        for (i = 0; i < 3; ++i) {
            TileEntityRecycler.addRecipe(new ItemStack(axe[i]), results[i].func_77946_l(), 0, 3, "axeReycling" + type[i]);
            TileEntityRecycler.addRecipe(new ItemStack(pickaxe[i]), results[i].func_77946_l(), 0, 3, "pickaxeReycling" + type[i]);
            TileEntityRecycler.addRecipe(new ItemStack(shovel[i]), results[i].func_77946_l(), 0, 1, "shovelReycling" + type[i]);
            TileEntityRecycler.addRecipe(new ItemStack(hoe[i]), results[i].func_77946_l(), 0, 2, "hoeReycling" + type[i]);
            TileEntityRecycler.addRecipe(new ItemStack(sword[i]), results[i].func_77946_l(), 0, 2, "swordReycling" + type[i]);
            TileEntityRecycler.addRecipe(new ItemStack(helmet[i]), results[i].func_77946_l(), 0, 5, "helmetReycling" + type[i]);
            TileEntityRecycler.addRecipe(new ItemStack(chestplate[i]), results[i].func_77946_l(), 0, 8, "chestplateReycling" + type[i]);
            TileEntityRecycler.addRecipe(new ItemStack(leggings[i]), results[i].func_77946_l(), 0, 7, "leggingsReycling" + type[i]);
            TileEntityRecycler.addRecipe(new ItemStack(boots[i]), results[i].func_77946_l(), 0, 4, "bootsReycling" + type[i]);
        }
        for (i = 1; i < 3; ++i) {
            TileEntityRecycler.addRecipe((IRecipeInput)new RecipeInputDamaged(axe[i]), (MachineOutput)new ScrapMetalOutput.HighScrapMetalOutput(0, 3), "axeScrapping" + type[i]);
            TileEntityRecycler.addRecipe((IRecipeInput)new RecipeInputDamaged(pickaxe[i]), (MachineOutput)new ScrapMetalOutput.HighScrapMetalOutput(0, 3), "pickaxeScrapping" + type[i]);
            TileEntityRecycler.addRecipe((IRecipeInput)new RecipeInputDamaged(shovel[i]), (MachineOutput)new ScrapMetalOutput.HighScrapMetalOutput(0, 1), "shovelScrapping" + type[i]);
            TileEntityRecycler.addRecipe((IRecipeInput)new RecipeInputDamaged(hoe[i]), (MachineOutput)new ScrapMetalOutput.HighScrapMetalOutput(0, 2), "hoeScrapping" + type[i]);
            TileEntityRecycler.addRecipe((IRecipeInput)new RecipeInputDamaged(sword[i]), (MachineOutput)new ScrapMetalOutput.HighScrapMetalOutput(0, 2), "swordScrapping" + type[i]);
            TileEntityRecycler.addRecipe((IRecipeInput)new RecipeInputDamaged(helmet[i]), (MachineOutput)new ScrapMetalOutput.HighScrapMetalOutput(0, 5), "helmetScrapping" + type[i]);
            TileEntityRecycler.addRecipe((IRecipeInput)new RecipeInputDamaged(chestplate[i]), (MachineOutput)new ScrapMetalOutput.HighScrapMetalOutput(0, 8), "chestplateScrapping" + type[i]);
            TileEntityRecycler.addRecipe((IRecipeInput)new RecipeInputDamaged(leggings[i]), (MachineOutput)new ScrapMetalOutput.HighScrapMetalOutput(0, 7), "leggingsScrapping" + type[i]);
            TileEntityRecycler.addRecipe((IRecipeInput)new RecipeInputDamaged(boots[i]), (MachineOutput)new ScrapMetalOutput.HighScrapMetalOutput(0, 4), "bootsScrapping" + type[i]);
        }
        TileEntityRecycler.addRecipe(new ItemStack((Item)Items.field_151021_T), new ItemStack(Items.field_151116_aA), 0, 4, "leatherReworkingBoots");
        TileEntityRecycler.addRecipe(new ItemStack((Item)Items.field_151026_S), new ItemStack(Items.field_151116_aA), 0, 7, "leatherReworkingLeggings");
        TileEntityRecycler.addRecipe(new ItemStack((Item)Items.field_151027_R), new ItemStack(Items.field_151116_aA), 0, 8, "leatherReworkingChest");
        TileEntityRecycler.addRecipe(new ItemStack((Item)Items.field_151024_Q), new ItemStack(Items.field_151116_aA), 0, 5, "leatherReworkingHelmet");
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74780_a("RecipeTimeModifier", 10.0);
        TileEntityRecycler.addRecipe(Ic2Items.rareEarthChunk.func_77946_l(), new MachineOutput(nbt, Ic2Items.scrapMetal.func_77946_l()), "RareEarthRycling");
        for (String oreClass : OreDictionary.getOreNames()) {
            if (!oreClass.startsWith("ingot") || oreClass.equals("ingotBrick") || oreClass.equals("ingotBrickNether")) continue;
            TileEntityRecycler.addRecipe(oreClass, 1, new ScrapMetalOutput(), "ingotRecycling_" + oreClass);
        }
        String string = IC2.config.getText("recyclerBlacklist");
        if (!Strings.isNullOrEmpty((String)string) && (text = string.split(",")) != null && text.length > 0) {
            for (String id : text) {
                if (id.startsWith("ore:")) {
                    TileEntityRecycler.addBlackList(id.split(":")[1]);
                    continue;
                }
                TileEntityRecycler.processEntry(id);
            }
        }
    }

    private static void processEntry(String id) {
        int index = id.indexOf("-");
        if (index == -1) {
            Item item = Item.func_111206_d((String)id);
            if (item != null) {
                TileEntityRecycler.addBlackList(new ItemStack(item));
            }
            return;
        }
        String[] split = id.split("-");
        Item item = Item.func_111206_d((String)split[0]);
        if (item != null) {
            TileEntityRecycler.addBlackList(new ItemStack(item, 1, Integer.parseInt(split[1])));
        }
    }

    public static void addRecipe(ItemStack input, ItemStack output, String id) {
        TileEntityRecycler.addRecipe((IRecipeInput)new RecipeInputItemStack(input), output, id);
    }

    public static void addRecipe(ItemStack input, int stacksize, ItemStack output, String id) {
        TileEntityRecycler.addRecipe((IRecipeInput)new RecipeInputItemStack(input, stacksize), output, id);
    }

    public static void addRecipe(String input, int stacksize, ItemStack output, String id) {
        TileEntityRecycler.addRecipe((IRecipeInput)new RecipeInputOreDict(input, stacksize), output, id);
    }

    public static void addRecipe(ItemStack input, ItemStack output, float exp, String id) {
        TileEntityRecycler.addRecipe(new RecipeInputItemStack(input), output, exp, id);
    }

    public static void addRecipe(ItemStack input, int stacksize, ItemStack output, float exp, String id) {
        TileEntityRecycler.addRecipe(new RecipeInputItemStack(input, stacksize), output, exp, id);
    }

    public static void addRecipe(String input, int stacksize, ItemStack output, float exp, String id) {
        TileEntityRecycler.addRecipe(new RecipeInputOreDict(input, stacksize), output, exp, id);
    }

    public static void addRecipe(IRecipeInput input, ItemStack output, String id) {
        TileEntityRecycler.addRecipe(input, output, 0.0f, id);
    }

    public static void addRecipe(ItemStack input, ItemStack output, int min, int max, String id) {
        ClassicRecipes.recycler.addRecipe((IRecipeInput)new RecipeInputItemStack(input), new RecipeOutputRandom(output.func_77946_l(), min, max), id);
    }

    public static void addRecipe(ItemStack input, MachineOutput out, String id) {
        ClassicRecipes.recycler.addRecipe((IRecipeInput)new RecipeInputItemStack(input), out, id);
    }

    public static void addRecipe(IRecipeInput input, MachineOutput out, String id) {
        ClassicRecipes.recycler.addRecipe(input, out, id);
    }

    public static void addRecipe(IRecipeInput input, ItemStack output, float exp, String id) {
        ClassicRecipes.recycler.addRecipe(input, output, exp, id);
    }

    public static void addRecipe(String input, int stacksize, MachineOutput out, String id) {
        ClassicRecipes.recycler.addRecipe((IRecipeInput)new RecipeInputOreDict(input, stacksize), out, id);
    }

    public static void addBlackList(ItemStack input) {
        ClassicRecipes.recycler.getFilter().addItem(input);
    }

    public static void addBlackList(String ore) {
        ClassicRecipes.recycler.getFilter().addFilter(new RecipeInputOreDict(ore));
    }
}

