/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.low;

import com.google.common.collect.Sets;
import ic2.api.classic.audio.AudioPosition;
import ic2.api.classic.audio.IAudioPosition;
import ic2.api.classic.audio.ISoundModifier;
import ic2.api.classic.audio.PositionSpec;
import ic2.api.classic.item.IMachineUpgradeItem;
import ic2.api.classic.network.adv.IBitLevelOverride;
import ic2.api.classic.network.adv.NetworkField;
import ic2.core.IC2;
import ic2.core.block.base.tile.TileEntityElecMachine;
import ic2.core.block.base.util.FakeMachine;
import ic2.core.block.machine.low.container.ContainerSoundBeacon;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.item.upgrades.ItemChargePadUpgrade;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;

public class TileEntitySoundBeacon
extends TileEntityElecMachine
implements ITickable,
IHasGui,
IBitLevelOverride,
ISoundModifier {
    @NetworkField(index=7, compression=NetworkField.BitLevel.Bit8)
    public int tileRange = 5;
    @NetworkField(index=8, compression=NetworkField.BitLevel.Bit8)
    public int itemRange = 5;
    @NetworkField(index=9, compression=NetworkField.BitLevel.Bit8)
    public int armorRange = 5;
    @NetworkField(index=10)
    public float tileEffect = 1.0f;
    @NetworkField(index=11)
    public float itemEffect = 1.0f;
    @NetworkField(index=12)
    public float armorEffect = 1.0f;
    public FakeMachine machine;
    public IAudioPosition audioPos;

    public TileEntitySoundBeacon() {
        super(9, 32);
        this.maxEnergy = 20000;
        this.addNetworkFields("tileRange", "itemRange", "armorRange", "tileEffect", "itemEffect", "armorEffect");
    }

    @Override
    public NetworkField.BitLevel getOverride(int fieldID, String fieldName) {
        return NetworkField.BitLevel.Bit24;
    }

    @Override
    public boolean hasOverride(int fieldID, String fieldName) {
        return fieldID == 3 || fieldID == 4;
    }

    @Override
    public InventoryHandler getHandler() {
        return null;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.isRendering()) {
            IC2.audioManager.addModifier(this);
        } else {
            this.updateUpgrades();
        }
    }

    @Override
    public void onUnloaded() {
        if (this.isRendering()) {
            IC2.audioManager.removeModifier(this);
        }
        super.onUnloaded();
    }

    @Override
    public boolean supportsNotify() {
        return false;
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_82737_E() % 20L != 0L) {
            return;
        }
        if (!this.getActive()) {
            if (this.energy >= 20) {
                this.useEnergy(20);
                this.setActive(true);
            }
        } else if (this.getActive()) {
            if (this.energy >= 20) {
                this.useEnergy(20);
                return;
            }
            this.setActive(false);
        }
    }

    @Override
    public boolean isModifierValid(World world) {
        boolean valid = world == this.func_145831_w() && !this.func_145837_r();
        return valid;
    }

    @Override
    public void onAudioTick(World world) {
    }

    @Override
    public boolean hasEffect(PositionSpec type) {
        return this.getActive() && this.getAudioEffect(type) != 1.0f;
    }

    @Override
    public float getAudioEffect(PositionSpec type) {
        switch (type) {
            case Backpack: {
                return this.armorEffect;
            }
            case Center: {
                return this.tileEffect;
            }
            case Hand: {
                return this.itemEffect;
            }
        }
        return 1.0f;
    }

    @Override
    public int getEffectRange(PositionSpec type) {
        switch (type) {
            case Backpack: {
                return this.armorRange;
            }
            case Center: {
                return this.tileRange;
            }
            case Hand: {
                return this.itemRange;
            }
        }
        return 0;
    }

    @Override
    public IAudioPosition getPosition() {
        if (this.audioPos == null) {
            this.audioPos = new AudioPosition(this.func_145831_w(), this.func_174877_v());
        }
        return this.audioPos;
    }

    public void updateUpgrades() {
        this.machine = new FakeMachine(this, Sets.newHashSet((Object[])new IMachineUpgradeItem.UpgradeType[]{IMachineUpgradeItem.UpgradeType.Sounds}));
        this.tileRange = 5;
        this.itemRange = 5;
        this.armorRange = 5;
        this.tileEffect = 1.0f;
        this.itemEffect = 1.0f;
        this.armorEffect = 1.0f;
        for (int i = 0; i < 3; ++i) {
            for (int x = 0; x < 3; ++x) {
                int meta;
                int slot = i * 3 + x;
                ItemStack item = (ItemStack)this.inventory.get(slot);
                if (item.func_190926_b()) continue;
                if (i == 0) {
                    if (item.func_77973_b() instanceof IMachineUpgradeItem) {
                        this.tileEffect = (float)((double)this.tileEffect * Math.pow(((IMachineUpgradeItem)item.func_77973_b()).getSoundVolumeMultiplier(item, this.machine), item.func_190916_E()));
                        continue;
                    }
                    if (!(item.func_77973_b() instanceof ItemChargePadUpgrade)) continue;
                    meta = item.func_77952_i();
                    if (meta == 9) {
                        this.tileRange += 2;
                        continue;
                    }
                    if (meta == 10) {
                        this.tileRange += 5;
                        continue;
                    }
                    if (meta != 11) continue;
                    this.tileRange += 10;
                    continue;
                }
                if (i == 1) {
                    if (item.func_77973_b() instanceof IMachineUpgradeItem) {
                        this.itemEffect = (float)((double)this.itemEffect * Math.pow(((IMachineUpgradeItem)item.func_77973_b()).getSoundVolumeMultiplier(item, this.machine), item.func_190916_E()));
                        continue;
                    }
                    if (!(item.func_77973_b() instanceof ItemChargePadUpgrade)) continue;
                    meta = item.func_77952_i();
                    if (meta == 9) {
                        this.itemRange += 2;
                        continue;
                    }
                    if (meta == 10) {
                        this.itemRange += 5;
                        continue;
                    }
                    if (meta != 11) continue;
                    this.itemRange += 10;
                    continue;
                }
                if (item.func_77973_b() instanceof IMachineUpgradeItem) {
                    this.armorEffect = (float)((double)this.armorEffect * Math.pow(((IMachineUpgradeItem)item.func_77973_b()).getSoundVolumeMultiplier(item, this.machine), item.func_190916_E()));
                    continue;
                }
                if (!(item.func_77973_b() instanceof ItemChargePadUpgrade)) continue;
                meta = item.func_77952_i();
                if (meta == 9) {
                    this.armorRange += 2;
                    continue;
                }
                if (meta == 10) {
                    this.armorRange += 5;
                    continue;
                }
                if (meta != 11) continue;
                this.armorRange += 10;
            }
        }
        this.getNetwork().updateTileEntityField(this, "tileRange");
        this.getNetwork().updateTileEntityField(this, "itemRange");
        this.getNetwork().updateTileEntityField(this, "armorRange");
        this.getNetwork().updateTileEntityField(this, "tileEffect");
        this.getNetwork().updateTileEntityField(this, "itemEffect");
        this.getNetwork().updateTileEntityField(this, "armorEffect");
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerSoundBeacon(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.soundbeacon;
    }
}

