/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.low.container;

import ic2.core.block.machine.low.TileEntityIndustrialWorktable;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.base.IInventoryNotify;
import ic2.core.inventory.container.ContainerTileComponent;
import ic2.core.inventory.filters.ClassFilter;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.components.special.IndustrialWorktableComp;
import ic2.core.inventory.slots.SlotBase;
import ic2.core.inventory.slots.SlotCraftingRecipe;
import ic2.core.inventory.slots.SlotGhoest;
import ic2.core.inventory.slots.SlotInvNotify;
import ic2.core.inventory.slots.SlotRecurisveCraft;
import ic2.core.inventory.transport.wrapper.ChachedInventory;
import ic2.core.item.tool.ItemMemoryStick;
import ic2.core.platform.registry.Ic2Resources;
import ic2.core.util.math.Vec2i;
import ic2.core.util.misc.StackUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerIndustrialWorktable
extends ContainerTileComponent<TileEntityIndustrialWorktable>
implements IInventoryNotify {
    public boolean isSaving = false;
    public boolean lastSaving = false;
    public boolean crafts = false;
    public boolean isCentered;

    public ContainerIndustrialWorktable(TileEntityIndustrialWorktable tile, InventoryPlayer player) {
        super(tile);
        int x;
        int y;
        this.isCentered = tile.isCentered;
        this.func_75146_a(new SlotRecurisveCraft(tile.craftingInventory, 9, 124, 35, tile, player.field_70458_d));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.func_75146_a(new SlotGhoest(tile.craftingInventory, j + i * 3, 30 + j * 18, 17 + i * 18).allowDrag());
            }
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.func_75146_a(new SlotBase(tile, x + y * 9, 8 + 18 * x, 99 + 18 * y));
            }
        }
        for (y = 0; y < 9; ++y) {
            for (x = 0; x < 3; ++x) {
                this.func_75146_a(new SlotCraftingRecipe(tile.recipeList, x + y * 3, 177 + 18 * x, (this.isCentered ? 20 : 0) + 9 + 18 * y, this));
            }
        }
        this.func_75146_a(new SlotInvNotify(tile.memorySlots, 0, 152, 13, new ClassFilter(ItemMemoryStick.class)).registerListener(tile).registerListener(this));
        this.func_75146_a(new SlotInvNotify(tile.memorySlots, 1, 152, 31, new ClassFilter(ItemMemoryStick.class)).registerListener(tile).registerListener(this));
        this.addPlayerInventory(player, 0, 77);
        this.addComponent(new IndustrialWorktableComp(this));
        this.setMouseUpdate();
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        if (this.lastSaving != this.isSaving) {
            for (IContainerListener listener : this.field_75149_d) {
                listener.func_71112_a((Container)this, 0, this.isSaving ? 1 : 0);
            }
            this.lastSaving = this.isSaving;
        }
    }

    @Override
    public void func_75134_a(EntityPlayer playerIn) {
        if (this.isSaving) {
            playerIn.field_71071_by.func_70437_b(ItemStack.field_190927_a);
        }
        super.func_75134_a(playerIn);
    }

    @Override
    public void onSlotChanged(IHasInventory inv, int slot) {
        this.func_75142_b();
    }

    public void func_75137_b(int id, int data) {
        super.func_75137_b(id, data);
        if (id == 0) {
            this.isSaving = data == 1;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiLoaded(GuiIC2 gui) {
        gui.setMaxGuiXY(this.isCentered ? 176 : 230, 242);
        gui.dissableInvName();
        if (!this.isCentered) {
            gui.setInvOffset(new Vec2i(-30, 0));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void disableDoubleClick() {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof GuiIC2) {
            ((GuiIC2)screen).preventDoubleClick();
        }
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        if (slotId >= 0) {
            Slot slot = this.func_75139_a(slotId);
            if (this.isSaving) {
                if (slot instanceof SlotCraftingRecipe && ((TileEntityIndustrialWorktable)this.getGuiHolder()).isSimulating() && ((TileEntityIndustrialWorktable)this.getGuiHolder()).saveRecipe(slot.getSlotIndex())) {
                    player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                    this.isSaving = false;
                    this.func_75142_b();
                }
                return ItemStack.field_190927_a;
            }
            if (slot instanceof SlotRecurisveCraft) {
                if (((TileEntityIndustrialWorktable)this.getGuiHolder()).isRendering()) {
                    this.disableDoubleClick();
                    return ItemStack.field_190927_a;
                }
                SlotRecurisveCraft craft = (SlotRecurisveCraft)slot;
                if (clickTypeIn == ClickType.QUICK_MOVE) {
                    int count;
                    this.crafts = true;
                    ((TileEntityIndustrialWorktable)this.getGuiHolder()).createSnapshot();
                    ChachedInventory inv = ((TileEntityIndustrialWorktable)this.getGuiHolder()).takeSnapShot();
                    for (count = 0; count < 64 && craft.canCraft(player); ++count) {
                        ((TileEntityIndustrialWorktable)this.getGuiHolder()).createSnapshot();
                        ItemStack result = craft.getOutput(player);
                        if (!result.func_190926_b()) {
                            ItemStack copy = result.func_77946_l();
                            if (this.transferToSlots(result, this.guiInventorySize(), this.field_75151_b.size(), true)) {
                                ((TileEntityIndustrialWorktable)this.getGuiHolder()).destroySnapShot();
                                craft.func_190901_a(player, result);
                                continue;
                            }
                            if (result.func_190916_E() == copy.func_190916_E()) {
                                ((TileEntityIndustrialWorktable)this.getGuiHolder()).releaseSnapShot();
                                break;
                            }
                            player.func_71019_a(result, true);
                            ((TileEntityIndustrialWorktable)this.getGuiHolder()).destroySnapShot();
                            break;
                        }
                        ((TileEntityIndustrialWorktable)this.getGuiHolder()).releaseSnapShot();
                        break;
                    }
                    this.crafts = false;
                    if (count > 0) {
                        ((TileEntityIndustrialWorktable)this.getGuiHolder()).setSnapShot(inv);
                        ((TileEntityIndustrialWorktable)this.getGuiHolder()).releaseSnapshot(player);
                        this.func_75142_b();
                    } else {
                        ((TileEntityIndustrialWorktable)this.getGuiHolder()).destroySnapShot();
                    }
                    return ItemStack.field_190927_a;
                }
                ItemStack out = craft.func_75211_c();
                if (out.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                this.crafts = true;
                if (craft.canCraft(player)) {
                    ItemStack playerHand = player.field_71071_by.func_70445_o();
                    if (!playerHand.func_190926_b() && (out.func_77973_b() != playerHand.func_77973_b() || playerHand.func_77976_d() <= 1 || out.func_77981_g() && out.func_77960_j() != playerHand.func_77960_j() || !ItemStack.func_77970_a((ItemStack)out, (ItemStack)playerHand) || playerHand.func_190916_E() + out.func_190916_E() > out.func_77976_d())) {
                        this.crafts = false;
                        return ItemStack.field_190927_a;
                    }
                    ((TileEntityIndustrialWorktable)this.getGuiHolder()).createSnapshot();
                    ItemStack result = craft.getOutput(player);
                    if (!result.func_190926_b()) {
                        craft.func_190901_a(player, result);
                    }
                    ((TileEntityIndustrialWorktable)this.getGuiHolder()).releaseSnapshot(player);
                    if (playerHand.func_190926_b()) {
                        player.field_71071_by.func_70437_b(result);
                    } else {
                        int max = playerHand.func_77976_d();
                        playerHand.func_190917_f(result.func_190916_E());
                        if (playerHand.func_190916_E() > max) {
                            player.func_71019_a(playerHand.func_77979_a(playerHand.func_190916_E() - max), true);
                        }
                        player.field_71071_by.func_70437_b(playerHand);
                    }
                    this.func_75142_b();
                    this.crafts = false;
                    return ItemStack.field_190927_a;
                }
                this.crafts = false;
                return ItemStack.field_190927_a;
            }
            if (slot instanceof SlotGhoest) {
                ((SlotGhoest)slot).onClick(clickTypeIn == ClickType.QUICK_CRAFT ? 1 : dragType, clickTypeIn == ClickType.QUICK_MOVE, clickTypeIn == ClickType.QUICK_CRAFT ? StackUtil.copyWithSize(player.field_71071_by.func_70445_o(), 1) : player.field_71071_by.func_70445_o());
                ((TileEntityIndustrialWorktable)this.getGuiHolder()).generateRecipe();
                return ItemStack.field_190927_a;
            }
            if (slot instanceof SlotCraftingRecipe) {
                if (((TileEntityIndustrialWorktable)this.getGuiHolder()).isSimulating()) {
                    if (dragType == 2) {
                        ((TileEntityIndustrialWorktable)this.getGuiHolder()).deleteRecipe(slot.getSlotIndex());
                    } else if (dragType == 0) {
                        ((TileEntityIndustrialWorktable)this.getGuiHolder()).setRecipe(slot.getSlotIndex());
                    }
                    this.func_75142_b();
                }
                return ItemStack.field_190927_a;
            }
            if (clickTypeIn == ClickType.QUICK_MOVE && slotId >= this.guiInventorySize()) {
                if (((TileEntityIndustrialWorktable)this.getGuiHolder()).isSimulating()) {
                    super.func_184996_a(slotId, dragType, clickTypeIn, player);
                    this.func_75142_b();
                    return ItemStack.field_190927_a;
                }
                return ItemStack.field_190927_a;
            }
        } else if (this.isSaving) {
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    @Override
    public ResourceLocation getTexture() {
        return Ic2Resources.workTable;
    }

    @Override
    public int guiInventorySize() {
        return ((TileEntityIndustrialWorktable)this.getGuiHolder()).getTotalSize();
    }
}

