/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.low.logic.crops;

import com.google.common.base.Strings;
import ic2.core.block.machine.low.logic.crops.SeedEntry;
import ic2.core.block.machine.low.logic.crops.StatSorter;
import ic2.core.platform.lang.components.base.LangComponentHolder;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.components.special.DisplayLocaleComp;
import ic2.core.platform.registry.Ic2Lang;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CropSorters {
    public static CropSorters instance = new CropSorters();
    List<String> allSorters = new ArrayList<String>();
    Map<String, Comparator<SeedEntry>> sorters = new HashMap<String, Comparator<SeedEntry>>();
    Map<String, LocaleComp> sorterNames = new HashMap<String, LocaleComp>();

    public void init() {
        this.addComparator("StatCombined", new StatSorter(0), new LangComponentHolder.LocaleCropComp("cropSorter.allStats.name"));
        this.addComparator("StatGrowth", new StatSorter(1), new LangComponentHolder.LocaleCropComp("cropSorter.growth.name"));
        this.addComparator("StatGain", new StatSorter(2), new LangComponentHolder.LocaleCropComp("cropSorter.gain.name"));
        this.addComparator("StatResistance", new StatSorter(3), new LangComponentHolder.LocaleCropComp("cropSorter.resistance.name"));
        this.addComparator("StatAmount", new StatSorter(4), new LangComponentHolder.LocaleCropComp("cropSorter.count.name"));
    }

    public void addComparator(String id, Comparator<SeedEntry> comp) {
        this.addComparator(id, comp, new DisplayLocaleComp(id));
    }

    public void addComparator(String id, Comparator<SeedEntry> comp, LocaleComp name) {
        this.allSorters.add(id);
        this.sorters.put(id, comp);
        this.sorterNames.put(id, name);
    }

    public List<String> getAllSorters() {
        return this.allSorters;
    }

    public String getNextEntry(String id) {
        if (Strings.isNullOrEmpty((String)id)) {
            return this.allSorters.get(0);
        }
        int index = this.allSorters.indexOf(id);
        if (index == -1) {
            return this.allSorters.get(0);
        }
        if (index + 1 >= this.allSorters.size()) {
            return this.allSorters.get(0);
        }
        return this.allSorters.get(index + 1);
    }

    public LocaleComp getSorterName(String id) {
        if (Strings.isNullOrEmpty((String)id)) {
            return Ic2Lang.nullKey;
        }
        return this.sorterNames.getOrDefault(id, Ic2Lang.nullKey);
    }

    public Comparator<SeedEntry> getComparator(String id) {
        if (Strings.isNullOrEmpty((String)id)) {
            return null;
        }
        return this.sorters.get(id);
    }
}

