/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.med.logic;

import ic2.api.classic.network.adv.IInputBuffer;
import ic2.api.classic.network.adv.IOutputBuffer;
import ic2.api.classic.reactor.IReactorPlannerComponent;
import ic2.api.reactor.IReactorComponent;
import ic2.core.block.machine.med.TileEntityReactorPlanner;
import ic2.core.block.machine.med.logic.PlannerRegistry;
import ic2.core.block.machine.med.logic.ReactorLogicBase;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.util.math.MathUtil;
import ic2.core.util.misc.StackUtil;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;

public class TickingReactorLogic
extends ReactorLogicBase {
    EnumMap<IReactorPlannerComponent.ReactorComponentType, Set<Integer>> typeToSlots = new EnumMap(IReactorPlannerComponent.ReactorComponentType.class);
    TileEntityReactorPlanner.ReactorBackup backup = new TileEntityReactorPlanner.ReactorBackup();
    int[] replacedItems = new int[54];
    ReactorPrediction predict = new ReactorPrediction();
    public long totalProducedEnergy = 0L;

    public TickingReactorLogic(TileEntityReactorPlanner tile) {
        super(tile);
    }

    @Override
    public void onTick() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeStateToNBT(nbt);
        nbt = nbt.func_74737_b();
        this.doReactorTick();
        Set<Integer> resets = this.requireReset();
        if (resets.size() > 0) {
            this.readStateFromNBT(nbt);
            this.resetSlots(resets);
            this.doReactorTick();
        }
        if (this.currentHeat >= this.maxHeat) {
            this.isExploded = true;
        }
        if (this.isComponentBroken()) {
            this.didComponentBreak = true;
        }
    }

    @Override
    public void onFinished() {
        for (int i = 0; i < 54; ++i) {
            if (this.replacedItems[i] <= 0) continue;
            StackUtil.addToolTip((ItemStack)this.inv.get(i), TextFormatting.AQUA + Ic2GuiLang.componentsReplaced.getLocalizedFormatted(this.replacedItems[i]));
        }
    }

    @Override
    public void onSizeUpdate() {
        int size;
        super.onSizeUpdate();
        for (int x = size = this.getReactorSize(); x < 9; ++x) {
            for (int y = 0; y < 6; ++y) {
                this.backup.items.set(y * 9 + x, (Object)ItemStack.field_190927_a);
            }
        }
    }

    @Override
    public ReactorLogicBase.IReactorPrediction createPrediction() {
        return this.predict;
    }

    @Override
    public void validate() {
        IReactorPlannerComponent comp;
        int i;
        this.predict = new ReactorPrediction();
        this.typeToSlots.clear();
        this.backup = new TileEntityReactorPlanner.ReactorBackup();
        this.backup.reactorSize = this.planner.reactorSize;
        this.backup.hasBackup = true;
        this.replacedItems = new int[54];
        this.ticksDone = 0;
        this.ticksLeft = 0;
        this.maxTick = 0;
        this.currentHeat = 0;
        this.maxHeat = 10000;
        this.explosionEffect = 1.0f;
        this.producing = true;
        this.production = 0.0f;
        this.isValid = true;
        this.isExploded = false;
        this.collecting = false;
        this.didComponentBreak = false;
        this.custom = false;
        this.fuelPulses = 0;
        this.reEnrichPulses = 0;
        for (i = 0; i < 54; ++i) {
            this.backup.items.set(i, (Object)((ItemStack)this.inv.get(i)).func_77946_l());
            this.addToType(PlannerRegistry.getTypeByItem((ItemStack)this.inv.get(i)), i);
            Integer slot = ((ItemStack)this.inv.get(i)).func_77946_l();
            if (slot == null || !(slot.func_77973_b() instanceof IReactorComponent)) continue;
            this.addExplosionEffect(((IReactorComponent)slot.func_77973_b()).influenceExplosion((ItemStack)slot, this));
        }
        if (this.typeToSlots.containsKey((Object)IReactorPlannerComponent.ReactorComponentType.FuelRod)) {
            for (Integer slot : this.typeToSlots.get((Object)IReactorPlannerComponent.ReactorComponentType.FuelRod)) {
                comp = this.getComponent(slot);
                if (comp == null) continue;
                this.maxTick = Math.max(this.maxTick, comp.isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat.MaxDurability, (ItemStack)this.inv.get(slot.intValue())) ? comp.getReactorStat(this, slot % 9, slot / 9, (ItemStack)this.inv.get(slot.intValue()), IReactorPlannerComponent.ReactorComponentStat.MaxDurability).func_150287_d() : comp.getReactorStat(IReactorPlannerComponent.ReactorComponentStat.MaxDurability, (ItemStack)this.inv.get(slot.intValue())).func_150287_d());
                this.predict.heatPerTick = comp.isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat.HeatProduction, (ItemStack)this.inv.get(slot.intValue())) ? (this.predict.heatPerTick += comp.getReactorStat(this, slot % 9, slot / 9, (ItemStack)this.inv.get(slot.intValue()), IReactorPlannerComponent.ReactorComponentStat.HeatProduction).func_150287_d()) : (this.predict.heatPerTick += comp.getReactorStat(IReactorPlannerComponent.ReactorComponentStat.HeatProduction, (ItemStack)this.inv.get(slot.intValue())).func_150287_d());
                this.production = 0.0f;
                this.fuelPulses = 0;
                this.reEnrichPulses = 0;
                this.collecting = true;
                this.predict.energyPerTick = comp.isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat.EnergyProduction, (ItemStack)this.inv.get(slot.intValue())) ? (this.predict.energyPerTick += comp.getReactorStat(this, slot % 9, slot / 9, (ItemStack)this.inv.get(slot.intValue()), IReactorPlannerComponent.ReactorComponentStat.EnergyProduction).func_150288_h()) : (this.predict.energyPerTick += comp.getReactorStat(IReactorPlannerComponent.ReactorComponentStat.EnergyProduction, (ItemStack)this.inv.get(slot.intValue())).func_150288_h());
                this.predict.totalFuelRodPulses += this.fuelPulses;
                this.predict.totalReEnrichtingPulses += this.reEnrichPulses;
                this.collecting = false;
                this.fuelPulses = 0;
                this.reEnrichPulses = 0;
                this.production = 0.0f;
                this.predict.totalCellCount = comp.isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat.RodAmount, (ItemStack)this.inv.get(slot.intValue())) ? (this.predict.totalCellCount += comp.getReactorStat(this, slot % 9, slot / 9, (ItemStack)this.inv.get(slot.intValue()), IReactorPlannerComponent.ReactorComponentStat.RodAmount).func_150287_d()) : (this.predict.totalCellCount += comp.getReactorStat(IReactorPlannerComponent.ReactorComponentStat.RodAmount, (ItemStack)this.inv.get(slot.intValue())).func_150287_d());
                if (comp.isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat.PulseAmount, (ItemStack)this.inv.get(slot.intValue()))) {
                    this.predict.totalInternalFuelPulses += comp.getReactorStat(this, slot % 9, slot / 9, (ItemStack)this.inv.get(slot.intValue()), IReactorPlannerComponent.ReactorComponentStat.PulseAmount).func_150287_d();
                    continue;
                }
                this.predict.totalInternalFuelPulses += comp.getReactorStat(IReactorPlannerComponent.ReactorComponentStat.PulseAmount, (ItemStack)this.inv.get(slot.intValue())).func_150287_d();
            }
            this.fuelPulses = 0;
            this.reEnrichPulses = 0;
            this.production = 0.0f;
            this.collecting = false;
        }
        if (this.typeToSlots.containsKey((Object)IReactorPlannerComponent.ReactorComponentType.HeatPack)) {
            for (Integer slot : this.typeToSlots.get((Object)IReactorPlannerComponent.ReactorComponentType.HeatPack)) {
                comp = this.getComponent(slot);
                if (comp == null) continue;
                if (comp.isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat.HeatProduction, (ItemStack)this.inv.get(slot.intValue()))) {
                    this.addHeatPackHeat(comp.getReactorStat(this, slot % 9, slot / 9, (ItemStack)this.inv.get(slot.intValue()), IReactorPlannerComponent.ReactorComponentStat.HeatProduction).func_150287_d());
                    continue;
                }
                this.addHeatPackHeat(comp.getReactorStat(IReactorPlannerComponent.ReactorComponentStat.HeatProduction, (ItemStack)this.inv.get(slot.intValue())).func_150287_d());
            }
        }
        if (this.typeToSlots.containsKey((Object)IReactorPlannerComponent.ReactorComponentType.Vent)) {
            for (Integer slot : this.typeToSlots.get((Object)IReactorPlannerComponent.ReactorComponentType.Vent)) {
                comp = this.getComponent(slot);
                if (comp == null) continue;
                this.predict.coolingPerTick = comp.isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat.SelfCooling, (ItemStack)this.inv.get(slot.intValue())) ? (this.predict.coolingPerTick += comp.getReactorStat(this, slot % 9, slot / 9, (ItemStack)this.inv.get(slot.intValue()), IReactorPlannerComponent.ReactorComponentStat.SelfCooling).func_150287_d()) : (this.predict.coolingPerTick += comp.getReactorStat(IReactorPlannerComponent.ReactorComponentStat.SelfCooling, (ItemStack)this.inv.get(slot.intValue())).func_150287_d());
                if (comp.isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat.ReactorCooling, (ItemStack)this.inv.get(slot.intValue()))) {
                    this.predict.reactorCoolingPerTick += comp.getReactorStat(this, slot % 9, slot / 9, (ItemStack)this.inv.get(slot.intValue()), IReactorPlannerComponent.ReactorComponentStat.ReactorCooling).func_150287_d();
                    continue;
                }
                this.predict.reactorCoolingPerTick += comp.getReactorStat(IReactorPlannerComponent.ReactorComponentStat.ReactorCooling, (ItemStack)this.inv.get(slot.intValue())).func_150287_d();
            }
        }
        if (this.typeToSlots.containsKey((Object)IReactorPlannerComponent.ReactorComponentType.VentSpread)) {
            for (Integer slot : this.typeToSlots.get((Object)IReactorPlannerComponent.ReactorComponentType.VentSpread)) {
                comp = this.getComponent(slot);
                if (comp == null) continue;
                this.predict.coolingPerTick = comp.isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat.PartCooling, (ItemStack)this.inv.get(slot.intValue())) ? (this.predict.coolingPerTick += comp.getReactorStat(this, slot % 9, slot / 9, (ItemStack)this.inv.get(slot.intValue()), IReactorPlannerComponent.ReactorComponentStat.PartCooling).func_150287_d()) : (this.predict.coolingPerTick += comp.getReactorStat(IReactorPlannerComponent.ReactorComponentStat.PartCooling, (ItemStack)this.inv.get(slot.intValue())).func_150287_d());
                if (comp.isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat.ReactorCooling, (ItemStack)this.inv.get(slot.intValue()))) {
                    this.predict.reactorCoolingPerTick += comp.getReactorStat(this, slot % 9, slot / 9, (ItemStack)this.inv.get(slot.intValue()), IReactorPlannerComponent.ReactorComponentStat.ReactorCooling).func_150287_d();
                    continue;
                }
                this.predict.reactorCoolingPerTick += comp.getReactorStat(IReactorPlannerComponent.ReactorComponentStat.ReactorCooling, (ItemStack)this.inv.get(slot.intValue())).func_150287_d();
            }
        }
        if (this.typeToSlots.containsKey((Object)IReactorPlannerComponent.ReactorComponentType.Plating)) {
            for (Integer slot : this.typeToSlots.get((Object)IReactorPlannerComponent.ReactorComponentType.Plating)) {
                comp = this.getComponent(slot);
                if (comp == null) continue;
                if (comp.isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat.ReactorMaxHeat, (ItemStack)this.inv.get(slot.intValue()))) {
                    this.maxHeat += comp.getReactorStat(this, slot % 9, slot / 9, (ItemStack)this.inv.get(slot.intValue()), IReactorPlannerComponent.ReactorComponentStat.ReactorMaxHeat).func_150287_d();
                    continue;
                }
                this.maxHeat += comp.getReactorStat(IReactorPlannerComponent.ReactorComponentStat.ReactorMaxHeat, (ItemStack)this.inv.get(slot.intValue())).func_150287_d();
            }
        }
        for (i = 0; i < 54; ++i) {
            this.inv.set(i, (Object)((ItemStack)this.backup.items.get(i)).func_77946_l());
        }
        this.ticksLeft = this.maxTick;
        TileEntityReactorPlanner.UserSettings settings = this.planner.getUserSettings();
        if (settings.maxTicks != 0) {
            this.backup.customTicks = this.ticksLeft = settings.maxTicks;
            this.custom = true;
            this.maxTick = this.ticksLeft;
        }
        this.finishCalculations();
        this.production = this.predict.energyPerTick;
        this.predict.energyPerTick = (float)this.getReactorEUEnergyOutput();
        this.production = 0.0f;
        this.predict.totalHeatProduced += ((long)this.predict.heatPerTick + (long)this.predict.heatPackHeatPerTick) * (long)this.maxTick;
        this.predict.totalEnergyProduced += (long)this.predict.energyPerTick * (long)this.maxTick * (long)this.getTickRate();
        this.backup.customHeat = this.currentHeat = Math.min(this.maxHeat - 100, settings.startingHeat);
        this.backup.customTicks = this.maxTick;
    }

    @Override
    public TileEntityReactorPlanner.ReactorBackup createBackup() {
        if (this.ticksDone > 0) {
            this.reset();
        }
        TileEntityReactorPlanner.ReactorBackup toSave = new TileEntityReactorPlanner.ReactorBackup();
        toSave.hasBackup = true;
        toSave.isSteam = this.isSteamLogic();
        for (int i = 0; i < 54; ++i) {
            toSave.items.set(i, (Object)((ItemStack)this.inv.get(i)).func_77946_l());
        }
        TileEntityReactorPlanner.UserSettings settings = this.planner.getUserSettings();
        if (settings.maxTicks != 0) {
            toSave.customTicks = settings.maxTicks;
        }
        toSave.reactorSize = this.planner.reactorSize;
        toSave.customHeat = settings.startingHeat;
        return toSave;
    }

    @Override
    public void restoreFromBackup(TileEntityReactorPlanner.ReactorBackup toLoad) {
        NBTTagCompound nbt = new NBTTagCompound();
        toLoad.writeToNBT(nbt);
        this.backup.readFromNBT(nbt.func_74737_b());
        this.isValid = false;
        this.isExploded = false;
        this.inv = NonNullList.func_191197_a((int)54, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < 54; ++i) {
            this.inv.set(i, (Object)((ItemStack)toLoad.items.get(i)).func_77946_l());
        }
        TileEntityReactorPlanner.UserSettings settings = this.planner.getUserSettings();
        settings.maxTicks = toLoad.customTicks;
        settings.startingHeat = toLoad.customHeat;
    }

    @Override
    public void reset() {
        this.isValid = false;
        this.isExploded = false;
        this.didComponentBreak = false;
        this.inv = NonNullList.func_191197_a((int)54, (Object)ItemStack.field_190927_a);
        this.planner.reactorSize = this.backup.reactorSize;
        this.ticksDone = 0;
        this.ticksLeft = 0;
        this.maxTick = 0;
        this.currentHeat = 0;
        this.maxHeat = 10000;
        this.explosionEffect = 1.0f;
        this.production = 0.0f;
        this.producing = false;
        this.totalProducedEnergy = 0L;
        for (int i = 0; i < 54; ++i) {
            this.inv.set(i, this.backup.items.get(i));
        }
        if (this.custom) {
            TileEntityReactorPlanner.UserSettings settings = this.planner.getUserSettings();
            settings.maxTicks = this.backup.customTicks;
            settings.startingHeat = this.backup.customHeat;
            this.planner.getNetwork().updateTileGuiField(this.planner, "settings");
        }
        this.custom = false;
    }

    @Override
    public void clear() {
        super.clear();
        this.backup.items = NonNullList.func_191197_a((int)54, (Object)ItemStack.field_190927_a);
        this.backup.customHeat = 0;
        this.backup.customTicks = 0;
        this.backup.hasBackup = false;
        this.totalProducedEnergy = 0L;
    }

    @Override
    public boolean isSteamLogic() {
        return false;
    }

    @Override
    public int getTickRate() {
        return 20;
    }

    @Override
    public void readStateFromNBT(NBTTagCompound nbt) {
        super.readStateFromNBT(nbt);
        this.totalProducedEnergy = nbt.func_74763_f("TotalEUProduced");
        this.replacedItems = nbt.func_74759_k("Replacements");
        if (this.replacedItems.length != 54) {
            this.replacedItems = new int[54];
        }
    }

    @Override
    public void writeStateToNBT(NBTTagCompound nbt) {
        super.writeStateToNBT(nbt);
        nbt.func_74772_a("TotalEUProduced", this.totalProducedEnergy);
        nbt.func_74783_a("Replacements", this.replacedItems);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.backup.writeToNBT(this.getTag(nbt, "Backup"));
        nbt.func_74772_a("TotalEUProduced", this.totalProducedEnergy);
        nbt.func_74783_a("Replacements", this.replacedItems);
        NBTTagList list = new NBTTagList();
        for (Map.Entry<IReactorPlannerComponent.ReactorComponentType, Set<Integer>> entry : this.typeToSlots.entrySet()) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74774_a("Key", (byte)entry.getKey().ordinal());
            data.func_74783_a("Value", MathUtil.fromIntegerToInt((Collection<Integer>)entry.getValue()));
            list.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a("TypeSorting", (NBTBase)list);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.backup.readFromNBT(nbt.func_74775_l("Backup"));
        this.totalProducedEnergy = nbt.func_74763_f("TotalEUProduced");
        this.replacedItems = nbt.func_74759_k("Replacements");
        if (this.replacedItems.length != 54) {
            this.replacedItems = new int[54];
        }
        NBTTagList list = nbt.func_150295_c("TypeSorting", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound entry = list.func_150305_b(i);
            this.addMass(entry.func_74762_e("Key"), entry.func_74759_k("Value"));
        }
    }

    @Override
    public void read(IInputBuffer buffer) {
        super.read(buffer);
        this.totalProducedEnergy = buffer.readLong();
    }

    @Override
    public void write(IOutputBuffer buffer) {
        super.write(buffer);
        buffer.writeLong(this.totalProducedEnergy);
    }

    private void addToType(IReactorPlannerComponent.ReactorComponentType type, int slot) {
        if (type == null) {
            return;
        }
        Set<Integer> slots = this.typeToSlots.get((Object)type);
        if (slots == null) {
            slots = new LinkedHashSet<Integer>();
            this.typeToSlots.put(type, slots);
        }
        slots.add(slot);
    }

    private void addMass(int key, int[] value) {
        if (value.length == 0) {
            return;
        }
        IReactorPlannerComponent.ReactorComponentType[] array = IReactorPlannerComponent.ReactorComponentType.values();
        if (array.length > key) {
            this.typeToSlots.put(array[key], new LinkedHashSet<Integer>(MathUtil.fromIntToInteger(value)));
        }
    }

    public void addHeatPackHeat(int amount) {
        this.predict.heatPerTick += amount;
        this.predict.heatPackHeatPerTick += amount;
    }

    public void addExplosionEffect(float value) {
        if (value > 0.0f && value < 1.0f) {
            this.predict.boomMod *= value;
        } else {
            this.predict.boomPower += value;
        }
    }

    public void finishCalculations() {
        this.predict.totalExplosionPower = this.predict.boomPower * (this.explosionEffect * this.predict.boomMod);
        this.predict.efficency = this.predict.energyPerTick != 0.0f ? (float)this.predict.totalFuelRodPulses / (float)this.predict.totalCellCount : 0.0f;
        this.predict.totalEfficency = this.predict.energyPerTick != 0.0f ? (float)(this.predict.totalFuelRodPulses + this.predict.totalReEnrichtingPulses) / (float)this.predict.totalCellCount : 0.0f;
        this.predict.breeder = this.predict.totalReEnrichtingPulses > 0;
    }

    public void doReactorTick() {
        ++this.ticksDone;
        this.ticksLeft -= this.producing || !this.typeToSlots.containsKey((Object)IReactorPlannerComponent.ReactorComponentType.FuelRod) ? 1 : 0;
        boolean finished = this.isFinished();
        if (finished) {
            this.totalProducedEnergy = (long)((double)this.totalProducedEnergy + this.getReactorEUEnergyOutput() * (double)this.getTickRate());
        }
        this.production = 0.0f;
        this.maxHeat = 10000;
        this.explosionEffect = 1.0f;
        for (int pass = 0; pass < 2; ++pass) {
            for (int y = 0; y < 6; ++y) {
                for (int x = 0; x < 9; ++x) {
                    ItemStack thing = this.getItemAt(x, y);
                    if (!(thing.func_77973_b() instanceof IReactorComponent)) continue;
                    IReactorComponent comp = (IReactorComponent)thing.func_77973_b();
                    comp.processChamber(thing, this, x, y, pass == 0);
                }
            }
        }
        for (int i = 0; i < 54; ++i) {
            if (this.getStackInSlot(i).func_190926_b() || this.getStackInSlot(i).func_77973_b() instanceof IReactorComponent) continue;
            this.setStackInSlot(i, ItemStack.field_190927_a);
        }
        if (!finished) {
            this.totalProducedEnergy = (long)((double)this.totalProducedEnergy + this.getReactorEUEnergyOutput() * (double)this.getTickRate());
        }
    }

    public Set<Integer> requireReset() {
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>(54);
        if (this.typeToSlots.containsKey((Object)IReactorPlannerComponent.ReactorComponentType.Conensator)) {
            for (Integer slot : this.typeToSlots.get((Object)IReactorPlannerComponent.ReactorComponentType.Conensator)) {
                IReactorPlannerComponent comp = this.getComponent(slot);
                if (comp != null && comp.canStoreHeat((ItemStack)this.inv.get(slot.intValue()), this, slot % 9, slot / 9)) continue;
                result.add(slot);
            }
        }
        if (this.typeToSlots.containsKey((Object)IReactorPlannerComponent.ReactorComponentType.Reflection)) {
            for (Integer slot : this.typeToSlots.get((Object)IReactorPlannerComponent.ReactorComponentType.Reflection)) {
                if (!((ItemStack)this.inv.get(slot.intValue())).func_190926_b()) continue;
                result.add(slot);
            }
        }
        if (this.typeToSlots.containsKey((Object)IReactorPlannerComponent.ReactorComponentType.IsotopeCell)) {
            for (Integer slot : this.typeToSlots.get((Object)IReactorPlannerComponent.ReactorComponentType.IsotopeCell)) {
                if (!((ItemStack)this.inv.get(slot.intValue())).func_190926_b()) continue;
                result.add(slot);
            }
        }
        if (this.ticksLeft > 0 && this.typeToSlots.containsKey((Object)IReactorPlannerComponent.ReactorComponentType.FuelRod)) {
            for (Integer slot : this.typeToSlots.get((Object)IReactorPlannerComponent.ReactorComponentType.FuelRod)) {
                if (!((ItemStack)this.inv.get(slot.intValue())).func_190926_b()) continue;
                result.add(slot);
            }
        }
        return result;
    }

    public void resetSlots(Set<Integer> slots) {
        for (Integer slot : slots) {
            this.inv.set(slot.intValue(), this.backup.items.get(slot.intValue()));
            int n = slot;
            this.replacedItems[n] = this.replacedItems[n] + 1;
        }
    }

    public boolean isComponentBroken() {
        if (this.typeToSlots.containsKey((Object)IReactorPlannerComponent.ReactorComponentType.CoolantCell)) {
            for (Integer slot : this.typeToSlots.get((Object)IReactorPlannerComponent.ReactorComponentType.CoolantCell)) {
                if (!((ItemStack)this.inv.get(slot.intValue())).func_190926_b()) continue;
                return true;
            }
        }
        if (this.typeToSlots.containsKey((Object)IReactorPlannerComponent.ReactorComponentType.Vent)) {
            for (Integer slot : this.typeToSlots.get((Object)IReactorPlannerComponent.ReactorComponentType.Vent)) {
                if (!((ItemStack)this.inv.get(slot.intValue())).func_190926_b()) continue;
                return true;
            }
        }
        if (this.typeToSlots.containsKey((Object)IReactorPlannerComponent.ReactorComponentType.HeatSwitch)) {
            for (Integer slot : this.typeToSlots.get((Object)IReactorPlannerComponent.ReactorComponentType.HeatSwitch)) {
                if (!((ItemStack)this.inv.get(slot.intValue())).func_190926_b()) continue;
                return true;
            }
        }
        return false;
    }

    public static class ReactorPrediction
    implements ReactorLogicBase.IReactorPrediction {
        public long totalEnergyProduced;
        public long totalHeatProduced;
        public float energyPerTick;
        public int heatPerTick;
        public int heatPackHeatPerTick;
        public int coolingPerTick;
        public int reactorCoolingPerTick;
        public float efficency;
        public float totalEfficency;
        public boolean breeder;
        public int totalFuelRodPulses;
        public int totalInternalFuelPulses;
        public int totalCellCount;
        public int totalReEnrichtingPulses;
        public float totalExplosionPower;
        float boomPower = 10.0f;
        float boomMod = 1.0f;

        @Override
        public void clear() {
            this.totalEnergyProduced = 0L;
            this.totalHeatProduced = 0L;
            this.energyPerTick = 0.0f;
            this.heatPerTick = 0;
            this.heatPackHeatPerTick = 0;
            this.coolingPerTick = 0;
            this.reactorCoolingPerTick = 0;
            this.efficency = 0.0f;
            this.totalEfficency = 0.0f;
            this.breeder = false;
            this.totalFuelRodPulses = 0;
            this.totalInternalFuelPulses = 0;
            this.totalCellCount = 0;
            this.totalReEnrichtingPulses = 0;
            this.totalExplosionPower = 0.0f;
            this.boomPower = 10.0f;
            this.boomMod = 1.0f;
        }

        @Override
        public void read(IInputBuffer buffer) {
            this.totalEnergyProduced = buffer.readLong();
            this.totalHeatProduced = buffer.readLong();
            this.energyPerTick = buffer.readFloat();
            this.heatPerTick = buffer.readInt();
            this.heatPackHeatPerTick = buffer.readInt();
            this.coolingPerTick = buffer.readInt();
            this.reactorCoolingPerTick = buffer.readInt();
            this.totalExplosionPower = buffer.readFloat();
            this.efficency = buffer.readFloat();
            this.totalEfficency = buffer.readFloat();
            this.breeder = buffer.readBoolean();
        }

        @Override
        public void write(IOutputBuffer buffer) {
            buffer.writeLong(this.totalEnergyProduced);
            buffer.writeLong(this.totalHeatProduced);
            buffer.writeFloat(this.energyPerTick);
            buffer.writeInt(this.heatPerTick);
            buffer.writeInt(this.heatPackHeatPerTick);
            buffer.writeInt(this.coolingPerTick);
            buffer.writeInt(this.reactorCoolingPerTick);
            buffer.writeFloat(this.totalExplosionPower);
            buffer.writeFloat(this.efficency);
            buffer.writeFloat(this.totalEfficency);
            buffer.writeBoolean(this.breeder);
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt) {
            this.totalEnergyProduced = nbt.func_74763_f("TotalEnergy");
            this.totalHeatProduced = nbt.func_74763_f("TotalHeat");
            this.energyPerTick = nbt.func_74760_g("EnergyProduction");
            this.heatPerTick = nbt.func_74762_e("HeatProduction");
            this.heatPackHeatPerTick = nbt.func_74762_e("HeatPackPerTick");
            this.coolingPerTick = nbt.func_74762_e("Coolant");
            this.reactorCoolingPerTick = nbt.func_74762_e("ReactorCoolant");
            this.totalExplosionPower = nbt.func_74760_g("TotalExplosionEffect");
            this.efficency = nbt.func_74760_g("Efficency");
            this.totalEfficency = nbt.func_74760_g("TotalEfficency");
            this.breeder = nbt.func_74767_n("Breeder");
        }

        @Override
        public void writeToNBT(NBTTagCompound nbt) {
            nbt.func_74772_a("TotalEnergy", this.totalEnergyProduced);
            nbt.func_74772_a("TotalHeat", this.totalHeatProduced);
            nbt.func_74776_a("EnergyProduction", this.energyPerTick);
            nbt.func_74768_a("HeatProduction", this.heatPerTick);
            nbt.func_74768_a("HeatPackPerTick", this.heatPackHeatPerTick);
            nbt.func_74768_a("Coolant", this.coolingPerTick);
            nbt.func_74768_a("ReactorCoolant", this.reactorCoolingPerTick);
            nbt.func_74776_a("TotalExplosionEffect", this.totalExplosionPower);
            nbt.func_74776_a("Efficency", this.efficency);
            nbt.func_74776_a("TotalEfficency", this.totalEfficency);
            nbt.func_74757_a("Breeder", this.breeder);
        }

        @Override
        public boolean isSteam() {
            return false;
        }
    }
}

