/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.med.logic;

import ic2.api.classic.network.adv.IInputBuffer;
import ic2.api.classic.network.adv.IOutputBuffer;
import ic2.api.classic.reactor.IReactorPlannerComponent;
import ic2.api.classic.reactor.ISteamReactorComponent;
import ic2.api.reactor.IReactorComponent;
import ic2.core.block.machine.med.TileEntityReactorPlanner;
import ic2.core.block.machine.med.logic.PlannerRegistry;
import ic2.core.block.machine.med.logic.ReactorLogicBase;
import ic2.core.block.machine.med.logic.SteamReactorLogicBase;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.util.math.MathUtil;
import ic2.core.util.misc.StackUtil;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;

public class TickingSteamReactorLogic
extends SteamReactorLogicBase {
    EnumMap<IReactorPlannerComponent.ReactorComponentType, Set<Integer>> typeToSlots = new EnumMap(IReactorPlannerComponent.ReactorComponentType.class);
    TileEntityReactorPlanner.ReactorBackup backup = new TileEntityReactorPlanner.ReactorBackup();
    int[] replacedItems = new int[54];
    SteamReactorPrediction prediction = new SteamReactorPrediction();

    public TickingSteamReactorLogic(TileEntityReactorPlanner tile) {
        super(tile);
    }

    @Override
    public void onTick() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeStateToNBT(nbt);
        nbt = nbt.func_74737_b();
        this.doReactorTick();
        Set<Integer> resets = this.requireReset();
        if (resets.size() > 0) {
            this.readStateFromNBT(nbt);
            this.resetSlots(resets);
            this.doReactorTick();
        }
        if (this.currentHeat >= this.maxHeat) {
            this.isExploded = true;
        }
        if (this.isComponentBroken()) {
            this.didComponentBreak = true;
        }
    }

    public void doReactorTick() {
        ++this.ticksDone;
        this.ticksLeft -= this.producing || !this.typeToSlots.containsKey((Object)IReactorPlannerComponent.ReactorComponentType.FuelRod) ? 1 : 0;
        boolean finished = this.isFinished();
        if (finished) {
            this.updateTanks();
        }
        this.production = 0.0f;
        this.maxHeat = 10000;
        this.explosionEffect = 1.0f;
        for (int pass = 0; pass < 2; ++pass) {
            for (int y = 0; y < 6; ++y) {
                for (int x = 0; x < 9; ++x) {
                    ItemStack thing = this.getItemAt(x, y);
                    if (!(thing.func_77973_b() instanceof ISteamReactorComponent)) continue;
                    ISteamReactorComponent comp = (ISteamReactorComponent)thing.func_77973_b();
                    comp.processTick(this, thing, x, y, pass == 0, this.ticksDone % 20 == 0 && pass == 1);
                }
            }
        }
        for (int i = 0; i < 54; ++i) {
            if (this.getStackInSlot(i).func_190926_b() || this.getStackInSlot(i).func_77973_b() instanceof IReactorComponent) continue;
            this.setStackInSlot(i, ItemStack.field_190927_a);
        }
        if (!finished) {
            this.updateTanks();
        }
    }

    @Override
    public void onFinished() {
        for (int i = 0; i < 54; ++i) {
            if (this.replacedItems[i] <= 0) continue;
            StackUtil.addToolTip((ItemStack)this.inv.get(i), TextFormatting.AQUA + Ic2GuiLang.componentsReplaced.getLocalizedFormatted(this.replacedItems[i]));
        }
    }

    @Override
    public void validate() {
        IReactorPlannerComponent comp;
        int i;
        super.validate();
        this.prediction = new SteamReactorPrediction();
        this.typeToSlots.clear();
        this.backup = new TileEntityReactorPlanner.ReactorBackup();
        this.backup.reactorSize = this.planner.reactorSize;
        this.backup.hasBackup = true;
        this.replacedItems = new int[54];
        this.ticksDone = 0;
        this.ticksLeft = 0;
        this.maxTick = 0;
        this.currentHeat = 0;
        this.maxHeat = 10000;
        this.explosionEffect = 1.0f;
        this.producing = true;
        this.production = 0.0f;
        this.isValid = true;
        this.isExploded = false;
        this.collecting = false;
        this.didComponentBreak = false;
        this.custom = false;
        this.fuelPulses = 0;
        this.reEnrichPulses = 0;
        for (i = 0; i < 54; ++i) {
            this.backup.items.set(i, (Object)((ItemStack)this.inv.get(i)).func_77946_l());
            this.addToType(PlannerRegistry.getTypeByItem((ItemStack)this.inv.get(i)), i);
            Integer slot = ((ItemStack)this.inv.get(i)).func_77946_l();
            if (slot == null || !(slot.func_77973_b() instanceof IReactorComponent)) continue;
            this.addExplosionEffect(((IReactorComponent)slot.func_77973_b()).influenceExplosion((ItemStack)slot, this));
        }
        if (this.typeToSlots.containsKey((Object)IReactorPlannerComponent.ReactorComponentType.FuelRod)) {
            for (Integer slot : this.typeToSlots.get((Object)IReactorPlannerComponent.ReactorComponentType.FuelRod)) {
                comp = this.getComponent(slot);
                if (comp == null) continue;
                this.maxTick = Math.max(this.maxTick, (comp.isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat.MaxDurability, (ItemStack)this.inv.get(slot.intValue())) ? comp.getReactorStat(this, slot % 9, slot / 9, (ItemStack)this.inv.get(slot.intValue()), IReactorPlannerComponent.ReactorComponentStat.MaxDurability).func_150287_d() : comp.getReactorStat(IReactorPlannerComponent.ReactorComponentStat.MaxDurability, (ItemStack)this.inv.get(slot.intValue())).func_150287_d()) * 20);
                this.prediction.heatPerTick = comp.isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat.HeatProduction, (ItemStack)this.inv.get(slot.intValue())) ? (this.prediction.heatPerTick += comp.getReactorStat(this, slot % 9, slot / 9, (ItemStack)this.inv.get(slot.intValue()), IReactorPlannerComponent.ReactorComponentStat.HeatProduction).func_150287_d()) : (this.prediction.heatPerTick += comp.getReactorStat(IReactorPlannerComponent.ReactorComponentStat.HeatProduction, (ItemStack)this.inv.get(slot.intValue())).func_150287_d());
                this.production = 0.0f;
                this.fuelPulses = 0;
                this.reEnrichPulses = 0;
                this.collecting = true;
                if (comp.isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat.EnergyProduction, (ItemStack)this.inv.get(slot.intValue()))) {
                    comp.getReactorStat(this, slot % 9, slot / 9, (ItemStack)this.inv.get(slot.intValue()), IReactorPlannerComponent.ReactorComponentStat.EnergyProduction).func_150288_h();
                } else {
                    comp.getReactorStat(IReactorPlannerComponent.ReactorComponentStat.EnergyProduction, (ItemStack)this.inv.get(slot.intValue())).func_150288_h();
                }
                this.prediction.totalFuelRodPulses += this.fuelPulses;
                this.prediction.totalReEnrichtingPulses += this.reEnrichPulses;
                this.collecting = false;
                this.fuelPulses = 0;
                this.reEnrichPulses = 0;
                this.production = 0.0f;
                this.prediction.totalCellCount = comp.isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat.RodAmount, (ItemStack)this.inv.get(slot.intValue())) ? (this.prediction.totalCellCount += comp.getReactorStat(this, slot % 9, slot / 9, (ItemStack)this.inv.get(slot.intValue()), IReactorPlannerComponent.ReactorComponentStat.RodAmount).func_150287_d()) : (this.prediction.totalCellCount += comp.getReactorStat(IReactorPlannerComponent.ReactorComponentStat.RodAmount, (ItemStack)this.inv.get(slot.intValue())).func_150287_d());
                this.prediction.totalInternalFuelPulses = comp.isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat.PulseAmount, (ItemStack)this.inv.get(slot.intValue())) ? (this.prediction.totalInternalFuelPulses += comp.getReactorStat(this, slot % 9, slot / 9, (ItemStack)this.inv.get(slot.intValue()), IReactorPlannerComponent.ReactorComponentStat.PulseAmount).func_150287_d()) : (this.prediction.totalInternalFuelPulses += comp.getReactorStat(IReactorPlannerComponent.ReactorComponentStat.PulseAmount, (ItemStack)this.inv.get(slot.intValue())).func_150287_d());
                if (comp.isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat.ReactorEEM, (ItemStack)this.inv.get(slot.intValue()))) {
                    this.addExplosionEffect(comp.getReactorStat(this, slot % 9, slot / 9, (ItemStack)this.inv.get(slot.intValue()), IReactorPlannerComponent.ReactorComponentStat.ReactorEEM).func_150288_h());
                    continue;
                }
                this.addExplosionEffect(comp.getReactorStat(IReactorPlannerComponent.ReactorComponentStat.ReactorEEM, (ItemStack)this.inv.get(slot.intValue())).func_150288_h());
            }
            this.fuelPulses = 0;
            this.reEnrichPulses = 0;
            this.production = 0.0f;
            this.collecting = false;
        }
        if (this.typeToSlots.containsKey((Object)IReactorPlannerComponent.ReactorComponentType.Vent)) {
            for (Integer slot : this.typeToSlots.get((Object)IReactorPlannerComponent.ReactorComponentType.Vent)) {
                comp = this.getComponent(slot);
                if (comp == null) continue;
                this.prediction.coolingPerTick = comp.isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat.SelfCooling, (ItemStack)this.inv.get(slot.intValue())) ? (this.prediction.coolingPerTick += comp.getReactorStat(this, slot % 9, slot / 9, (ItemStack)this.inv.get(slot.intValue()), IReactorPlannerComponent.ReactorComponentStat.SelfCooling).func_150287_d()) : (this.prediction.coolingPerTick += comp.getReactorStat(IReactorPlannerComponent.ReactorComponentStat.SelfCooling, (ItemStack)this.inv.get(slot.intValue())).func_150287_d());
                if (comp.isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat.ReactorCooling, (ItemStack)this.inv.get(slot.intValue()))) {
                    this.prediction.reactorCoolingPerTick += comp.getReactorStat(this, slot % 9, slot / 9, (ItemStack)this.inv.get(slot.intValue()), IReactorPlannerComponent.ReactorComponentStat.ReactorCooling).func_150287_d();
                    continue;
                }
                this.prediction.reactorCoolingPerTick += comp.getReactorStat(IReactorPlannerComponent.ReactorComponentStat.ReactorCooling, (ItemStack)this.inv.get(slot.intValue())).func_150287_d();
            }
        }
        if (this.typeToSlots.containsKey((Object)IReactorPlannerComponent.ReactorComponentType.VentSpread)) {
            for (Integer slot : this.typeToSlots.get((Object)IReactorPlannerComponent.ReactorComponentType.VentSpread)) {
                comp = this.getComponent(slot);
                if (comp == null) continue;
                this.prediction.coolingPerTick = comp.isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat.PartCooling, (ItemStack)this.inv.get(slot.intValue())) ? (this.prediction.coolingPerTick += comp.getReactorStat(this, slot % 9, slot / 9, (ItemStack)this.inv.get(slot.intValue()), IReactorPlannerComponent.ReactorComponentStat.PartCooling).func_150287_d()) : (this.prediction.coolingPerTick += comp.getReactorStat(IReactorPlannerComponent.ReactorComponentStat.PartCooling, (ItemStack)this.inv.get(slot.intValue())).func_150287_d());
                if (comp.isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat.ReactorCooling, (ItemStack)this.inv.get(slot.intValue()))) {
                    this.prediction.reactorCoolingPerTick += comp.getReactorStat(this, slot % 9, slot / 9, (ItemStack)this.inv.get(slot.intValue()), IReactorPlannerComponent.ReactorComponentStat.ReactorCooling).func_150287_d();
                    continue;
                }
                this.prediction.reactorCoolingPerTick += comp.getReactorStat(IReactorPlannerComponent.ReactorComponentStat.ReactorCooling, (ItemStack)this.inv.get(slot.intValue())).func_150287_d();
            }
        }
        if (this.typeToSlots.containsKey((Object)IReactorPlannerComponent.ReactorComponentType.Plating)) {
            for (Integer slot : this.typeToSlots.get((Object)IReactorPlannerComponent.ReactorComponentType.Plating)) {
                comp = this.getComponent(slot);
                if (comp == null) continue;
                this.maxHeat = comp.isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat.ReactorMaxHeat, (ItemStack)this.inv.get(slot.intValue())) ? (this.maxHeat += comp.getReactorStat(this, slot % 9, slot / 9, (ItemStack)this.inv.get(slot.intValue()), IReactorPlannerComponent.ReactorComponentStat.ReactorMaxHeat).func_150287_d()) : (this.maxHeat += comp.getReactorStat(IReactorPlannerComponent.ReactorComponentStat.ReactorMaxHeat, (ItemStack)this.inv.get(slot.intValue())).func_150287_d());
                if (comp.isAdvancedStat(IReactorPlannerComponent.ReactorComponentStat.ReactorEEM, (ItemStack)this.inv.get(slot.intValue()))) {
                    this.addExplosionEffect(comp.getReactorStat(this, slot % 9, slot / 9, (ItemStack)this.inv.get(slot.intValue()), IReactorPlannerComponent.ReactorComponentStat.ReactorEEM).func_150287_d());
                    continue;
                }
                this.addExplosionEffect(comp.getReactorStat(IReactorPlannerComponent.ReactorComponentStat.ReactorEEM, (ItemStack)this.inv.get(slot.intValue())).func_150287_d());
            }
        }
        for (i = 0; i < 54; ++i) {
            this.inv.set(i, (Object)((ItemStack)this.backup.items.get(i)).func_77946_l());
        }
        this.ticksLeft = this.maxTick;
        TileEntityReactorPlanner.UserSettings settings = this.planner.getUserSettings();
        if (settings.maxTicks != 0) {
            this.backup.customTicks = this.ticksLeft = settings.maxTicks;
            this.custom = true;
            this.maxTick = this.ticksLeft;
        }
        this.finishCalculations();
        if (this.maxTick != 0) {
            this.prediction.totalHeatProduced = (long)this.prediction.heatPerTick * (long)this.maxTick;
            this.prediction.totalWaterConsumed = Math.min(this.prediction.totalHeatProduced / 40L, (long)(this.prediction.coolingPerTick * this.maxTick));
            this.prediction.totalSteamProduced = this.prediction.totalWaterConsumed * 160L;
            this.prediction.steamPerTick = this.prediction.totalSteamProduced / (long)this.maxTick;
        }
        this.backup.customHeat = this.currentHeat = Math.min(this.maxHeat - 100, settings.startingHeat);
        this.backup.customTicks = this.maxTick;
    }

    @Override
    public ReactorLogicBase.IReactorPrediction createPrediction() {
        return this.prediction;
    }

    @Override
    public TileEntityReactorPlanner.ReactorBackup createBackup() {
        if (this.ticksDone > 0) {
            this.reset();
        }
        TileEntityReactorPlanner.ReactorBackup toSave = new TileEntityReactorPlanner.ReactorBackup();
        toSave.hasBackup = true;
        toSave.isSteam = this.isSteamLogic();
        for (int i = 0; i < 54; ++i) {
            toSave.items.set(i, (Object)((ItemStack)this.inv.get(i)).func_77946_l());
        }
        TileEntityReactorPlanner.UserSettings settings = this.planner.getUserSettings();
        if (settings.maxTicks != 0) {
            toSave.customTicks = settings.maxTicks;
        }
        toSave.reactorSize = this.planner.reactorSize;
        toSave.customHeat = settings.startingHeat;
        return toSave;
    }

    @Override
    public void restoreFromBackup(TileEntityReactorPlanner.ReactorBackup toLoad) {
        NBTTagCompound nbt = new NBTTagCompound();
        toLoad.writeToNBT(nbt);
        this.backup.readFromNBT(nbt.func_74737_b());
        this.isValid = false;
        this.isExploded = false;
        this.inv = NonNullList.func_191197_a((int)54, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < 54; ++i) {
            this.inv.set(i, (Object)((ItemStack)toLoad.items.get(i)).func_77946_l());
        }
        TileEntityReactorPlanner.UserSettings settings = this.planner.getUserSettings();
        settings.maxTicks = toLoad.customTicks;
        settings.startingHeat = toLoad.customHeat;
    }

    @Override
    public void clear() {
        super.clear();
        this.backup.items = NonNullList.func_191197_a((int)54, (Object)ItemStack.field_190927_a);
        this.backup.customHeat = 0;
        this.backup.customTicks = 0;
        this.backup.hasBackup = false;
    }

    @Override
    public void reset() {
        super.reset();
        this.isValid = false;
        this.isExploded = false;
        this.didComponentBreak = false;
        this.inv = NonNullList.func_191197_a((int)54, (Object)ItemStack.field_190927_a);
        this.planner.reactorSize = this.backup.reactorSize;
        this.ticksDone = 0;
        this.ticksLeft = 0;
        this.maxTick = 0;
        this.currentHeat = 0;
        this.maxHeat = 10000;
        this.explosionEffect = 1.0f;
        this.production = 0.0f;
        this.producing = false;
        for (int i = 0; i < 54; ++i) {
            this.inv.set(i, this.backup.items.get(i));
        }
        if (this.custom) {
            TileEntityReactorPlanner.UserSettings settings = this.planner.getUserSettings();
            settings.maxTicks = this.backup.customTicks;
            settings.startingHeat = this.backup.customHeat;
            this.planner.getNetwork().updateTileGuiField(this.planner, "settings");
        }
        this.custom = false;
    }

    @Override
    public int getTickRate() {
        return 1;
    }

    @Override
    public void onSizeUpdate() {
        int size;
        super.onSizeUpdate();
        for (int x = size = this.getReactorSize(); x < 9; ++x) {
            for (int y = 0; y < 6; ++y) {
                this.backup.items.set(y * 9 + x, (Object)ItemStack.field_190927_a);
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.backup.writeToNBT(this.getTag(nbt, "Backup"));
        nbt.func_74783_a("Replacements", this.replacedItems);
        NBTTagList list = new NBTTagList();
        for (Map.Entry<IReactorPlannerComponent.ReactorComponentType, Set<Integer>> entry : this.typeToSlots.entrySet()) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74774_a("Key", (byte)entry.getKey().ordinal());
            data.func_74783_a("Value", MathUtil.fromIntegerToInt((Collection<Integer>)entry.getValue()));
            list.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a("TypeSorting", (NBTBase)list);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.backup.readFromNBT(nbt.func_74775_l("Backup"));
        this.replacedItems = nbt.func_74759_k("Replacements");
        if (this.replacedItems.length != 54) {
            this.replacedItems = new int[54];
        }
        NBTTagList list = nbt.func_150295_c("TypeSorting", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound entry = list.func_150305_b(i);
            this.addMass(entry.func_74762_e("Key"), entry.func_74759_k("Value"));
        }
    }

    @Override
    public void readStateFromNBT(NBTTagCompound nbt) {
        super.readStateFromNBT(nbt);
        this.replacedItems = nbt.func_74759_k("Replacements");
        if (this.replacedItems.length != 54) {
            this.replacedItems = new int[54];
        }
    }

    @Override
    public void writeStateToNBT(NBTTagCompound nbt) {
        super.writeStateToNBT(nbt);
        nbt.func_74783_a("Replacements", this.replacedItems);
    }

    private void addToType(IReactorPlannerComponent.ReactorComponentType type, int slot) {
        if (type == null) {
            return;
        }
        Set<Integer> slots = this.typeToSlots.get((Object)type);
        if (slots == null) {
            slots = new LinkedHashSet<Integer>();
            this.typeToSlots.put(type, slots);
        }
        slots.add(slot);
    }

    private void addMass(int key, int[] value) {
        if (value.length == 0) {
            return;
        }
        IReactorPlannerComponent.ReactorComponentType[] array = IReactorPlannerComponent.ReactorComponentType.values();
        if (array.length > key) {
            this.typeToSlots.put(array[key], new LinkedHashSet<Integer>(MathUtil.fromIntToInteger(value)));
        }
    }

    public Set<Integer> requireReset() {
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>(54);
        if (this.typeToSlots.containsKey((Object)IReactorPlannerComponent.ReactorComponentType.Conensator)) {
            for (Integer slot : this.typeToSlots.get((Object)IReactorPlannerComponent.ReactorComponentType.Conensator)) {
                IReactorPlannerComponent comp = this.getComponent(slot);
                if (comp != null && comp.canStoreHeat((ItemStack)this.inv.get(slot.intValue()), this, slot % 9, slot / 9)) continue;
                result.add(slot);
            }
        }
        if (this.typeToSlots.containsKey((Object)IReactorPlannerComponent.ReactorComponentType.Reflection)) {
            for (Integer slot : this.typeToSlots.get((Object)IReactorPlannerComponent.ReactorComponentType.Reflection)) {
                if (!((ItemStack)this.inv.get(slot.intValue())).func_190926_b()) continue;
                result.add(slot);
            }
        }
        if (this.typeToSlots.containsKey((Object)IReactorPlannerComponent.ReactorComponentType.IsotopeCell)) {
            for (Integer slot : this.typeToSlots.get((Object)IReactorPlannerComponent.ReactorComponentType.IsotopeCell)) {
                if (!((ItemStack)this.inv.get(slot.intValue())).func_190926_b()) continue;
                result.add(slot);
            }
        }
        if (this.ticksLeft > 0 && this.typeToSlots.containsKey((Object)IReactorPlannerComponent.ReactorComponentType.FuelRod)) {
            for (Integer slot : this.typeToSlots.get((Object)IReactorPlannerComponent.ReactorComponentType.FuelRod)) {
                if (!((ItemStack)this.inv.get(slot.intValue())).func_190926_b()) continue;
                result.add(slot);
            }
        }
        return result;
    }

    public void resetSlots(Set<Integer> slots) {
        for (Integer slot : slots) {
            this.inv.set(slot.intValue(), this.backup.items.get(slot.intValue()));
            int n = slot;
            this.replacedItems[n] = this.replacedItems[n] + 1;
        }
    }

    public boolean isComponentBroken() {
        if (this.typeToSlots.containsKey((Object)IReactorPlannerComponent.ReactorComponentType.CoolantCell)) {
            for (Integer slot : this.typeToSlots.get((Object)IReactorPlannerComponent.ReactorComponentType.CoolantCell)) {
                if (!((ItemStack)this.inv.get(slot.intValue())).func_190926_b()) continue;
                return true;
            }
        }
        if (this.typeToSlots.containsKey((Object)IReactorPlannerComponent.ReactorComponentType.Vent)) {
            for (Integer slot : this.typeToSlots.get((Object)IReactorPlannerComponent.ReactorComponentType.Vent)) {
                if (!((ItemStack)this.inv.get(slot.intValue())).func_190926_b()) continue;
                return true;
            }
        }
        if (this.typeToSlots.containsKey((Object)IReactorPlannerComponent.ReactorComponentType.HeatSwitch)) {
            for (Integer slot : this.typeToSlots.get((Object)IReactorPlannerComponent.ReactorComponentType.HeatSwitch)) {
                if (!((ItemStack)this.inv.get(slot.intValue())).func_190926_b()) continue;
                return true;
            }
        }
        return false;
    }

    public void addExplosionEffect(float value) {
        if (value > 0.0f && value < 1.0f) {
            this.prediction.boomMod *= value;
        } else {
            this.prediction.boomPower += value;
        }
    }

    public void finishCalculations() {
        this.prediction.totalExplosionPower = this.prediction.boomPower * (this.explosionEffect * this.prediction.boomMod);
        this.prediction.breeder = this.prediction.totalReEnrichtingPulses > 0;
        this.prediction.efficency = (float)this.prediction.totalFuelRodPulses / (float)this.prediction.totalCellCount;
        this.prediction.totalEfficency = (float)(this.prediction.totalFuelRodPulses + this.prediction.totalReEnrichtingPulses) / (float)this.prediction.totalCellCount;
    }

    public static class SteamReactorPrediction
    implements ReactorLogicBase.IReactorPrediction {
        public long totalWaterConsumed;
        public long totalSteamProduced;
        public long totalHeatProduced;
        public float steamPerTick;
        public int heatPerTick;
        public int coolingPerTick;
        public int reactorCoolingPerTick;
        public float efficency;
        public float totalEfficency;
        public boolean breeder;
        public int totalFuelRodPulses;
        public int totalInternalFuelPulses;
        public int totalCellCount;
        public int totalReEnrichtingPulses;
        public float totalExplosionPower;
        float boomPower = 10.0f;
        float boomMod = 1.0f;

        @Override
        public void read(IInputBuffer buffer) {
            this.totalWaterConsumed = buffer.readLong();
            this.totalSteamProduced = buffer.readLong();
            this.totalHeatProduced = buffer.readLong();
            this.steamPerTick = buffer.readFloat();
            this.totalExplosionPower = buffer.readFloat();
            this.heatPerTick = buffer.readInt();
            this.coolingPerTick = buffer.readInt();
            this.reactorCoolingPerTick = buffer.readInt();
            this.efficency = buffer.readFloat();
            this.totalEfficency = buffer.readFloat();
            this.breeder = buffer.readBoolean();
        }

        @Override
        public void write(IOutputBuffer buffer) {
            buffer.writeLong(this.totalWaterConsumed);
            buffer.writeLong(this.totalSteamProduced);
            buffer.writeLong(this.totalHeatProduced);
            buffer.writeFloat(this.steamPerTick);
            buffer.writeFloat(this.totalExplosionPower);
            buffer.writeInt(this.heatPerTick);
            buffer.writeInt(this.coolingPerTick);
            buffer.writeInt(this.reactorCoolingPerTick);
            buffer.writeFloat(this.efficency);
            buffer.writeFloat(this.totalEfficency);
            buffer.writeBoolean(this.breeder);
        }

        @Override
        public void readFromNBT(NBTTagCompound nbt) {
            this.totalWaterConsumed = nbt.func_74763_f("TotalWater");
            this.totalSteamProduced = nbt.func_74763_f("TotalSteam");
            this.totalHeatProduced = nbt.func_74763_f("TotalHeat");
            this.steamPerTick = nbt.func_74760_g("SteamPerTick");
            this.heatPerTick = nbt.func_74762_e("HeatProduction");
            this.coolingPerTick = nbt.func_74762_e("Coolant");
            this.reactorCoolingPerTick = nbt.func_74762_e("ReactorCoolant");
            this.totalExplosionPower = nbt.func_74760_g("TotalExplosionEffect");
            this.efficency = nbt.func_74760_g("Efficency");
            this.totalEfficency = nbt.func_74760_g("TotalEfficency");
            this.breeder = nbt.func_74767_n("Breeder");
        }

        @Override
        public void writeToNBT(NBTTagCompound nbt) {
            nbt.func_74772_a("TotalWater", this.totalWaterConsumed);
            nbt.func_74772_a("TotalSteam", this.totalSteamProduced);
            nbt.func_74772_a("TotalHeat", this.totalHeatProduced);
            nbt.func_74776_a("SteamPerTick", this.steamPerTick);
            nbt.func_74768_a("HeatProduction", this.heatPerTick);
            nbt.func_74768_a("Coolant", this.coolingPerTick);
            nbt.func_74768_a("ReactorCoolant", this.reactorCoolingPerTick);
            nbt.func_74776_a("TotalExplosionEffect", this.totalExplosionPower);
            nbt.func_74776_a("Efficency", this.efficency);
            nbt.func_74776_a("TotalEfficency", this.totalEfficency);
            nbt.func_74757_a("Breeder", this.breeder);
        }

        @Override
        public boolean isSteam() {
            return true;
        }

        @Override
        public void clear() {
            this.totalWaterConsumed = 0L;
            this.totalSteamProduced = 0L;
            this.totalHeatProduced = 0L;
            this.heatPerTick = 0;
            this.coolingPerTick = 0;
            this.reactorCoolingPerTick = 0;
            this.efficency = 0.0f;
            this.totalEfficency = 0.0f;
            this.breeder = false;
            this.totalFuelRodPulses = 0;
            this.totalInternalFuelPulses = 0;
            this.totalCellCount = 0;
            this.totalReEnrichtingPulses = 0;
            this.totalExplosionPower = 0.0f;
            this.boomPower = 10.0f;
            this.boomMod = 1.0f;
        }
    }
}

