/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.recipes.managers;

import ic2.api.classic.recipe.machine.IMachineFilter;
import ic2.api.recipe.IListRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.core.util.helpers.FilteredList;
import ic2.core.util.helpers.ItemWithMeta;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;

public class BasicMachineFilter
implements IMachineFilter {
    List<ItemWithMeta> basicItems = new FilteredList<ItemWithMeta>();
    List<IRecipeInput> filters = new FilteredList<IRecipeInput>();

    @Override
    public void addItem(ItemStack item) {
        if (item.func_190926_b()) {
            return;
        }
        this.basicItems.add(new ItemWithMeta(item));
    }

    @Override
    public void addFilter(IRecipeInput filter) {
        if (filter == null) {
            return;
        }
        this.filters.add(filter);
    }

    @Override
    public boolean isItemAllowed(ItemStack stack) {
        for (IRecipeInput input : this.filters) {
            if (!input.matches(stack)) continue;
            return false;
        }
        return !this.basicItems.contains(new ItemWithMeta(stack));
    }

    @Override
    public boolean isBlackList() {
        return true;
    }

    @Override
    public List<ItemStack> getAllEntries() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemWithMeta meta : this.basicItems) {
            list.add(meta.toStack());
        }
        for (IRecipeInput input : this.filters) {
            list.addAll(input.getInputs());
        }
        return list;
    }

    @Override
    public boolean removeItem(ItemStack item) {
        return this.basicItems.remove(new ItemWithMeta(item));
    }

    @Override
    public boolean removeFilter(ItemStack item) {
        boolean removed = false;
        for (int i = 0; i < this.filters.size(); ++i) {
            IRecipeInput input = this.filters.get(i);
            if (!input.matches(item)) continue;
            this.filters.remove(i--);
            removed = true;
        }
        return removed;
    }

    @Override
    public boolean remove(ItemStack item) {
        boolean removed = this.removeItem(item);
        removed = this.removeFilter(item) || removed;
        return removed;
    }

    @Override
    public IListRecipeManager toExp() {
        return new IListRecipeManager(){

            @Override
            public Iterator<IRecipeInput> iterator() {
                return BasicMachineFilter.this.filters.iterator();
            }

            @Override
            public void add(IRecipeInput input) {
                BasicMachineFilter.this.addFilter(input);
            }

            @Override
            public boolean contains(ItemStack stack) {
                return !BasicMachineFilter.this.isItemAllowed(stack);
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public List<IRecipeInput> getInputs() {
                return BasicMachineFilter.this.filters;
            }
        };
    }
}

