/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.personal.base.misc;

import ic2.core.block.personal.base.misc.IPersonalInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;

public class PersonalInventory
implements IPersonalInventory {
    NonNullList<ItemStack> inv;
    int slots;
    int stacksize = 64;

    public PersonalInventory(int slotCount) {
        this.slots = slotCount;
        this.inv = NonNullList.func_191197_a((int)slotCount, (Object)ItemStack.field_190927_a);
    }

    public void setMaxStackSize(int max) {
        this.stacksize = MathHelper.func_76125_a((int)max, (int)1, (int)64);
    }

    @Override
    public void setStackInSlot(int slot, ItemStack stack) {
        this.inv.set(slot, (Object)stack);
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return (ItemStack)this.inv.get(slot);
    }

    @Override
    public int getSlotCount() {
        return this.slots;
    }

    @Override
    public int getMaxStackSize(int slot) {
        return this.stacksize;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("Items", 10);
        this.inv = NonNullList.func_191197_a((int)this.slots, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            int slot = data.func_74762_e("Slot");
            if (slot < 0 || slot >= this.slots) continue;
            this.inv.set(slot, (Object)new ItemStack(data));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots; ++i) {
            NBTTagCompound data = new NBTTagCompound();
            ((ItemStack)this.inv.get(i)).func_77955_b(data);
            data.func_74768_a("Slot", i);
            list.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
    }

    public void clear() {
        for (int i = 0; i < this.slots; ++i) {
            this.inv.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    public void clear(int from, int to) {
        for (int i = from; i < this.slots && i < to; ++i) {
            this.inv.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    public PersonalInventory copy() {
        PersonalInventory copy = new PersonalInventory(this.slots);
        copy.copy(this, 0, this.slots);
        return copy;
    }

    public PersonalInventory copy(int from, int to) {
        PersonalInventory copy = new PersonalInventory(to - from);
        copy.copy(this, from, to);
        return copy;
    }

    public void copy(IPersonalInventory pers, int from, int to) {
        for (int i = 0; i < this.slots && from + i < to && from + i < pers.getSlotCount(); ++i) {
            this.inv.set(i, (Object)pers.getStackInSlot(from + i).func_77946_l());
        }
    }

    public void inject(IPersonalInventory pers, int from, int to) {
        for (int i = 0; i < this.slots && from + i < to && from + i < pers.getSlotCount(); ++i) {
            pers.setStackInSlot(from + i, ((ItemStack)this.inv.get(i)).func_77946_l());
        }
    }

    public boolean isInvEmpty() {
        for (int i = 0; i < this.slots; ++i) {
            if (((ItemStack)this.inv.get(i)).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canInsert(int slot, ItemStack stack) {
        return true;
    }
}

