/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.personal.base.trades.builder;

import ic2.core.inventory.base.IHasInventory;
import ic2.core.item.misc.ItemDisplayIcon;
import ic2.core.platform.registry.Ic2Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;

public class FluidInventory
implements IHasInventory {
    int count;
    FluidStack[] fluidArray;
    NonNullList<ItemStack> display;

    public FluidInventory(int size) {
        this.count = size;
        this.fluidArray = new FluidStack[size];
        this.display = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
    }

    @Override
    public void setStackInSlot(int slot, ItemStack stack) {
        this.display.set(slot, (Object)stack);
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return (ItemStack)this.display.get(slot);
    }

    @Override
    public int getSlotCount() {
        return this.count;
    }

    @Override
    public int getMaxStackSize(int slot) {
        return 1;
    }

    public FluidStack getFluid(int slot) {
        return this.fluidArray[slot];
    }

    public boolean hasFluid(int slot) {
        return this.fluidArray[slot] != null;
    }

    public void setFluid(int slot, FluidStack fluid) {
        this.fluidArray[slot] = fluid;
        if (fluid != null) {
            ItemStack newItem = Ic2Items.fluidDisplay.func_77946_l();
            ItemDisplayIcon.setFluidStack(newItem, fluid);
            this.display.set(slot, (Object)newItem);
        } else {
            this.display.set(slot, (Object)ItemStack.field_190927_a);
        }
    }

    public void updateSlot(int slot) {
        if (this.fluidArray[slot] != null) {
            ItemStack newItem = Ic2Items.fluidDisplay.func_77946_l();
            ItemDisplayIcon.setFluidStack(newItem, this.fluidArray[slot]);
            this.display.set(slot, (Object)newItem);
        } else {
            this.display.set(slot, (Object)ItemStack.field_190927_a);
        }
    }

    public void clear() {
        for (int i = 0; i < this.count; ++i) {
            this.display.set(i, (Object)ItemStack.field_190927_a);
            this.fluidArray[i] = null;
        }
    }

    @Override
    public boolean canInsert(int slot, ItemStack stack) {
        return true;
    }
}

