/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.render.model;

import ic2.api.classic.energy.tile.IEnergyConductorColored;
import ic2.core.block.wiring.cables.CableContainer;
import ic2.core.block.wiring.cables.WireRegistry;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.Ic2Models;
import ic2.core.platform.textures.models.BaseModel;
import ic2.core.util.helpers.BlockStateContainerIC2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.vector.Vector3f;

public class MultiPartLuminatorModel
extends BaseModel {
    static Map<MultiLuminatorEntry, List<BakedQuad>> quads = new HashMap<MultiLuminatorEntry, List<BakedQuad>>();
    static Map<IEnergyConductorColored.WireColor, GeneratorInfo[][]> quadInfo = new EnumMap<IEnergyConductorColored.WireColor, GeneratorInfo[][]>(IEnergyConductorColored.WireColor.class);
    List<BakedQuad> itemQuads = new ArrayList<BakedQuad>();

    public MultiPartLuminatorModel() {
        super(Ic2Models.getBlockTransforms());
    }

    @Override
    public void init() {
        ArrayList<MultiLuminatorEntry> list = new ArrayList<MultiLuminatorEntry>(quads.keySet());
        quads.clear();
        quadInfo.clear();
        this.setParticalTexture(Ic2Icons.getTextures("b0")[30]);
        this.itemQuads.addAll((Collection<BakedQuad>)ItemLayerModel.getQuadsForSprite((int)-1, (TextureAtlasSprite)Ic2Icons.getTextures("b0")[30], (VertexFormat)DefaultVertexFormats.field_176599_b, Optional.of(Ic2Models.getMap(new ResourceLocation("minecraft:models/item/handheld")).get((Object)ItemCameraTransforms.TransformType.FIXED))));
        int max = WireRegistry.instance.getMaxMeta();
        for (IEnergyConductorColored.WireColor color : IEnergyConductorColored.WireColor.values()) {
            GeneratorInfo[][] array = new GeneratorInfo[max][2];
            for (int i = 0; i < max; ++i) {
                array[i][0] = this.createInfo(i, color, false);
                array[i][1] = this.createInfo(i, color, true);
            }
            quadInfo.put(color, array);
        }
        for (MultiLuminatorEntry entry : list) {
            quads.put(entry, this.createQuads(entry));
        }
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (side != null) {
            return this.getEmptyList();
        }
        if (!(state instanceof BlockStateContainerIC2.IC2BlockState)) {
            return this.itemQuads;
        }
        MultiLuminatorEntry entry = (MultiLuminatorEntry)((BlockStateContainerIC2.IC2BlockState)state).getData();
        List<BakedQuad> quadList = quads.get(entry);
        if (quadList == null) {
            quadList = this.createQuads(entry);
            quads.put(entry, quadList);
        }
        return quadList;
    }

    public GeneratorInfo createInfo(int itemDamage, IEnergyConductorColored.WireColor color, boolean active) {
        GeneratorInfo info = new GeneratorInfo();
        CableContainer container = WireRegistry.instance.getContainerFromMeta(itemDamage);
        int min = this.getMinPixels(container);
        int max = this.getMaxPixels(container);
        TextureAtlasSprite sprite = Ic2Icons.getTextures(container.getType() > 7 ? "bcable2" : "bcable")[container.getInfo().getTexture(container.getInsulation(), color, active)];
        TextureAtlasSprite lumiTexture = this.getTexture(active);
        info.coreQuads.putAll(this.generateCoreQuads(sprite, min, max));
        for (EnumFacing side : EnumFacing.field_82609_l) {
            info.sideQuads.put(side, this.generateQuadsForSide(sprite, side, min, max, 0.0f));
            info.smallSideQuad.put(side, this.generateQuadsForSide(sprite, side, min, max, 0.0625f));
            info.lampQuads.put(side, this.generateQuadsForLamp(lumiTexture, side));
        }
        return info;
    }

    public List<BakedQuad> createQuads(MultiLuminatorEntry entry) {
        GeneratorInfo info = quadInfo.get((Object)entry.color)[entry.meta][entry.active ? 1 : 0];
        ArrayList<BakedQuad> resultList = new ArrayList<BakedQuad>();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            boolean lamp = entry.lamps.contains(side);
            if (lamp) {
                resultList.addAll((Collection<BakedQuad>)info.smallSideQuad.get(side));
                resultList.addAll((Collection<BakedQuad>)info.lampQuads.get(side));
                continue;
            }
            if (entry.connect.contains(side)) {
                resultList.addAll((Collection<BakedQuad>)info.sideQuads.get(side));
                continue;
            }
            resultList.add(info.coreQuads.get(side));
        }
        return resultList;
    }

    private int convertToPixel(CableContainer cont) {
        return (int)(16.0 * (cont.getInfo().getConductorThickness(cont.getInsulation()) / 16.0 / 2.0));
    }

    private int getMinPixels(CableContainer cont) {
        return 8 - this.convertToPixel(cont);
    }

    private int getMaxPixels(CableContainer cont) {
        return 8 + this.convertToPixel(cont);
    }

    private Map<EnumFacing, BakedQuad> generateCoreQuads(TextureAtlasSprite sprite, int min, int max) {
        Vector3f minF = new Vector3f((float)min, (float)min, (float)min);
        Vector3f maxF = new Vector3f((float)max, (float)max, (float)max);
        BlockPartFace face = new BlockPartFace(null, -1, "", new BlockFaceUV(new float[]{min, min, max, max}, 0));
        EnumMap<EnumFacing, BakedQuad> quads = new EnumMap<EnumFacing, BakedQuad>(EnumFacing.class);
        for (EnumFacing side : EnumFacing.field_82609_l) {
            quads.put(side, this.getBakery().func_178414_a(minF, maxF, face, sprite, side, ModelRotation.X0_Y0, null, true, true));
        }
        return quads;
    }

    private List<BakedQuad> generateQuadsForSide(TextureAtlasSprite sprite, EnumFacing facing, int min, int max, float offset) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Pair<Vector3f, Vector3f> position = this.getPosForSide(facing, min, max, offset);
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (side.func_176734_d() == facing) continue;
            BlockPartFace face = null;
            face = side == facing ? new BlockPartFace(null, -1, "", new BlockFaceUV(new float[]{min, min, max, max}, 0)) : (facing.func_176740_k() == EnumFacing.Axis.Z && side.func_176740_k() == EnumFacing.Axis.X ? new BlockPartFace(null, -1, "", new BlockFaceUV(new float[]{max, min, 16.0f, max}, 0)) : this.getFace(facing, min, max));
            quads.add(this.getBakery().func_178414_a((Vector3f)position.getKey(), (Vector3f)position.getValue(), face, sprite, side, ModelRotation.X0_Y0, null, true, true));
        }
        return quads;
    }

    private List<BakedQuad> generateQuadsForLamp(TextureAtlasSprite sprite, EnumFacing facing) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        float[] array = MultiPartLuminatorModel.getBoundingBoxForSide(facing.func_176745_a());
        for (EnumFacing side : EnumFacing.field_82609_l) {
            float[] fArray;
            if (side == facing || side.func_176734_d() == facing) {
                float[] fArray2 = new float[4];
                fArray2[0] = 0.0f;
                fArray2[1] = 0.0f;
                fArray2[2] = 16.0f;
                fArray = fArray2;
                fArray2[3] = 16.0f;
            } else if (side.func_176740_k().func_176720_b()) {
                float[] fArray3 = new float[4];
                fArray3[0] = 0.0f;
                fArray3[1] = 15.0f;
                fArray3[2] = 16.0f;
                fArray = fArray3;
                fArray3[3] = 16.0f;
            } else {
                float[] fArray4 = new float[4];
                fArray4[0] = 15.0f;
                fArray4[1] = 0.0f;
                fArray4[2] = 16.0f;
                fArray = fArray4;
                fArray4[3] = 16.0f;
            }
            float[] arraySide = fArray;
            quads.add(this.getBakery().func_178414_a(new Vector3f(16.0f * array[0], 16.0f * array[1], 16.0f * array[2]), new Vector3f(16.0f * array[3], 16.0f * array[4], 16.0f * array[5]), new BlockPartFace(null, facing.func_176745_a() * 10 + side.func_176745_a(), "", new BlockFaceUV(arraySide, 0)), sprite, side, ModelRotation.X0_Y0, null, true, true));
        }
        return quads;
    }

    private Pair<Vector3f, Vector3f> getPosForSide(EnumFacing facing, int min, int max, float offset) {
        switch (facing) {
            case DOWN: {
                return Pair.of((Object)new Vector3f((float)min, 0.0f + offset, (float)min), (Object)new Vector3f((float)max, (float)min, (float)max));
            }
            case UP: {
                return Pair.of((Object)new Vector3f((float)min, (float)max, (float)min), (Object)new Vector3f((float)max, 16.0f - offset, (float)max));
            }
            case NORTH: {
                return Pair.of((Object)new Vector3f((float)min, (float)min, 0.0f + offset), (Object)new Vector3f((float)max, (float)max, (float)min));
            }
            case SOUTH: {
                return Pair.of((Object)new Vector3f((float)min, (float)min, (float)max), (Object)new Vector3f((float)max, (float)max, 16.0f - offset));
            }
            case WEST: {
                return Pair.of((Object)new Vector3f(0.0f + offset, (float)min, (float)min), (Object)new Vector3f((float)min, (float)max, (float)max));
            }
            case EAST: {
                return Pair.of((Object)new Vector3f((float)max, (float)min, (float)min), (Object)new Vector3f(16.0f - offset, (float)max, (float)max));
            }
        }
        return Pair.of((Object)new Vector3f((float)min, (float)min, (float)min), (Object)new Vector3f((float)max, (float)max, (float)max));
    }

    private BlockPartFace getFace(EnumFacing facing, int min, int max) {
        switch (facing) {
            case DOWN: {
                return new BlockPartFace(null, -1, "", new BlockFaceUV(new float[]{min, max, max, 16.0f}, 0));
            }
            case UP: {
                return new BlockPartFace(null, -1, "", new BlockFaceUV(new float[]{min, 0.0f, max, min}, 0));
            }
            case NORTH: {
                return new BlockPartFace(null, -1, "", new BlockFaceUV(new float[]{min, 0.0f, max, min}, 0));
            }
            case SOUTH: {
                return new BlockPartFace(null, -1, "", new BlockFaceUV(new float[]{min, max, max, 16.0f}, 0));
            }
            case WEST: {
                return new BlockPartFace(null, -1, "", new BlockFaceUV(new float[]{0.0f, min, min, max}, 0));
            }
            case EAST: {
                return new BlockPartFace(null, -1, "", new BlockFaceUV(new float[]{max, min, 16.0f, max}, 0));
            }
        }
        return new BlockPartFace(null, -1, "", new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0));
    }

    private TextureAtlasSprite getTexture(boolean active) {
        return Ic2Icons.getTextures("b0")[active ? 31 : 30];
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.getCamera(), (ItemCameraTransforms.TransformType)cameraTransformType);
    }

    public static float[] getBoundingBoxForSide(int side) {
        float px = 0.0625f;
        switch (side) {
            case 0: {
                return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f * px, 1.0f};
            }
            case 1: {
                return new float[]{0.0f, 15.0f * px, 0.0f, 1.0f, 1.0f, 1.0f};
            }
            case 2: {
                return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f * px};
            }
            case 3: {
                return new float[]{0.0f, 0.0f, 15.0f * px, 1.0f, 1.0f, 1.0f};
            }
            case 4: {
                return new float[]{0.0f, 0.0f, 0.0f, 1.0f * px, 1.0f, 1.0f};
            }
            case 5: {
                return new float[]{15.0f * px, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
            }
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    public static class GeneratorInfo {
        Map<EnumFacing, BakedQuad> coreQuads = new EnumMap<EnumFacing, BakedQuad>(EnumFacing.class);
        Map<EnumFacing, List<BakedQuad>> sideQuads = new EnumMap<EnumFacing, List<BakedQuad>>(EnumFacing.class);
        Map<EnumFacing, List<BakedQuad>> smallSideQuad = new EnumMap<EnumFacing, List<BakedQuad>>(EnumFacing.class);
        Map<EnumFacing, List<BakedQuad>> lampQuads = new EnumMap<EnumFacing, List<BakedQuad>>(EnumFacing.class);
    }

    public static class MultiLuminatorEntry {
        int meta;
        IEnergyConductorColored.WireColor color;
        Set<EnumFacing> lamps;
        Set<EnumFacing> connect;
        boolean active;
        int hashCode;

        public MultiLuminatorEntry(Set<EnumFacing> lampSides, Set<EnumFacing> connectSide, int damage, IEnergyConductorColored.WireColor wirecolor, boolean activated) {
            this.meta = damage;
            this.color = wirecolor;
            this.lamps = lampSides;
            this.connect = connectSide;
            this.active = activated;
            this.hashCode = Objects.hash(new Object[]{this.meta, this.color, this.lamps, this.connect, this.active});
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MultiLuminatorEntry) {
                MultiLuminatorEntry part = (MultiLuminatorEntry)obj;
                return part.meta == this.meta && part.active == this.active && part.color == this.color && part.lamps.equals(this.lamps) && part.connect.equals(this.connect);
            }
            return false;
        }
    }
}

