/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import ic2.core.IC2;
import ic2.core.block.base.BlockMultiID;
import ic2.core.block.base.tile.TileEntityBlock;
import ic2.core.block.base.tile.TileEntityChargePadBase;
import ic2.core.entity.IC2DamageSource;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2States;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.obj.IBlockTextureModifier;
import ic2.core.util.helpers.BlockStateContainerIC2;
import ic2.core.util.obj.IBootable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockChargePad
extends BlockMultiID
implements IBootable,
IBlockTextureModifier {
    public BlockChargePad() {
        super(Material.field_151573_f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(1.5f);
        this.setUnlocalizedName(Ic2BlockLang.chargePad);
        this.setHarvestLevel("pickaxe", 1);
    }

    @Override
    public void onLoad() {
        Ic2States.chargePadLV = this.func_176203_a(0);
        Ic2States.chargePadMV = this.func_176203_a(1);
        Ic2States.chargePadHV = this.func_176203_a(2);
        Ic2States.chargePadNuclear = this.func_176203_a(3);
        Ic2Items.chargePadLV = new ItemStack((Block)this, 1, 0);
        Ic2Items.chargePadMV = new ItemStack((Block)this, 1, 1);
        Ic2Items.chargePadHV = new ItemStack((Block)this, 1, 2);
        Ic2Items.chargePadNuclear = new ItemStack((Block)this, 1, 3);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainerIC2((Block)this, new IProperty[]{this.getMetadataProperty(), active});
    }

    @Override
    public List<IBlockState> getValidStates() {
        return this.func_176194_O().func_177619_a();
    }

    @Override
    public List<IBlockState> getValidStateList() {
        IBlockState def = this.func_176223_P();
        ArrayList<IBlockState> state = new ArrayList<IBlockState>();
        for (int meta : this.getValidMetas()) {
            state.add(def.func_177226_a((IProperty)this.getMetadataProperty(), (Comparable)Integer.valueOf(meta)).func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(false)));
            state.add(def.func_177226_a((IProperty)this.getMetadataProperty(), (Comparable)Integer.valueOf(meta)).func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(true)));
        }
        return state;
    }

    @Override
    public boolean hasFacing() {
        return false;
    }

    @Override
    public TileEntityBlock createNewTileEntity(World worldIn, int meta) {
        TileEntityChargePadBase.ChargePadType[] types = TileEntityChargePadBase.ChargePadType.values();
        if (meta >= 0 && meta < types.length) {
            return types[meta].createPad();
        }
        return null;
    }

    @Override
    public List<Integer> getValidMetas() {
        return Arrays.asList(0, 1, 2, 3);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite[] getIconSheet(int meta) {
        return Ic2Icons.getTextures("CPad");
    }

    @Override
    public int getMaxSheetSize(int meta) {
        return 4;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    public int getRedstoneStrengh(IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return 0;
        }
        return this.isPadActive(world, pos) ? 15 : 0;
    }

    @Override
    @Deprecated
    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return this.getRedstoneStrengh(blockAccess, pos, side);
    }

    @Override
    @Deprecated
    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return this.getRedstoneStrengh(blockAccess, pos, side);
    }

    @Override
    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    private boolean isPadActive(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityChargePadBase) {
            TileEntityChargePadBase pad = (TileEntityChargePadBase)tile;
            if (pad.isForcedOff) {
                return false;
            }
            return pad.getActive();
        }
        return false;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        if (worldIn.field_72995_K) {
            return;
        }
        TileEntityChargePadBase.ChargePadType type = TileEntityChargePadBase.ChargePadType.getType(this.func_176201_c(worldIn.func_180495_p(pos)));
        if (type == null) {
            return;
        }
        if (type.getMaxImpact() >= fallDistance) {
            return;
        }
        if (entityIn instanceof EntityLivingBase) {
            ((EntityLivingBase)entityIn).func_70097_a((DamageSource)IC2DamageSource.electricity, (float)(3 + 3 * type.ordinal()));
        }
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (worldIn.field_72995_K || !(entityIn instanceof EntityLivingBase)) {
            return;
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        if (!(tile instanceof TileEntityChargePadBase)) {
            return;
        }
        TileEntityChargePadBase pad = (TileEntityChargePadBase)tile;
        if (pad.isForcedOff) {
            return;
        }
        if (pad.getActive()) {
            pad.activeTime = 20;
            return;
        }
        pad.setActive(true);
        pad.activeTime = 20;
        IC2.network.get().initiateTileEntityEvent(pad, 1, false);
        worldIn.func_190524_a(pos, (Block)this, pos);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            BlockPos newPos = pos.func_177972_a(facing);
            if (!worldIn.func_175668_a(newPos, false)) continue;
            worldIn.func_190524_a(newPos, (Block)this, pos);
        }
    }

    @Deprecated
    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (!this.isPadActive((IBlockAccess)worldIn, pos)) {
            return;
        }
        ((TileEntityChargePadBase)worldIn.func_175625_s(pos)).spawnParticals(rand);
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox(IBlockState state) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
    }

    @Override
    public boolean hasTextureRotation(IBlockState state, EnumFacing side) {
        return false;
    }

    @Override
    public int getTextureRotation(IBlockState state, EnumFacing side) {
        return 0;
    }

    @Override
    public boolean hasCustomTextureUV(IBlockState state, EnumFacing side) {
        return side.func_176740_k().func_176722_c();
    }

    @Override
    public float[] getCustomTextureUV(IBlockState state, EnumFacing side) {
        return new float[]{0.0f, 12.0f, 16.0f, 16.0f};
    }

    @Override
    public boolean needsRedstoneUpdates(int meta) {
        return false;
    }
}

