/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.energy;

import ic2.api.classic.energy.IPacketEnergyNet;
import ic2.api.classic.energy.PacketStat;
import ic2.api.classic.energy.render.IRenderValidator;
import ic2.api.energy.IEnergyNetEventReceiver;
import ic2.api.energy.NodeStats;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.info.ILocatable;
import ic2.core.IC2;
import ic2.core.energy.EnergyNetLocal;
import ic2.core.network.packets.server.EnergyNetRendererPacket;
import ic2.core.util.helpers.AabbUtil;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnergyNetGlobal
implements IPacketEnergyNet {
    private static Map<World, EnergyNetLocal> worldToEnergyNetMap = new HashMap<World, EnergyNetLocal>();
    private static List<IEnergyNetEventReceiver> receivers = new ArrayList<IEnergyNetEventReceiver>();
    private static EventHandler handler;
    static EnergyNetGlobal global;

    public static EnergyNetGlobal initialize() {
        handler = new EventHandler();
        global = new EnergyNetGlobal();
        return global;
    }

    @Override
    public EnumActionResult drawTile(World world, BlockPos pos, IRenderValidator validator) {
        if (IC2.platform.isRendering()) {
            return EnumActionResult.PASS;
        }
        EnergyNetLocal local = EnergyNetGlobal.getForWorld(world);
        if (local == null) {
            return EnumActionResult.PASS;
        }
        ArrayList<Tuple<BlockPos, Tuple<Map<BlockPos, List<BlockPos>>, Map<BlockPos, Double>>>> list = new ArrayList<Tuple<BlockPos, Tuple<Map<BlockPos, List<BlockPos>>, Map<BlockPos, Double>>>>();
        if (validator.isReverse()) {
            Set<IEnergySink> sinks = local.getSinksFromPosition(pos);
            if (sinks.isEmpty()) {
                return EnumActionResult.FAIL;
            }
            for (IEnergySink sink : sinks) {
                list.add(local.getData(sink));
            }
        } else {
            Set<IEnergySource> sources = local.getSourcesFromPosition(pos);
            if (sources.isEmpty()) {
                return EnumActionResult.FAIL;
            }
            for (IEnergySource source : sources) {
                list.add(local.getData(source));
            }
        }
        EnergyNetRendererPacket craft = new EnergyNetRendererPacket(validator, list);
        int maxDistance = IC2.platform.getServer().func_184103_al().func_72372_a() - 16;
        for (EntityPlayer player : world.field_73010_i) {
            int distance = Math.min(Math.abs(pos.func_177958_n() - (int)player.field_70165_t), Math.abs(pos.func_177952_p() - (int)player.field_70161_v));
            if (distance > maxDistance) continue;
            IC2.network.get(true).sendCustomPacket(player, craft);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public EnumActionResult drawAreaInTiles(World world, BlockPos min, BlockPos max, EntityPlayer player, IRenderValidator validator) {
        if (IC2.platform.isRendering()) {
            return EnumActionResult.PASS;
        }
        EnergyNetLocal local = EnergyNetGlobal.getForWorld(world);
        if (local == null) {
            return EnumActionResult.PASS;
        }
        ArrayList<Tuple<BlockPos, Tuple<Map<BlockPos, List<BlockPos>>, Map<BlockPos, Double>>>> list = new ArrayList<Tuple<BlockPos, Tuple<Map<BlockPos, List<BlockPos>>, Map<BlockPos, Double>>>>();
        if (validator.isReverse()) {
            Set<IEnergySink> sinks = local.getSinksFromArea(new AabbUtil.BoundingBox(min, max));
            if (sinks.isEmpty()) {
                return EnumActionResult.FAIL;
            }
            for (IEnergySink sink : sinks) {
                list.add(local.getData(sink));
            }
        } else {
            Set<IEnergySource> sources = local.getSourcesFromArea(new AabbUtil.BoundingBox(min, max));
            if (sources.isEmpty()) {
                return EnumActionResult.FAIL;
            }
            for (IEnergySource source : sources) {
                list.add(local.getData(source));
            }
        }
        IC2.network.get(true).sendCustomPacket(player, new EnergyNetRendererPacket(validator, list));
        return EnumActionResult.SUCCESS;
    }

    @Override
    public IEnergyTile getTile(World world, BlockPos pos) {
        EnergyNetLocal.EnergyTileContainer cont = this.getContainer(world, pos);
        if (cont != null) {
            return cont.tile;
        }
        return null;
    }

    @Override
    public IEnergyTile getSubTile(World world, BlockPos pos) {
        EnergyNetLocal.EnergyTileContainer cont = this.getContainer(world, pos);
        if (cont != null) {
            return cont.subTile;
        }
        return null;
    }

    private EnergyNetLocal.EnergyTileContainer getContainer(World world, BlockPos pos) {
        EnergyNetLocal local = EnergyNetGlobal.getForWorld(world);
        if (local != null) {
            return local.getContainer(pos);
        }
        return null;
    }

    @Override
    public World getWorld(IEnergyTile tile) {
        if (tile instanceof TileEntity) {
            return ((TileEntity)tile).func_145831_w();
        }
        if (tile instanceof ILocatable) {
            return ((ILocatable)((Object)tile)).getWorldObj();
        }
        return null;
    }

    @Override
    public BlockPos getPos(IEnergyTile tile) {
        if (tile instanceof TileEntity) {
            return ((TileEntity)tile).func_174877_v();
        }
        if (tile instanceof ILocatable) {
            return ((ILocatable)((Object)tile)).getPosition();
        }
        return null;
    }

    @Override
    public NodeStats getNodeStats(IEnergyTile tile) {
        EnergyNetLocal local = EnergyNetGlobal.getForWorld(this.getWorld(tile));
        if (local != null) {
            return local.getNodeStats(tile);
        }
        return new NodeStats(0.0, 0.0, 0.0);
    }

    @Override
    public <T extends TileEntity> void addTile(T tile) {
        EnergyNetLocal local = EnergyNetGlobal.getForWorld(this.getWorld((IEnergyTile)tile));
        if (local != null) {
            local.addTile((IEnergyTile)tile);
            this.onAdded((IEnergyTile)tile);
        }
    }

    @Override
    public <T extends ILocatable & IEnergyTile> void addTile(T tile) {
        EnergyNetLocal local = EnergyNetGlobal.getForWorld(this.getWorld(tile));
        if (local != null) {
            local.addTile(tile);
            this.onAdded(tile);
        }
    }

    @Override
    public void removeTile(IEnergyTile tile) {
        EnergyNetLocal local = EnergyNetGlobal.getForWorld(this.getWorld(tile));
        if (local != null) {
            local.removeTile(tile);
            this.onRemoved(tile);
        }
    }

    public void onAdded(IEnergyTile tile) {
        for (IEnergyNetEventReceiver listener : receivers) {
            listener.onAdd(tile);
        }
    }

    public void onRemoved(IEnergyTile tile) {
        for (IEnergyNetEventReceiver listener : receivers) {
            listener.onRemove(tile);
        }
    }

    @Override
    public boolean dumpDebugInfo(World world, BlockPos pos, PrintStream console, PrintStream chat) {
        return false;
    }

    @Override
    public void registerEventReceiver(IEnergyNetEventReceiver receiver) {
        receivers.add(receiver);
    }

    @Override
    public void unregisterEventReceiver(IEnergyNetEventReceiver receiver) {
        receivers.remove(receiver);
    }

    @Override
    public double getPowerFromTier(int tier) {
        if (tier > 13) {
            tier = 13;
        }
        return 8 << tier * 2;
    }

    @Override
    public int getTierFromPower(double power) {
        if (power <= 0.0) {
            return 0;
        }
        return (int)Math.ceil(Math.log(power / 8.0) / Math.log(4.0));
    }

    public static void onWorldUnload(World world) {
        if (handler != null) {
            handler.onWorldUnload(world);
        }
    }

    public static void onUnload() {
        for (EnergyNetLocal local : worldToEnergyNetMap.values()) {
            local.onUnload();
        }
        worldToEnergyNetMap.clear();
    }

    public static EnergyNetLocal getForWorld(World world) {
        if (world == null) {
            IC2.log.warn("EnergyNet.getForWorld: world = null, bad things may happen..");
            return null;
        }
        EnergyNetLocal local = worldToEnergyNetMap.get(world);
        if (local == null) {
            local = new EnergyNetLocal(world);
            worldToEnergyNetMap.put(world, local);
        }
        return local;
    }

    public static void onTickEnd(World world) {
        EnergyNetLocal local = EnergyNetGlobal.getForWorld(world);
        if (local != null) {
            local.onTickEnd();
        }
    }

    public static void onTickStart(World world) {
        EnergyNetLocal local = EnergyNetGlobal.getForWorld(world);
        if (local != null) {
            local.onTickStart();
        }
    }

    @Override
    public List<PacketStat> getPackets(IEnergyTile tile, IPacketEnergyNet.PacketType type) {
        EnergyNetLocal local = EnergyNetGlobal.getForWorld(this.getWorld(tile));
        if (local != null) {
            return local.getPackets(tile, type);
        }
        return new ArrayList<PacketStat>();
    }

    @Override
    public List<PacketStat> getTotalPackets(IEnergyTile tile, IPacketEnergyNet.PacketType type) {
        EnergyNetLocal local = EnergyNetGlobal.getForWorld(this.getWorld(tile));
        if (local != null) {
            return local.getTotalPackets(tile, type);
        }
        return new ArrayList<PacketStat>();
    }

    public static class EventHandler {
        public EventHandler() {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void onEnergyTileLoad(EnergyTileLoadEvent event) {
            EnergyNetLocal local = EnergyNetGlobal.getForWorld(event.getWorld());
            if (local != null) {
                local.addTile(event.tile);
                global.onAdded(event.tile);
            }
        }

        @SubscribeEvent
        public void onEnergyTileUnload(EnergyTileUnloadEvent event) {
            EnergyNetLocal local = EnergyNetGlobal.getForWorld(event.getWorld());
            if (local != null) {
                local.removeTile(event.tile);
                global.onRemoved(event.tile);
            }
        }

        public void onWorldUnload(World world) {
            EnergyNetLocal local = (EnergyNetLocal)worldToEnergyNetMap.remove(world);
            if (local != null) {
                local.onUnload();
            }
        }
    }
}

