/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.entity.boat;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import ic2.core.entity.boat.EntityClassicBoat;
import ic2.core.entity.container.ContainerElectricBoat;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Resources;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class EntityElectricBoat
extends EntityClassicBoat
implements IInventoryChangedListener,
IHasGui {
    private static final DataParameter<Float> FORCE = EntityDataManager.func_187226_a(EntityElectricBoat.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> CHARGE = EntityDataManager.func_187226_a(EntityElectricBoat.class, (DataSerializer)DataSerializers.field_187193_c);
    public InventoryBasic chest;
    private float speedCheck = 0.0f;
    public static double MaxUsage = 2.5;
    public boolean guiOpen = false;

    public EntityElectricBoat(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public EntityElectricBoat(World world) {
        super(world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FORCE, (Object)new Float(0.0f));
        this.field_70180_af.func_187214_a(CHARGE, (Object)new Float(0.0f));
        this.chest = new InventoryBasic("BatterySlot", false, 1);
        this.chest.func_110134_a((IInventoryChangedListener)this);
    }

    @Override
    public ItemStack getItem() {
        return Ic2Items.boatElectric.func_77946_l();
    }

    @Override
    public ResourceLocation getTexture() {
        return Ic2Resources.electricBoat;
    }

    @Override
    public LocaleComp getNameComponent() {
        return Ic2ItemLang.boatElectric;
    }

    @Override
    public void onRammingBreaking(double speed) {
        this.func_70099_a(this.getItem(), 0.0f);
        if (!this.chest.func_70301_a(0).func_190926_b()) {
            this.func_70099_a(this.chest.func_70301_a(0), 0.0f);
            this.chest.func_70299_a(0, ItemStack.field_190927_a);
        }
    }

    @Override
    public void onPlayerBreaking() {
        super.onPlayerBreaking();
        if (!this.chest.func_70301_a(0).func_190926_b()) {
            this.func_70099_a(this.chest.func_70301_a(0), 0.0f);
            this.chest.func_70299_a(0, ItemStack.field_190927_a);
        }
    }

    @Override
    public void onFallingBreaking(float fallingDistance) {
        this.func_70099_a(this.getItem(), 0.0f);
        if (!this.chest.func_70301_a(0).func_190926_b()) {
            this.func_70099_a(this.chest.func_70301_a(0), 0.0f);
            this.chest.func_70299_a(0, ItemStack.field_190927_a);
        }
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        if (nbt.func_74764_b("Inv")) {
            this.chest.func_70299_a(0, new ItemStack(nbt.func_74775_l("Inv")));
        } else {
            this.chest.func_70299_a(0, ItemStack.field_190927_a);
        }
        this.field_70180_af.func_187227_b(FORCE, (Object)Float.valueOf(nbt.func_74760_g("Speed")));
        this.field_70180_af.func_187227_b(CHARGE, (Object)Float.valueOf(this.getCharge(this.chest.func_70301_a(0))));
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        if (!this.chest.func_70301_a(0).func_190926_b()) {
            NBTTagCompound data = new NBTTagCompound();
            this.chest.func_70301_a(0).func_77955_b(data);
            nbt.func_74782_a("Inv", (NBTBase)data);
        }
        this.speedCheck = ((Float)this.field_70180_af.func_187225_a(FORCE)).floatValue();
        nbt.func_74776_a("Speed", this.speedCheck);
    }

    private float getCharge(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof IElectricItem)) {
            return 0.0f;
        }
        IElectricItem item = (IElectricItem)stack.func_77973_b();
        return (float)(ElectricItem.manager.getCharge(stack) / item.getMaxCharge(stack));
    }

    @Override
    public void func_70071_h_() {
        if (IC2.platform.isSimulating()) {
            Entity rider = this.getRider();
            if (this.chest.func_70301_a(0).func_190926_b()) {
                if (this.speedCheck != 0.0f) {
                    this.speedCheck = 0.0f;
                    this.field_70180_af.func_187227_b(FORCE, (Object)Float.valueOf(0.0f));
                }
                if (rider != null && rider instanceof EntityPlayer && IC2.keyboard.isSideinventoryKeyDown((EntityPlayer)rider) && !this.guiOpen) {
                    IC2.platform.launchGui((EntityPlayer)rider, this, null);
                    this.guiOpen = true;
                }
            } else if (rider == null || !(rider instanceof EntityPlayer)) {
                double energyUsage = Math.max(this.speedCheck != 0.0f ? 1.0 : 0.0, Math.abs((double)this.speedCheck * (this.speedCheck < 0.0f ? MaxUsage * 2.0 : MaxUsage)));
                energyUsage -= ElectricItem.manager.discharge(this.chest.func_70301_a(0), energyUsage, Integer.MAX_VALUE, true, true, false);
                this.field_70180_af.func_187227_b(CHARGE, (Object)Float.valueOf(this.getCharge(this.chest.func_70301_a(0))));
                if (energyUsage != 0.0 || this.field_70159_w == 0.0 && this.field_70179_y == 0.0) {
                    this.speedCheck = 0.0f;
                    this.field_70180_af.func_187227_b(FORCE, (Object)Float.valueOf(0.0f));
                }
            } else {
                EntityPlayer player = (EntityPlayer)rider;
                if (player.field_191988_bg != 0.0f) {
                    if (player.field_191988_bg > 0.0f && this.speedCheck < 4.0f || player.field_191988_bg < 0.0f && this.speedCheck > -2.0f) {
                        this.speedCheck += 0.05f * player.field_191988_bg;
                        this.speedCheck = Math.min(4.0f, Math.max(-2.0f, this.speedCheck));
                        this.field_70180_af.func_187227_b(FORCE, (Object)Float.valueOf(this.speedCheck));
                    }
                } else if (IC2.keyboard.isModeSwitchKeyDown(player)) {
                    this.speedCheck = 0.0f;
                    this.field_70180_af.func_187227_b(FORCE, (Object)Float.valueOf(0.0f));
                }
                double energyUsage = Math.max(this.speedCheck != 0.0f ? 1.0 : 0.0, Math.abs((double)this.speedCheck * (this.speedCheck < 0.0f ? MaxUsage * 2.0 : MaxUsage)));
                if (!ElectricItem.manager.use(this.chest.func_70301_a(0), energyUsage, (EntityLivingBase)player)) {
                    this.speedCheck = 0.0f;
                    this.field_70180_af.func_187227_b(FORCE, (Object)Float.valueOf(0.0f));
                }
                this.field_70180_af.func_187227_b(CHARGE, (Object)Float.valueOf(this.getCharge(this.chest.func_70301_a(0))));
                if (IC2.keyboard.isSideinventoryKeyDown(player) && !this.guiOpen) {
                    IC2.platform.launchGui(player, this, null);
                    this.guiOpen = true;
                }
            }
        }
        super.func_70071_h_();
    }

    @Override
    public float getSpeed(EntityLivingBase base) {
        return ((Float)this.field_70180_af.func_187225_a(FORCE)).floatValue();
    }

    @Override
    public double getTopSpeed() {
        return 2.0;
    }

    @Override
    public boolean hasAfkSpeed() {
        return this.speedCheck != 0.0f;
    }

    @Override
    public float getAfkSpeed() {
        return ((Float)this.field_70180_af.func_187225_a(FORCE)).floatValue();
    }

    @Override
    public double getMaxRammingSpeed() {
        return 2.0;
    }

    public void func_76316_a(IInventory invBasic) {
        if (IC2.platform.isRendering()) {
            return;
        }
        this.field_70180_af.func_187227_b(CHARGE, (Object)Float.valueOf(this.getCharge(this.chest.func_70301_a(0))));
    }

    public float getCharge() {
        return ((Float)this.field_70180_af.func_187225_a(CHARGE)).floatValue();
    }

    public float getForce() {
        return ((Float)this.field_70180_af.func_187225_a(FORCE)).floatValue();
    }

    @Override
    public void onGuiClosed(EntityPlayer p0) {
        this.guiOpen = false;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerElectricBoat(player.field_71071_by, (IInventory)this.chest, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.field_70128_L;
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }
}

