/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.gui.components.reactorPlanner;

import ic2.core.block.machine.med.TileEntityReactorPlanner;
import ic2.core.block.machine.med.container.ContainerReactorPlanner;
import ic2.core.block.machine.med.logic.ReactorLogicBase;
import ic2.core.block.machine.med.logic.encoder.ByteShifter;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.buttons.IC2Button;
import ic2.core.inventory.gui.components.GuiComponent;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.platform.registry.Ic2GuiComp;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ReactorPlannerButtonHandler
extends GuiComponent {
    boolean lastRun = false;
    TileEntityReactorPlanner planner;

    public ReactorPlannerButtonHandler(TileEntityReactorPlanner tile) {
        super(Ic2GuiComp.nullBox);
        this.planner = tile;
    }

    @Override
    public List<GuiComponent.ActionRequest> getNeededRequests() {
        return Arrays.asList(GuiComponent.ActionRequest.ButtonNotify, GuiComponent.ActionRequest.GuiInit, GuiComponent.ActionRequest.GuiTick);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiInit(GuiIC2 gui) {
        int x = gui.getXOffset();
        int y = gui.getYOffset();
        gui.registerButton(new IC2Button(5, x + 215, y + 110, 10, 10, "-"));
        gui.registerButton(new IC2Button(6, x + 260, y + 110, 10, 10, "+"));
        gui.registerButton(new IC2Button(7, x + 170, y + 20, 43, 10, Ic2GuiLang.simulationStart));
        gui.registerButton(new IC2Button(8, x + 170, y + 44, 43, 10, Ic2GuiLang.simulationStop));
        gui.registerButton(new IC2Button(14, x + 170, y + 32, 43, 10, this.getPauseState()));
        gui.registerButton(new IC2Button(9, x + 170, y + 58, 43, 10, Ic2GuiLang.simulationCompile));
        gui.registerButton(new IC2Button(10, x + 170, y + 70, 43, 10, Ic2GuiLang.simulationReset));
        gui.registerButton(new IC2Button(11, x + 170, y + 84, 43, 10, Ic2GuiLang.simulationBackup));
        gui.registerButton(new IC2Button(12, x + 170, y + 96, 43, 10, Ic2GuiLang.simulationRestore));
        gui.registerButton(new IC2Button(13, x + 170, y + 110, 43, 10, Ic2GuiLang.simulationClear));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiTick(GuiIC2 gui) {
        ReactorLogicBase logic = this.planner.getReactorLogic();
        IC2Button button = gui.getCastedButton(14, IC2Button.class);
        button.field_146124_l = logic.isValid();
        if (this.lastRun != logic.producing) {
            this.lastRun = logic.producing;
            button.setName(this.getPauseState());
        }
        gui.getButton((int)5).field_146124_l = this.planner.stackSize > 1;
        gui.getButton((int)6).field_146124_l = this.planner.stackSize < 64;
        gui.getButton((int)7).field_146124_l = logic.isValid() && !this.planner.getActive();
        gui.getButton((int)8).field_146124_l = this.planner.getActive();
        gui.getButton((int)9).field_146124_l = !logic.isValid();
        gui.getButton((int)10).field_146124_l = logic.isValid() && logic.ticksDone > 0;
        gui.getButton((int)11).field_146124_l = logic.isValid();
        gui.getButton((int)12).field_146124_l = this.planner.backup.hasBackup;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onButtonClick(GuiIC2 gui, GuiButton button) {
        int id = button.field_146127_k;
        ByteShifter shifter = new ByteShifter();
        int value = 0;
        if (id == 5 || id == 6) {
            value = id == 5 ? -1 : 1;
            if (gui.func_146272_n()) {
                value *= 10;
            }
            shifter.writeInteger(0, 3);
        } else if (id == 7 || id == 8) {
            value = id == 7 ? 0 : 1;
            shifter.writeInteger(1, 3);
        } else if (id == 9 || id == 10) {
            value = id == 9 ? 0 : 1;
            shifter.writeInteger(2, 3);
        } else if (id == 11) {
            shifter.writeInteger(3, 3);
        } else if (id == 12) {
            shifter.writeInteger(3, 3);
            value = 1;
            TileEntityReactorPlanner.ReactorBackup backup = this.planner.backup;
            this.planner.getReactorLogic().clear();
            this.planner.getPrediction().clear();
            this.planner.isSteamReactor = backup.isSteam;
            this.planner.reactorSize = backup.reactorSize;
            ContainerReactorPlanner cont = gui.getContainer(ContainerReactorPlanner.class);
            if (cont != null) {
                cont.reset(gui.getPlayer().field_71071_by);
            }
        } else if (id == 13) {
            shifter.writeInteger(4, 3);
            int n = value = gui.func_146272_n() ? 1 : 0;
            if (value == 0) {
                this.planner.getReactorLogic().clear();
            }
        } else if (id == 14) {
            shifter.writeInteger(5, 3);
        } else {
            return;
        }
        shifter.writeInteger(1, 3);
        this.planner.getNetwork().initiateClientTileEntityEvent(this.planner, shifter.getEncodedData(), value);
    }

    private LocaleComp getPauseState() {
        if (this.planner.getReactorLogic().producing) {
            return Ic2GuiLang.simulationPause;
        }
        return Ic2GuiLang.simulationRun;
    }
}

