/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.gui.components.reactorPlanner;

import ic2.core.block.machine.med.TileEntityReactorPlanner;
import ic2.core.block.machine.med.logic.TickingReactorLogic;
import ic2.core.block.machine.med.logic.TickingSteamReactorLogic;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.components.GuiComponent;
import ic2.core.inventory.gui.components.reactorPlanner.ReactorPlannerPageBaseComp;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.platform.registry.Ic2GuiComp;
import java.util.Arrays;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ReactorPlannerPageZeroComp
extends ReactorPlannerPageBaseComp {
    public ReactorPlannerPageZeroComp(TileEntityReactorPlanner tile) {
        super(Ic2GuiComp.reactorPlannerPageZero, 0, new ItemStack(Items.field_151061_bv), tile);
    }

    @Override
    public List<GuiComponent.ActionRequest> getNeededRequests() {
        return Arrays.asList(GuiComponent.ActionRequest.BackgroundDraw, GuiComponent.ActionRequest.FrontgroundDraw, GuiComponent.ActionRequest.MouseClick, GuiComponent.ActionRequest.ToolTip);
    }

    @Override
    public LocaleComp getName() {
        return Ic2GuiLang.reactorPrediction;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawFrontground(GuiIC2 gui, int mouseX, int mouseY) {
        if (!this.isPageSelected()) {
            return;
        }
        if (this.planner.isSteamReactor) {
            TickingSteamReactorLogic.SteamReactorPrediction predict = (TickingSteamReactorLogic.SteamReactorPrediction)this.planner.getPrediction();
            gui.drawString(Ic2GuiLang.expectedSteamProduction.getLocalizedFormatted(format.format(predict.steamPerTick)), 5, 130, 0x404040);
            gui.drawString(Ic2GuiLang.totalSteamProduction.getLocalizedFormatted(format.format(predict.totalSteamProduced)), 5, 139, 0x404040);
            gui.drawString(Ic2GuiLang.totalHeatProduction.getLocalizedFormatted(format.format(predict.totalHeatProduced)), 5, 148, 0x404040);
            gui.drawString(Ic2GuiLang.explosionEffectModifier.getLocalizedFormatted(Float.valueOf(predict.totalExplosionPower)), 5, 157, 0x404040);
            gui.drawString(Ic2GuiLang.reactorEfficiency.getLocalizedFormatted(floatFormat.format(predict.efficency), floatFormat.format(predict.totalEfficency)), 5, 166, 0x404040);
            gui.drawString(Ic2GuiLang.isBreeder.getLocalizedFormatted(predict.breeder), 5, 175, 0x404040);
        } else {
            TickingReactorLogic.ReactorPrediction predict = (TickingReactorLogic.ReactorPrediction)this.planner.getPrediction();
            gui.drawString(Ic2GuiLang.expectedEUProduction.getLocalizedFormatted(format.format(predict.energyPerTick)), 5, 130, 0x404040);
            gui.drawString(Ic2GuiLang.totalEUProduction.getLocalizedFormatted(format.format(predict.totalEnergyProduced)), 5, 139, 0x404040);
            gui.drawString(Ic2GuiLang.totalHeatProduction.getLocalizedFormatted(format.format(predict.totalHeatProduced)), 5, 148, 0x404040);
            gui.drawString(Ic2GuiLang.explosionEffectModifier.getLocalizedFormatted(Float.valueOf(predict.totalExplosionPower)), 5, 157, 0x404040);
            gui.drawString(Ic2GuiLang.reactorEfficiency.getLocalizedFormatted(floatFormat.format(predict.efficency), floatFormat.format(predict.totalEfficency)), 5, 166, 0x404040);
            gui.drawString(Ic2GuiLang.isBreeder.getLocalizedFormatted(predict.breeder), 5, 175, 0x404040);
        }
    }
}

