/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.gui.components.special;

import ic2.core.block.generator.tile.TileEntityFuelBoiler;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.components.GuiComponent;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.registry.Ic2GuiComp;
import ic2.core.util.math.Box2D;
import ic2.core.util.math.Vec2i;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.item.EnumDyeColor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BoilerHeatComp
extends GuiComponent {
    TileEntityFuelBoiler boiler;
    Vec2i tex;

    public BoilerHeatComp(TileEntityFuelBoiler tile) {
        super(Ic2GuiComp.boilerHeatBox);
        this.boiler = tile;
        this.tex = Ic2GuiComp.boilerheatPos;
    }

    @Override
    public List<GuiComponent.ActionRequest> getNeededRequests() {
        return Arrays.asList(GuiComponent.ActionRequest.BackgroundDraw, GuiComponent.ActionRequest.ToolTip);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiIC2 gui, int mouseX, int mouseY, float particalTicks) {
        Box2D pos = this.getPosition();
        int heat = this.boiler.heat;
        int amount = (int)((float)heat / 24000.0f * (float)pos.getHeight());
        if (heat > 12000) {
            float effect = ((float)heat - 12000.0f) / 12000.0f;
            if (effect >= 0.2f) {
                int data = heat - 14400;
                float f = ((float)(data % 7500) + particalTicks) / 7500.0f;
                if (data >= 7500) {
                    f = 1.0f;
                }
                float[] afloat1 = EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.YELLOW);
                float[] afloat2 = EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.RED);
                GlStateManager.func_179124_c((float)(afloat1[0] * (1.0f - f) + afloat2[0] * f), (float)(afloat1[1] * (1.0f - f) + afloat2[1] * f), (float)(afloat1[2] * (1.0f - f) + afloat2[2] * f));
            } else {
                GlStateManager.func_179124_c((float)Color.YELLOW.getRed(), (float)Color.YELLOW.getGreen(), (float)Color.YELLOW.getBlue());
            }
            gui.func_73729_b(gui.getXOffset() + pos.getX(), gui.getYOffset() + pos.getY() + pos.getHeight() - amount, this.tex.getX(), this.tex.getY() + pos.getHeight() - amount, 6, amount + 1);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            float effect = (float)heat / 12000.0f;
            if (heat >= 2700) {
                int data = heat - 2700;
                float f = ((float)(data % 5000) + particalTicks) / 5000.0f;
                if (data >= 5000) {
                    f = 1.0f;
                }
                float[] afloat1 = EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.BLUE);
                float[] afloat2 = EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.YELLOW);
                GlStateManager.func_179124_c((float)(afloat1[0] * (1.0f - f) + afloat2[0] * f), (float)(afloat1[1] * (1.0f - f) + afloat2[1] * f), (float)(afloat1[2] * (1.0f - f) + afloat2[2] * f));
            } else {
                GlStateManager.func_179124_c((float)Color.BLUE.getRed(), (float)Color.BLUE.getGreen(), (float)Color.BLUE.getBlue());
            }
            gui.func_73729_b(gui.getXOffset() + pos.getX(), gui.getYOffset() + pos.getY() + pos.getHeight() - amount, this.tex.getX(), this.tex.getY() + pos.getHeight() - amount, 6, amount + 1);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onToolTipCollecting(GuiIC2 gui, int mouseX, int mouseY, List<String> tooltips) {
        if (this.position.isInBox(mouseX, mouseY)) {
            tooltips.add(Ic2InfoLang.reactorHeat.getLocalizedFormatted(this.boiler.heat / 30, 800));
        }
    }
}

