/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.management.misc;

import ic2.core.inventory.base.IHasInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class IHasInventoryWrapper
implements IItemHandlerModifiable {
    boolean allowExtraction = true;
    boolean allowInsertion = true;
    boolean allowModify = true;
    IHasInventory inv;

    public IHasInventoryWrapper(IHasInventory inventory) {
        this.inv = inventory;
    }

    public IHasInventoryWrapper setDissableInserting() {
        this.allowInsertion = false;
        return this;
    }

    public IHasInventoryWrapper setInsertingState(boolean state) {
        this.allowInsertion = state;
        return this;
    }

    public IHasInventoryWrapper setExtractingState(boolean state) {
        this.allowExtraction = state;
        return this;
    }

    public IHasInventoryWrapper setDissableExtraction() {
        this.allowExtraction = false;
        return this;
    }

    public IHasInventoryWrapper setDissableModify() {
        this.allowModify = false;
        return this;
    }

    public void loadFromState(int state) {
        if (state == 3) {
            this.allowExtraction = true;
            this.allowInsertion = true;
        } else if (state == 2) {
            this.allowInsertion = true;
            this.allowExtraction = false;
        } else if (state == 1) {
            this.allowExtraction = true;
            this.allowInsertion = false;
        } else {
            this.allowExtraction = false;
            this.allowInsertion = false;
        }
    }

    public int getValue() {
        int value = 0;
        if (this.allowExtraction) {
            ++value;
        }
        if (this.allowInsertion) {
            value += 2;
        }
        return value;
    }

    public int getSlots() {
        return this.inv.getSlotCount();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.inv.getStackInSlot(slot);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (!this.allowModify) {
            return;
        }
        this.inv.setStackInSlot(slot, stack);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (!this.allowInsertion) {
            return stack;
        }
        ItemStack slotItem = this.inv.getStackInSlot(slot);
        if (slotItem.func_190926_b()) {
            int max = Math.min(stack.func_77976_d(), this.inv.getMaxStackSize(slot));
            if (stack.func_190916_E() < max) {
                ItemStack copy = stack.func_77946_l();
                if (!simulate) {
                    this.inv.setStackInSlot(slot, copy.func_77979_a(max));
                    return copy;
                }
                copy.func_190918_g(max);
                return copy;
            }
            if (!simulate) {
                this.inv.setStackInSlot(slot, stack);
            }
            return ItemStack.field_190927_a;
        }
        if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)slotItem)) {
            return stack;
        }
        int toAdd = Math.min(stack.func_77976_d() - slotItem.func_190916_E(), this.inv.getMaxStackSize(slot));
        if (toAdd <= 0) {
            return stack;
        }
        if (toAdd > stack.func_190916_E()) {
            if (!simulate) {
                ItemStack copy = slotItem.func_77946_l();
                copy.func_190917_f(stack.func_190916_E());
                this.inv.setStackInSlot(slot, copy);
            }
            return ItemStack.field_190927_a;
        }
        ItemStack copy = stack.func_77946_l();
        if (simulate) {
            copy.func_190918_g(toAdd);
            return copy;
        }
        copy.func_190918_g(toAdd);
        ItemStack realCopy = slotItem.func_77946_l();
        realCopy.func_190917_f(toAdd);
        this.inv.setStackInSlot(slot, realCopy);
        return copy;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack split;
        if (!this.allowExtraction) {
            return ItemStack.field_190927_a;
        }
        if (amount <= 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = this.inv.getStackInSlot(slot);
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (simulate) {
            split = stack.func_77946_l();
            split.func_190920_e(Math.min(stack.func_190916_E(), amount));
        } else {
            split = stack.func_77979_a(amount);
        }
        return split;
    }

    public int getSlotLimit(int slot) {
        return this.inv.getMaxStackSize(slot);
    }
}

