/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.transport;

import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.transport.IItemTransporter;
import ic2.core.inventory.transport.transporter.BasicTransporter;
import ic2.core.inventory.transport.transporter.CapabilityTransporter;
import ic2.core.inventory.transport.transporter.HasInvTransporter;
import ic2.core.inventory.transport.transporter.SidedTransporter;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.ILockableContainer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;

public class TransporterManager {
    public static TransporterManager manager = new TransporterManager();

    public IItemTransporter getTransporter(Object obj, boolean auto) {
        ICapabilityProvider prov;
        if (obj instanceof ICapabilityProvider && this.hasItemHander(prov = (ICapabilityProvider)obj)) {
            return new CapabilityTransporter(prov);
        }
        if (obj instanceof ISidedInventory) {
            return new SidedTransporter(auto, (ISidedInventory)obj);
        }
        if (obj instanceof IInventory) {
            return new BasicTransporter(auto, this.checkForChest((IInventory)obj));
        }
        if (!(obj instanceof TileEntity) && obj instanceof IHasInventory) {
            return new HasInvTransporter((IHasInventory)obj);
        }
        return null;
    }

    private IInventory checkForChest(IInventory par1) {
        TileEntityChest chest;
        if (par1 instanceof TileEntityChest && (chest = this.getDoubleChest((TileEntityChest)par1)) != null) {
            return new InventoryLargeChest("", (ILockableContainer)((TileEntityChest)par1), (ILockableContainer)chest);
        }
        return par1;
    }

    private TileEntityChest getDoubleChest(TileEntityChest chest) {
        if (chest.field_145991_k != null) {
            return chest.field_145991_k;
        }
        if (chest.field_145990_j != null) {
            return chest.field_145990_j;
        }
        if (chest.field_145992_i != null) {
            return chest.field_145992_i;
        }
        if (chest.field_145988_l != null) {
            return chest.field_145988_l;
        }
        return null;
    }

    private boolean hasItemHander(ICapabilityProvider handler) {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (!handler.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) continue;
            return true;
        }
        return false;
    }
}

