/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.transport.transporter;

import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.filters.IFilter;
import ic2.core.inventory.transport.transporter.BaseTransporter;
import ic2.core.util.misc.StackUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public class HasInvTransporter
extends BaseTransporter {
    IHasInventory inv;

    public HasInvTransporter(IHasInventory other) {
        super(false);
        this.inv = other;
    }

    @Override
    public ItemStack removeItem(IFilter filter, EnumFacing dir, int amount, boolean doRemove) {
        ItemStack stack = ItemStack.field_190927_a;
        int slots = this.inv.getSlotCount();
        for (int i = 0; i < slots; ++i) {
            int toRemove;
            ItemStack invItem = this.inv.getStackInSlot(i);
            if (invItem.func_190926_b() || !filter.matches(invItem) || !stack.func_190926_b() && !this.canMerge(stack, invItem) || (toRemove = Math.min(invItem.func_190916_E(), amount - stack.func_190916_E())) <= 0) continue;
            if (doRemove) {
                if (stack.func_190926_b()) {
                    stack = invItem.func_77979_a(toRemove);
                } else {
                    stack.func_190917_f(invItem.func_77979_a(toRemove).func_190916_E());
                }
            } else if (stack.func_190926_b()) {
                stack = StackUtil.copyWithSize(invItem, toRemove);
            } else {
                stack.func_190917_f(toRemove);
            }
            if (stack.func_190916_E() >= amount) break;
        }
        return stack;
    }

    @Override
    public int injectItem(ItemStack stack, EnumFacing dir, boolean doAdd) {
        int added = 0;
        int slots = this.inv.getSlotCount();
        int maxItemSize = stack.func_77976_d();
        for (int i = 0; i < slots; ++i) {
            int room;
            if (!this.inv.canInsert(i, stack)) continue;
            int maxStack = this.inv.getMaxStackSize(i);
            ItemStack invItem = this.inv.getStackInSlot(i);
            if (invItem.func_190926_b()) {
                int toAdd = Math.min(stack.func_190916_E() - added, maxStack);
                if (doAdd) {
                    this.inv.setStackInSlot(i, StackUtil.copyWithSize(stack, toAdd));
                }
                added += toAdd;
            } else if (this.canMerge(stack, invItem) && (room = Math.min(Math.min(maxItemSize - invItem.func_190916_E(), maxStack), stack.func_190916_E() - added)) > 0) {
                if (doAdd) {
                    invItem.func_190917_f(room);
                    this.inv.setStackInSlot(i, invItem);
                }
                added += room;
            }
            if (added >= stack.func_190916_E()) break;
        }
        return added;
    }

    @Override
    public int getSizeInventory(EnumFacing side) {
        return this.inv.getSlotCount();
    }

    @Override
    public void markInventoryDirty() {
    }
}

