/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.transport.transporter;

import ic2.core.inventory.filters.IFilter;
import ic2.core.inventory.transport.IItemTransporter;
import ic2.core.util.misc.StackUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public class PriorityTransporter
implements IItemTransporter {
    IItemTransporter backup;
    IItemTransporter main;

    public PriorityTransporter(IItemTransporter prio, IItemTransporter back) {
        this.main = prio;
        this.backup = back;
    }

    @Override
    public ItemStack addItem(ItemStack stack, EnumFacing dir, boolean doAdd) {
        ItemStack added = this.main.addItem(stack, dir, doAdd);
        if (!added.func_190926_b()) {
            ItemStack extraAdded;
            if (added.func_190916_E() < stack.func_190916_E() && (extraAdded = this.backup.addItem(StackUtil.copyWithSize(stack, stack.func_190916_E() - added.func_190916_E()), dir, doAdd)).func_190926_b()) {
                added.func_190917_f(extraAdded.func_190916_E());
            }
            return added;
        }
        return this.backup.addItem(stack, dir, doAdd);
    }

    @Override
    public ItemStack removeItem(IFilter filter, EnumFacing dir, int amount, boolean doRemove) {
        ItemStack result = this.main.removeItem(filter, dir, amount, doRemove);
        if (result.func_190926_b()) {
            return this.backup.removeItem(filter, dir, amount, doRemove);
        }
        return result;
    }

    @Override
    public int getSizeInventory(EnumFacing side) {
        return this.main.getSizeInventory(side) + this.backup.getSizeInventory(side);
    }

    @Override
    public void onFinishedActions() {
        this.main.onFinishedActions();
        this.backup.onFinishedActions();
    }
}

