/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.block;

import ic2.api.energy.EnergyNet;
import ic2.core.item.block.ItemBlockRare;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.player.PlayerHandler;
import ic2.core.util.misc.StackUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockPersonal
extends ItemBlockRare {
    public ItemBlockPersonal(Block block) {
        super(block);
        this.func_77627_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        int meta = stack.func_77960_j();
        if (meta == 4) {
            FluidStack fluidStack;
            NBTTagCompound nbt;
            if (stack.func_77942_o() && (nbt = StackUtil.getNbtData(stack)).func_74764_b("Fluid") && (fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("Fluid"))) != null) {
                tooltip.add(Ic2GuiLang.fluidStored.getLocalizedFormatted(fluidStack == null ? Ic2GuiLang.fluidNone : fluidStack.getLocalizedName()));
                tooltip.add(Ic2GuiLang.fluidAmount.getLocalizedFormatted(fluidStack.amount, 128000));
            }
        } else if (meta == 5 && PlayerHandler.getClientPlayerHandler().hasEUReader()) {
            NBTTagCompound nbt = StackUtil.getNbtData(stack);
            tooltip.add(Ic2InfoLang.electricMaxIn.getLocalizedFormatted(EnergyNet.instance.getPowerFromTier(nbt.func_74762_e("Tier"))));
            tooltip.add(Ic2InfoLang.electricMaxStorage.getLocalizedFormatted(nbt.func_74762_e("MaxEnergy")));
        }
    }

    @Override
    public LocaleComp getLangComponent(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return Ic2BlockLang.tradeOMat;
            }
            case 1: {
                return Ic2BlockLang.fluidOMat;
            }
            case 2: {
                return Ic2BlockLang.energyOMat;
            }
            case 3: {
                return Ic2BlockLang.personalChest;
            }
            case 4: {
                return Ic2BlockLang.personalTank;
            }
            case 5: {
                return this.getTypeInfo(stack);
            }
            case 6: {
                return Ic2BlockLang.localMarket;
            }
            case 7: {
                return Ic2BlockLang.globalMarket;
            }
            case 8: {
                return Ic2BlockLang.iridiumStone;
            }
        }
        return super.getLangComponent(stack);
    }

    private LocaleComp getTypeInfo(ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        int tier = nbt.func_74762_e("Tier");
        int maxEnergy = nbt.func_74762_e("MaxEnergy");
        if (tier == 1 && maxEnergy == 30000) {
            return Ic2BlockLang.personalBatbox;
        }
        if (tier == 2 && maxEnergy == 600000) {
            return Ic2BlockLang.personalMFE;
        }
        if (tier == 3 && maxEnergy == 10000000) {
            return Ic2BlockLang.personalMFSU;
        }
        return Ic2BlockLang.personalEnergyStorage;
    }

    public static int getType(ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        int tier = nbt.func_74762_e("Tier");
        int maxEnergy = nbt.func_74762_e("MaxEnergy");
        if (tier == 1 && maxEnergy == 30000) {
            return 0;
        }
        if (tier == 2 && maxEnergy == 600000) {
            return 1;
        }
        if (tier == 3 && maxEnergy == 10000000) {
            return 2;
        }
        return 0;
    }

    public static ItemStack setMaxEnergy(ItemStack item, int maxEnergy, int tier) {
        ItemStack copy = item.func_77946_l();
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(copy);
        nbt.func_74768_a("MaxEnergy", maxEnergy);
        nbt.func_74768_a("Tier", tier);
        return copy;
    }

    public static int getMaxEnergy(ItemStack item) {
        return StackUtil.getNbtData(item).func_74762_e("MaxEnergy");
    }

    public static int getTier(ItemStack item) {
        return StackUtil.getNbtData(item).func_74762_e("Tier");
    }
}

