/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.manager;

import ic2.api.classic.event.EnergyUsedEvent;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricItemManager;
import ic2.core.IC2;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.plugins.IBaublesPlugin;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class DamagelessElectricItemManager
implements IElectricItemManager {
    @Override
    public double charge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        IElectricItem item = (IElectricItem)stack.func_77973_b();
        assert (item.getMaxCharge(stack) > 0.0);
        if (amount < 0.0 || stack.func_190916_E() > 1 || item.getTier(stack) > tier) {
            return 0.0;
        }
        if (!ignoreTransferLimit && amount > item.getTransferLimit(stack)) {
            amount = item.getTransferLimit(stack);
        }
        NBTTagCompound tNBT = StackUtil.getOrCreateNbtData(stack);
        int tNewCharge = tNBT.func_74762_e("charge");
        if (amount > item.getMaxCharge(stack) - (double)tNewCharge) {
            amount = item.getMaxCharge(stack) - (double)tNewCharge;
        }
        if (!simulate) {
            if ((tNewCharge = (int)((double)tNewCharge + amount)) > 0) {
                tNBT.func_74768_a("charge", tNewCharge);
            } else {
                tNBT.func_82580_o("charge");
                if (tNBT.func_82582_d()) {
                    stack.func_77982_d(null);
                }
            }
        }
        return amount;
    }

    @Override
    public double discharge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
        NBTTagCompound tNBT;
        int tNewCharge;
        IElectricItem item = (IElectricItem)stack.func_77973_b();
        assert (item.getMaxCharge(stack) > 0.0);
        if (!stack.func_77942_o()) {
            return 0.0;
        }
        if (amount < 0.0 || stack.func_190916_E() > 1 || item.getTier(stack) > tier) {
            return 0.0;
        }
        if (externally && !item.canProvideEnergy(stack)) {
            return 0.0;
        }
        if (!ignoreTransferLimit && amount > item.getTransferLimit(stack)) {
            amount = item.getTransferLimit(stack);
        }
        if (amount > (double)(tNewCharge = (tNBT = StackUtil.getNbtData(stack)).func_74762_e("charge"))) {
            amount = tNewCharge;
        }
        if (!simulate) {
            if ((tNewCharge = (int)((double)tNewCharge - amount)) > 0) {
                tNBT.func_74768_a("charge", tNewCharge);
            } else {
                tNBT.func_82580_o("charge");
                if (tNBT.func_82582_d()) {
                    stack.func_77982_d(null);
                }
            }
        }
        return amount;
    }

    @Override
    public double getCharge(ItemStack stack) {
        return this.discharge(stack, 2.147483647E9, Integer.MAX_VALUE, true, false, true);
    }

    @Override
    public double getMaxCharge(ItemStack stack) {
        return ((IElectricItem)stack.func_77973_b()).getMaxCharge(stack);
    }

    @Override
    public boolean canUse(ItemStack stack, double amount) {
        return this.getCharge(stack) >= this.applyEnchantmentEffect(stack, amount);
    }

    @Override
    public boolean use(ItemStack stack, double amount, EntityLivingBase entity) {
        if (!IC2.platform.isSimulating()) {
            return false;
        }
        amount = this.applyEnchantmentEffect(stack, amount);
        this.chargeFromArmor(stack, entity);
        double transfer = this.discharge(stack, amount, Integer.MAX_VALUE, true, false, true);
        if ((int)transfer == (int)amount) {
            this.discharge(stack, amount, Integer.MAX_VALUE, true, false, false);
            this.chargeFromArmor(stack, entity);
            if (entity instanceof EntityPlayer) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyUsedEvent((EntityPlayer)entity, stack, (int)amount));
            }
            return true;
        }
        return false;
    }

    @Override
    public void chargeFromArmor(ItemStack stack, EntityLivingBase entity) {
        IBaublesPlugin plugin;
        if (!IC2.platform.isSimulating() || entity == null) {
            return;
        }
        boolean inventoryChanged = false;
        if (entity instanceof EntityPlayer && (plugin = IC2.loader.getPlugin("baubles", IBaublesPlugin.class)) != null) {
            inventoryChanged = plugin.chargeFromArmor((EntityPlayer)entity, stack);
        }
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            IElectricItem armorItem;
            ItemStack armorItemStack;
            if (slot.func_188453_a() == EntityEquipmentSlot.Type.HAND || !((armorItemStack = entity.func_184582_a(slot)).func_77973_b() instanceof IElectricItem) || !(armorItem = (IElectricItem)armorItemStack.func_77973_b()).canProvideEnergy(armorItemStack) || armorItem.getTier(armorItemStack) < ((IElectricItem)stack.func_77973_b()).getTier(stack)) continue;
            double transfer = this.charge(stack, 2.147483647E9, Integer.MAX_VALUE, true, true);
            if (!((transfer = ElectricItem.manager.discharge(armorItemStack, transfer, Integer.MAX_VALUE, true, true, false)) > 0.0)) continue;
            this.charge(stack, transfer, Integer.MAX_VALUE, true, false);
            inventoryChanged = true;
        }
        if (inventoryChanged && entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).field_71070_bA.func_75142_b();
        }
    }

    @Override
    public String getToolTip(ItemStack stack) {
        return (int)this.getCharge(stack) + "/" + (int)this.getMaxCharge(stack) + " EU";
    }

    @Override
    public int getTier(ItemStack stack) {
        return ((IElectricItem)stack.func_77973_b()).getTier(stack);
    }

    public double applyEnchantmentEffect(ItemStack item, double amount) {
        double effect;
        int level = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)item);
        if (level > 0) {
            effect = 1.0 + 0.15 * (double)level;
            amount *= effect;
        }
        if ((level = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)item)) > 0) {
            effect = 1.0 - 0.1 * (double)level;
            amount *= effect;
        }
        return amount;
    }
}

