/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.manager;

import ic2.api.classic.event.EnergyUsedEvent;
import ic2.api.classic.item.IDamagelessElectricItem;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import ic2.core.item.manager.DamagelessElectricItemManager;
import ic2.core.item.manager.ElectricItemManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class GatewayElectricItemManager
implements IElectricItemManager {
    public static IElectricItemManager damagelessManager;

    @Override
    public double charge(ItemStack itemStack, double amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        IElectricItemManager manager = this.getManager(itemStack);
        if (manager == null) {
            return 0.0;
        }
        return manager.charge(itemStack, amount, tier, ignoreTransferLimit, simulate);
    }

    @Override
    public double discharge(ItemStack itemStack, double amount, int tier, boolean ignoreTransferLimit, boolean externalUse, boolean simulate) {
        IElectricItemManager manager = this.getManager(itemStack);
        if (manager == null) {
            return 0.0;
        }
        return manager.discharge(itemStack, amount, tier, ignoreTransferLimit, externalUse, simulate);
    }

    @Override
    public double getCharge(ItemStack itemStack) {
        IElectricItemManager manager = this.getManager(itemStack);
        if (manager == null) {
            return 0.0;
        }
        return manager.getCharge(itemStack);
    }

    @Override
    public boolean canUse(ItemStack itemStack, double amount) {
        IElectricItemManager manager = this.getManager(itemStack);
        if (manager == null) {
            return false;
        }
        return manager.canUse(itemStack, amount);
    }

    @Override
    public boolean use(ItemStack itemStack, double amount, EntityLivingBase entity) {
        IElectricItemManager manager = this.getManager(itemStack);
        if (manager == null) {
            return false;
        }
        boolean result = manager.use(itemStack, amount, entity);
        if (result && entity instanceof EntityPlayer && !(manager instanceof ElectricItemManager) && !(manager instanceof DamagelessElectricItemManager)) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyUsedEvent((EntityPlayer)entity, itemStack, (int)amount));
        }
        return result;
    }

    @Override
    public void chargeFromArmor(ItemStack itemStack, EntityLivingBase entity) {
        IElectricItemManager manager = this.getManager(itemStack);
        if (manager == null) {
            return;
        }
        manager.chargeFromArmor(itemStack, entity);
    }

    @Override
    public String getToolTip(ItemStack itemStack) {
        IElectricItemManager manager = this.getManager(itemStack);
        if (manager == null) {
            return null;
        }
        return manager.getToolTip(itemStack);
    }

    @Override
    public double getMaxCharge(ItemStack stack) {
        IElectricItemManager manager = this.getManager(stack);
        if (manager == null) {
            return 0.0;
        }
        return manager.getMaxCharge(stack);
    }

    @Override
    public int getTier(ItemStack stack) {
        IElectricItemManager manager = this.getManager(stack);
        if (manager == null) {
            return 0;
        }
        return manager.getTier(stack);
    }

    public IElectricItemManager getManager(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ISpecialElectricItem) {
            return ((ISpecialElectricItem)item).getManager(stack);
        }
        if (item instanceof IDamagelessElectricItem) {
            return damagelessManager;
        }
        if (item instanceof IElectricItem) {
            return ElectricItem.rawManager;
        }
        return ElectricItem.getBackupManager(stack);
    }

    public static void init() {
        ElectricItem.manager = new GatewayElectricItemManager();
        ElectricItem.rawManager = new ElectricItemManager();
        damagelessManager = new DamagelessElectricItemManager();
    }
}

