/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.reactor.uranTypes;

import ic2.core.item.reactor.uranTypes.IUranium;
import ic2.core.item.reactor.uranTypes.UranBaseType;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.util.misc.StackUtil;
import java.awt.Color;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class RedstoneUranium
extends UranBaseType {
    public RedstoneUranium() {
        this.loadDefaults();
    }

    @Override
    public int getMaxDurability() {
        return 8000;
    }

    @Override
    public float getEUPerPulse() {
        return 1.0f;
    }

    @Override
    public int getPulsesPerTick() {
        return 2;
    }

    @Override
    public int getPulsesForConnection() {
        return 1;
    }

    @Override
    public float getHeatModifier() {
        return 0.5f;
    }

    @Override
    public float getExplosionEffectModifier() {
        return 2.0f;
    }

    @Override
    public ItemStack getUraniumIngot() {
        return Ic2Items.redstoneUraniumIngot.func_77946_l();
    }

    @Override
    public ItemStack getRodType(IUranium.RodType type) {
        switch (type) {
            case SingleRod: {
                return Ic2Items.reactorRedstoneUraniumRodSingle.func_77946_l();
            }
            case DualRod: {
                return Ic2Items.reactorRedstoneUraniumRodDual.func_77946_l();
            }
            case QuadRod: {
                return Ic2Items.reactorRedstoneUraniumRodQuad.func_77946_l();
            }
            case NearDepletedRod: {
                return Ic2Items.reactorNearDepletedRedstoneUraniumRod.func_77946_l();
            }
            case IsotopicRod: {
                return Ic2Items.reactorRedstoneUraniumIsotopicRod.func_77946_l();
            }
            case ReEnrichedRod: {
                return Ic2Items.reactorReEnrichedRedstoneUraniumRod.func_77946_l();
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack getNewIsotopicRod() {
        return StackUtil.copyWithDamage(this.getRodType(IUranium.RodType.IsotopicRod), this.getMaxDurability() - 1);
    }

    @Override
    public short getRodID(IUranium.RodType type) {
        switch (type) {
            case SingleRod: {
                return 3;
            }
            case DualRod: {
                return 4;
            }
            case QuadRod: {
                return 5;
            }
            case IsotopicRod: {
                return 43;
            }
        }
        return 0;
    }

    @Override
    public LocaleComp getName(IUranium.RodType type) {
        switch (type) {
            case SingleRod: {
                return Ic2ItemLang.uranRodRedstoneSingle;
            }
            case DualRod: {
                return Ic2ItemLang.uranRodRedstoneDouble;
            }
            case QuadRod: {
                return Ic2ItemLang.uranRodRedstoneQuad;
            }
            case NearDepletedRod: {
                return Ic2ItemLang.uranRodRedstoneNearDeplete;
            }
            case IsotopicRod: {
                return Ic2ItemLang.uranRodRedstoneIsotopic;
            }
            case ReEnrichedRod: {
                return Ic2ItemLang.uranRodRedstoneReEnriched;
            }
        }
        return Ic2Lang.nullKey;
    }

    @Override
    public boolean isReEnrichedUran() {
        return true;
    }

    @Override
    public Color getReEnrichedColor() {
        return new Color(0xFF0000);
    }

    @Override
    public ItemStack getIngridient() {
        return new ItemStack(Items.field_151137_ax);
    }

    @Override
    public int getIngrientPoints() {
        return 25;
    }

    @Override
    public int getRow() {
        return 1;
    }

    @Override
    public int getIngridientCost() {
        return 25;
    }
}

