/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.recipe;

import com.google.common.base.Predicate;
import ic2.api.classic.item.IFluidScannerItem;
import ic2.api.classic.item.IMachineUpgradeItem;
import ic2.api.classic.item.IScannerItem;
import ic2.api.item.IBoxable;
import ic2.api.item.IElectricItem;
import ic2.api.item.IMetalArmor;
import ic2.api.item.ISpecialElectricItem;
import ic2.api.item.ItemWrapper;
import ic2.api.reactor.IBaseReactorComponent;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.helpers.ItemWithMeta;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraftforge.common.ISpecialArmor;

public class BoxableItems
implements IBoxable,
IMetalArmor {
    private Set<Predicate<Item>> validItems = new LinkedHashSet<Predicate<Item>>();
    private Set<Item> armorItem = new HashSet<Item>();
    private Set<Item> boxableItem = new HashSet<Item>();
    private Set<ItemWithMeta> boxableMetaItems = new HashSet<ItemWithMeta>();
    private Set<String> validationType = new LinkedHashSet<String>();
    private Set<Item> boxableTypes = new HashSet<Item>();
    public static BoxableItems instance = new BoxableItems();

    public static void init() {
        instance.initItems();
    }

    private void initItems() {
        this.registerBoxable(new StringPredicate());
        this.registerMetaItem(Ic2Items.miningPipe);
        this.registerMetaItem(Ic2Items.machineBuffer);
        this.registerMetaItem(Ic2Items.machineTank);
        this.registerMetaItem(Ic2Items.teleporter);
        this.registerMetaItem(Ic2Items.teleporterHub);
        this.registerItem(Ic2Items.treeTap);
        this.registerItem(Ic2Items.wrench);
        this.registerItem(Ic2Items.cutter);
        this.registerItem(Ic2Items.cfSprayer);
        this.registerItem(Ic2Items.euReader);
        this.registerItem(Ic2Items.machineTool);
        this.registerItem(Ic2Items.memoryStick);
        this.registerItem(Ic2Items.padUpgradeArmorPriorty);
        this.registerItem(Ic2Items.automationUpgrade);
        this.registerMetaItem(Ic2Items.painter);
        this.registerItem(Ic2Items.painters[0]);
        this.registerItem(Ic2Items.filledTinCan);
        this.registerItem(Ic2Items.frequencyTransmitter);
        this.registerItem(Ic2Items.jetpack);
        this.registerItem(Ic2Items.cfPack);
        this.registerItem(Ic2Items.solarHelmet);
        this.registerItem(Ic2Items.staticBoots);
        this.registerItem(Ic2Items.emptyCell);
        this.registerItem(Ic2Items.cropStick);
        this.registerMetaItem(Ic2Items.tfbp);
        this.registerMetaItem(Ic2Items.tfbpBiome);
        this.registerItem(Ic2Items.tfbpBiomeChilling);
        this.registerItem(Ic2Items.dynamite);
        this.registerItem(Ic2Items.stickyDynamite);
        this.registerItem(Ic2Items.dynamiteRemote);
        this.registerItem(Ic2Items.industrialCoin);
        this.registerItem(Ic2Items.hydrationCell);
        this.registerItem(Ic2Items.weedEx);
        this.registerMetaItem(Ic2Items.fertilizer);
        this.registerMetaItem(Ic2Items.constructionFoamPellet);
        this.registerItem(Items.field_151032_g);
        this.registerItem(Items.field_151104_aV);
        this.registerItem(Items.field_151133_ar);
        this.registerItem(Items.field_151033_d);
        this.registerBlock(Blocks.field_150478_aa);
        this.registerItem(Ic2Items.woodenScaffold);
        this.registerItem(Ic2Items.ironScaffold);
        this.registerItem(Items.field_185160_cR);
        this.registerTypes("tool", "wrench", "wand", "rod", "scepter", "screwdriver", "meter", "hammer", "magnifying", "pipette", "grafter", "grafter", "reader", "soldering", "meter", "handsaw", "gun", "key", "chisel");
        for (Item item : Item.field_150901_e) {
            ItemArmor armor;
            ItemArmor.ArmorMaterial mat;
            if (item instanceof IMachineUpgradeItem || item instanceof ItemFood || item instanceof ItemShield || item instanceof ItemPotion || item instanceof ItemTool || item instanceof ItemHoe || item instanceof ItemBow || item instanceof ItemSword || item instanceof ItemArmor || item instanceof ISpecialArmor || item instanceof IBaseReactorComponent || item instanceof IScannerItem || item instanceof IFluidScannerItem || item instanceof IElectricItem || item instanceof ISpecialElectricItem || item instanceof ItemBucket || item instanceof ItemFishingRod) {
                this.registerItem(item);
            }
            if (item instanceof ItemArmor && ((mat = (armor = (ItemArmor)item).func_82812_d()) == ItemArmor.ArmorMaterial.IRON || mat == ItemArmor.ArmorMaterial.GOLD || mat == ItemArmor.ArmorMaterial.CHAIN) && armor.field_77881_a == EntityEquipmentSlot.FEET) {
                this.addArmorItem(armor);
            }
            for (Predicate<Item> able : this.validItems) {
                able.apply((Object)item);
            }
        }
    }

    private void addToList(Item item) {
        ItemWrapper.registerBoxable(item, instance);
    }

    public void registerBlock(Block block) {
        Item item = Item.func_150898_a((Block)block);
        this.boxableItem.add(item);
        this.addToList(item);
    }

    public void registerItem(Item item) {
        this.boxableItem.add(item);
        this.addToList(item);
    }

    public void registerItem(ItemStack stack) {
        this.registerItem(stack.func_77973_b());
        this.addToList(stack.func_77973_b());
    }

    public void registerMetaItem(ItemStack stack) {
        this.boxableMetaItems.add(new ItemWithMeta(stack));
        this.addToList(stack.func_77973_b());
    }

    public void registerTypeItem(Item item) {
        this.boxableTypes.add(item);
        this.addToList(item);
    }

    public void registerBoxable(Predicate<Item> box) {
        this.validItems.add(box);
    }

    public void registerTypes(String ... preFixes) {
        for (String prefix : preFixes) {
            this.validationType.add(prefix.toLowerCase(Locale.ENGLISH));
        }
    }

    public void registerType(String preFix) {
        this.validationType.add(preFix.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public boolean canBeStoredInToolbox(ItemStack stack) {
        if (stack.func_190926_b() || stack.func_77973_b() == null) {
            return false;
        }
        if (this.boxableItem.contains(stack.func_77973_b())) {
            return true;
        }
        if (this.boxableMetaItems.contains(new ItemWithMeta(stack))) {
            return true;
        }
        if (this.boxableTypes.contains(stack.func_77973_b())) {
            String name = stack.func_77977_a().toLowerCase(Locale.ENGLISH);
            for (String id : this.validationType) {
                if (!name.contains(id)) continue;
                return true;
            }
        }
        return false;
    }

    public void addArmorItem(ItemArmor item) {
        this.armorItem.add((Item)item);
        ItemWrapper.registerMetalArmor((Item)item, instance);
    }

    @Override
    public boolean isMetalArmor(ItemStack stack, EntityPlayer player) {
        if (stack.func_190926_b() || stack.func_77973_b() == null) {
            return false;
        }
        return this.armorItem.contains(stack.func_77973_b());
    }

    public static class StringPredicate
    implements Predicate<Item> {
        public boolean apply(Item input) {
            String name = input.func_77658_a().toLowerCase(Locale.ENGLISH);
            for (String id : instance.validationType) {
                if (!name.contains(id)) continue;
                instance.registerTypeItem(input);
                return false;
            }
            return false;
        }
    }
}

