/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.api.classic.audio.PositionSpec;
import ic2.core.IC2;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.transport.IItemTransporter;
import ic2.core.inventory.transport.TransporterManager;
import ic2.core.item.base.ItemIC2;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.player.PlayerHandler;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.registry.Ic2Sounds;
import ic2.core.platform.textures.obj.ICustomItemCameraTransform;
import ic2.core.util.helpers.AabbUtil;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IBootable;
import ic2.core.util.obj.ToolTipType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemToolPainter
extends ItemIC2
implements IBootable,
ICustomItemCameraTransform {
    public static Map<Integer, List<ItemStack>> colorToItems = new HashMap<Integer, List<ItemStack>>();
    public static String[] colors = new String[16];

    public ItemToolPainter() {
        this.func_77656_e(32);
        this.func_77625_d(1);
        this.setUnlocalizedName(Ic2ItemLang.painterItem);
        this.setNoRepair();
        this.func_77627_a(true);
    }

    @Override
    public boolean hasCustomTransform(int meta) {
        return true;
    }

    @Override
    public ResourceLocation getCustomTransform(int meta) {
        return new ResourceLocation("minecraft:models/item/handheld");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        super.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
        tooltip.add(Items.field_151100_aR.func_77653_i(new ItemStack(Items.field_151100_aR, 1, stack.func_77960_j())));
        tooltip.add(Ic2InfoLang.painterRange.getLocalizedFormatted(StackUtil.getNbtData(stack).func_74762_e("Range")));
        List<String> ctrlTip = sortedTooltip.get((Object)ToolTipType.Ctrl);
        ctrlTip.add(Ic2Lang.onItemRightClick.getLocalized());
        ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(2), Ic2InfoLang.switchAutoRefillMode));
        ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(2) + " & " + IC2.keyboard.getKeyName(0), Ic2InfoLang.painterRangeEffect));
        ctrlTip.add("");
        ctrlTip.add(Ic2Lang.onBlockClick.getLocalized());
        ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(9), Ic2InfoLang.painterAllSides));
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (stack == null || stack.func_77973_b() != this) {
            return false;
        }
        if (target instanceof EntitySheep) {
            EntitySheep sheep = (EntitySheep)target;
            EnumDyeColor color = EnumDyeColor.func_176766_a((int)stack.func_77960_j());
            if (sheep.func_175509_cj() == color) {
                return false;
            }
            sheep.func_175512_b(color);
            ItemToolPainter.damagePainter(stack, player, hand);
            return true;
        }
        return super.func_111207_a(stack, player, target, hand);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (IC2.platform.isSimulating()) {
            PlayerHandler handler = PlayerHandler.getHandlerForPlayer(playerIn);
            if (handler.modeSwitchKeyDown) {
                NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
                if (handler.altKeyDown) {
                    byte range = (byte)(nbt.func_74771_c("Range") + 1);
                    if (range > 2) {
                        range = 0;
                    }
                    nbt.func_74774_a("Range", range);
                    IC2.platform.messagePlayer(playerIn, Ic2InfoLang.painterRange, range);
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                }
                boolean newValue = !nbt.func_74767_n("autoRefill");
                nbt.func_74757_a("autoRefill", newValue);
                IC2.platform.messagePlayer(playerIn, newValue ? Ic2InfoLang.painterAutoRefillOn : Ic2InfoLang.painterAutoRefillOff);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        int meta;
        ItemStack stack = player.func_184586_b(hand);
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.func_177230_c() == Blocks.field_150383_bp && (meta = state.func_177230_c().func_176201_c(state)) > 0) {
            player.func_184611_a(hand, Ic2Items.painter.func_77946_l());
            worldIn.func_175656_a(pos, state.func_177230_c().func_176203_a(meta - 1));
            return EnumActionResult.SUCCESS;
        }
        boolean server = IC2.platform.isSimulating();
        EnumDyeColor color = EnumDyeColor.func_176766_a((int)this.getMetadata(stack));
        AabbUtil.BoundingBox box = new AabbUtil.BoundingBox(pos).expandSide(facing, StackUtil.getNbtData(stack).func_74771_c("Range"));
        boolean didSomething = false;
        for (BlockPos iter : box) {
            if (worldIn.func_175623_d(iter) || !(player.func_70093_af() ? this.colorBlock(state, worldIn, iter, null, color) || this.colorBlock(state, worldIn, iter, facing, color) : this.colorBlock(state, worldIn, iter, facing, color))) continue;
            didSomething = true;
            if (!server || ItemToolPainter.damagePainter(stack, player, hand)) continue;
            break;
        }
        if (didSomething) {
            if (!server) {
                IC2.audioManager.playOnce(player, PositionSpec.Hand, Ic2Sounds.painterUse, true, 4.0f);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public boolean colorBlock(IBlockState state, World world, BlockPos pos, EnumFacing side, EnumDyeColor color) {
        try {
            return state.func_177230_c().recolorBlock(world, pos, side, color);
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean damagePainter(ItemStack stack, EntityPlayer player, EnumHand hand) {
        if (stack.func_77952_i() + 1 < stack.func_77958_k()) {
            stack.func_77972_a(1, (EntityLivingBase)player);
            return true;
        }
        if (!StackUtil.getNbtData(stack).func_74767_n("autoRefill")) {
            player.func_184611_a(hand, Ic2Items.painter.func_77946_l());
            return false;
        }
        IItemTransporter transporter = TransporterManager.manager.getTransporter(player, true);
        ItemStack item = transporter.removeItem(CommonFilters.DyeFilters[stack.func_77960_j()], null, 1, true);
        if (!item.func_190926_b()) {
            stack.func_77964_b(0);
            return true;
        }
        player.func_184611_a(hand, Ic2Items.painter.func_77946_l());
        return false;
    }

    public int getDamage(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74762_e("customDamage");
    }

    public void setDamage(ItemStack stack, int damage) {
        StackUtil.getOrCreateNbtData(stack).func_74768_a("customDamage", damage);
    }

    @Override
    public LocaleComp getLangComponent(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return Ic2ItemLang.painterBlack;
            }
            case 1: {
                return Ic2ItemLang.painterRed;
            }
            case 2: {
                return Ic2ItemLang.painterGreen;
            }
            case 3: {
                return Ic2ItemLang.painterBrown;
            }
            case 4: {
                return Ic2ItemLang.painterBlue;
            }
            case 5: {
                return Ic2ItemLang.painterPurple;
            }
            case 6: {
                return Ic2ItemLang.painterCyan;
            }
            case 7: {
                return Ic2ItemLang.painterLightGrey;
            }
            case 8: {
                return Ic2ItemLang.painterDarkGrey;
            }
            case 9: {
                return Ic2ItemLang.painterPink;
            }
            case 10: {
                return Ic2ItemLang.painterLime;
            }
            case 11: {
                return Ic2ItemLang.painterYellow;
            }
            case 12: {
                return Ic2ItemLang.painterCloud;
            }
            case 13: {
                return Ic2ItemLang.painterMagenta;
            }
            case 14: {
                return Ic2ItemLang.painterOrange;
            }
            case 15: {
                return Ic2ItemLang.painterWhite;
            }
        }
        return super.getLangComponent(stack);
    }

    @Override
    public void onLoad() {
        Ic2Items.blackPainter = new ItemStack((Item)this, 1, 0);
        Ic2Items.redPainter = new ItemStack((Item)this, 1, 1);
        Ic2Items.greenPainter = new ItemStack((Item)this, 1, 2);
        Ic2Items.brownPainter = new ItemStack((Item)this, 1, 3);
        Ic2Items.bluePainter = new ItemStack((Item)this, 1, 4);
        Ic2Items.purplePainter = new ItemStack((Item)this, 1, 5);
        Ic2Items.cyanPainter = new ItemStack((Item)this, 1, 6);
        Ic2Items.lightGreyPainter = new ItemStack((Item)this, 1, 7);
        Ic2Items.darkGreyPainter = new ItemStack((Item)this, 1, 8);
        Ic2Items.pinkPainter = new ItemStack((Item)this, 1, 9);
        Ic2Items.limePainter = new ItemStack((Item)this, 1, 10);
        Ic2Items.yellowPainter = new ItemStack((Item)this, 1, 11);
        Ic2Items.cloudPainter = new ItemStack((Item)this, 1, 12);
        Ic2Items.magentaPainter = new ItemStack((Item)this, 1, 13);
        Ic2Items.orangePainter = new ItemStack((Item)this, 1, 14);
        Ic2Items.whitePainter = new ItemStack((Item)this, 1, 15);
        Ic2Items.painters = new ItemStack[16];
        String[] dyes = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
        for (int i = 0; i < 16; ++i) {
            Ic2Items.painters[i] = new ItemStack((Item)this, 1, i);
            ItemToolPainter.colors[i] = "dye" + dyes[i];
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (int i = 0; i < 16; ++i) {
            items.add((Object)new ItemStack((Item)this, 1, i));
        }
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15);
    }

    @Override
    public int getTextureEntry(int meta) {
        return 64 + meta;
    }

    public boolean isDamaged(ItemStack stack) {
        return this.getDamage(stack) > 0;
    }
}

