/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool.electric;

import com.google.common.collect.ImmutableSet;
import ic2.api.classic.item.IMiningDrill;
import ic2.api.classic.item.IScannerItem;
import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.item.base.ItemElectricTool;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.obj.IStaticTexturedItem;
import ic2.core.util.helpers.AabbUtil;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IBootable;
import ic2.core.util.obj.ToolTipType;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemElectricToolDrill
extends ItemElectricTool
implements IStaticTexturedItem,
IBootable,
IMiningDrill {
    public static Set<IBlockState> rocks = new HashSet<IBlockState>();
    public static final DecimalFormat DECIMALFORMAT = new DecimalFormat("#.####");

    public ItemElectricToolDrill() {
        super(0.0f, -3.0f, Item.ToolMaterial.IRON);
        this.func_77627_a(true);
        this.setUnlocalizedName(Ic2ItemLang.drillItem);
        this.field_77865_bY = 1.0f;
        this.maxCharge = 10000;
        this.transferLimit = 100;
        this.tier = 1;
    }

    @Override
    public void onLoad() {
        Ic2Items.electricDrill = new ItemStack((Item)this, 1, 0);
        Ic2Items.diamondDrill = new ItemStack((Item)this, 1, 1);
        int[] array = new int[]{0, 1, 3, 5};
        for (int i = 0; i < array.length; ++i) {
            rocks.add(Blocks.field_150348_b.func_176203_a(array[i]));
        }
        rocks.add(Blocks.field_150343_Z.func_176223_P());
    }

    @Override
    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        if (stack.func_77960_j() == 1) {
            NBTTagCompound nbt = StackUtil.getNbtData(stack);
            tooltip.add((nbt.func_74767_n("dirtMode") ? Ic2InfoLang.enableDrillMode : Ic2InfoLang.disableDrillMode).getLocalized());
            if (nbt.func_74767_n("Rockcutter")) {
                tooltip.add(Ic2InfoLang.drillRockCutter.getLocalized());
            }
            List<String> ctrlTip = sortedTooltip.get((Object)ToolTipType.Ctrl);
            ctrlTip.add(Ic2Lang.onItemRightClick.getLocalized());
            ctrlTip.add(Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(2), Ic2InfoLang.drillModeSwitch.getLocalized()));
            ctrlTip.add("");
            ctrlTip.add(Ic2Lang.onBlockClick.getLocalized());
            ctrlTip.add(Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(0), Ic2InfoLang.drillProbing.getLocalized()));
        }
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return Ic2Items.bronzePickaxe.func_150998_b(state) || Ic2Items.bronzeShovel.func_150998_b(state);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, EntityPlayer player, IBlockState blockState) {
        if (!toolClass.equals("pickaxe") && !toolClass.equals("shovel")) {
            return -1;
        }
        int metadata = stack.func_77960_j();
        return metadata == 0 ? 2 : 3;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)"pickaxe", (Object)"shovel");
    }

    @Override
    public int getEnergyCost(ItemStack stack) {
        if (stack.func_77960_j() == 0) {
            return 50;
        }
        return StackUtil.getNbtData(stack).func_74767_n("Rockcutter") ? 20 : 80;
    }

    @Override
    public float getMiningSpeed(ItemStack stack) {
        return stack.func_77960_j() == 0 ? 8.0f : 16.0f;
    }

    @Override
    public float func_150893_a(ItemStack stack, IBlockState state) {
        float result = super.func_150893_a(stack, state);
        if (stack.func_77960_j() == 1) {
            NBTTagCompound nbt = StackUtil.getNbtData(stack);
            if (nbt.func_74767_n("dirtMode") && state.func_185904_a() == Material.field_151578_c) {
                result /= 8.0f;
            }
            if (nbt.func_74767_n("Rockcutter")) {
                if (rocks.contains(state) && ElectricItem.manager.canUse(stack, this.getEnergyCost(stack))) {
                    return 60.0f;
                }
                return 1.0f;
            }
        }
        return result;
    }

    @Override
    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            IC2.achievements.issueStat((EntityPlayer)entityLiving, "blocksDrilled");
        }
        return super.func_179218_a(stack, worldIn, blockIn, pos, entityLiving);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (stack.func_77960_j() == 1) {
            if (IC2.keyboard.isModeSwitchKeyDown(playerIn)) {
                if (IC2.platform.isRendering()) {
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
                }
                NBTTagCompound nbt = StackUtil.getOrCreateNbtData(stack);
                boolean result = !nbt.func_74767_n("dirtMode");
                nbt.func_74757_a("dirtMode", result);
                IC2.platform.messagePlayer(playerIn, result ? Ic2InfoLang.enableDrillMode : Ic2InfoLang.disableDrillMode);
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
            }
            if (IC2.keyboard.isAltKeyDown(playerIn) && !this.getScanner(playerIn.field_71071_by).func_190926_b()) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (IC2.keyboard.isAltKeyDown(player)) {
            ItemStack scanner = this.getScanner(player.field_71071_by);
            if (IC2.platform.isRendering()) {
                return scanner != null ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
            }
            if (scanner != null) {
                IScannerItem item = (IScannerItem)scanner.func_77973_b();
                int range = item.startLayerScan(scanner);
                ElectricItem.manager.chargeFromArmor(scanner, (EntityLivingBase)player);
                if (range > 0) {
                    EnumFacing.Axis axis = facing.func_176740_k();
                    AabbUtil.BoundingBox box = new AabbUtil.BoundingBox(pos);
                    for (EnumFacing.Axis iter : EnumFacing.Axis.values()) {
                        if (axis == iter) continue;
                        box.expandAxis(iter, 1);
                    }
                    box.expand(facing.func_176734_d(), 3 + range);
                    double found = 0.0;
                    double value = 0.0;
                    for (BlockPos check : box) {
                        value += (double)item.getOreValue(scanner, worldIn.func_180495_p(check));
                        found += 1.0;
                    }
                    value = value / found * 1000.0;
                    int result = (int)value;
                    IC2.platform.messagePlayer(player, Ic2InfoLang.drillProbeResult.getLocalizedFormatted(3 + range, result == 0 && value > 0.0 ? ItemStack.field_111284_a.format(value) : Integer.valueOf(result)));
                    return EnumActionResult.SUCCESS;
                }
            }
        }
        return EnumActionResult.PASS;
    }

    public ItemStack getScanner(InventoryPlayer player) {
        ItemStack stack;
        ItemStack result = ItemStack.field_190927_a;
        for (int i = 0; i < 9; ++i) {
            ItemStack stack2 = player.func_70301_a(i);
            if (stack2 == null || !(stack2.func_77973_b() instanceof IScannerItem)) continue;
            result = stack2;
            break;
        }
        if (result.func_190926_b() && (stack = player.field_70458_d.func_184592_cb()) != null && stack.func_77973_b() instanceof IScannerItem) {
            result = stack;
        }
        return result;
    }

    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (int i = 0; i < 2; ++i) {
            ItemStack empty = new ItemStack((Item)this, 1, i);
            ItemStack full = new ItemStack((Item)this, 1, i);
            ElectricItem.manager.discharge(empty, 2.147483647E9, Integer.MAX_VALUE, true, false, false);
            ElectricItem.manager.charge(full, 2.147483647E9, Integer.MAX_VALUE, true, false);
            items.add((Object)empty);
            items.add((Object)full);
        }
    }

    @Override
    public LocaleComp getLangComponent(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return Ic2ItemLang.drillElectric;
            }
            case 1: {
                if (StackUtil.getNbtData(stack).func_74767_n("Rockcutter")) {
                    return Ic2ItemLang.drillJack;
                }
                return Ic2ItemLang.drillDiamond;
            }
        }
        return super.getLangComponent(stack);
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0, 1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int meta) {
        return Ic2Icons.getTextures("i1")[32 + meta];
    }

    @Override
    public boolean isBasicDrill(ItemStack drill) {
        return drill.func_77960_j() == 0 && !drill.func_77956_u();
    }

    @Override
    public int getExtraSpeed(ItemStack drill) {
        int pointBoost = this.getPointBoost(drill);
        if (drill.func_77960_j() == 1) {
            return 3 + pointBoost;
        }
        return 0 + pointBoost;
    }

    private int getPointBoost(ItemStack drill) {
        int lvl = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)drill);
        if (lvl <= 0) {
            return 0;
        }
        return lvl * lvl + 1;
    }

    @Override
    public int getExtraEnergyCost(ItemStack drill) {
        int points = this.getEnergyChange(drill);
        if (drill.func_77960_j() == 1) {
            if ((points += 14) < 0) {
                return 0;
            }
            return points;
        }
        if (points > 0) {
            return points;
        }
        return 0;
    }

    public int getEnergyChange(ItemStack drill) {
        int eff = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)drill);
        int unb = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)drill);
        int points = eff * eff + 1;
        return points -= unb * (unb + unb);
    }

    @Override
    public void useDrill(ItemStack drill) {
        ElectricItem.manager.use(drill, this.getEnergyCost(drill), null);
    }

    @Override
    public boolean canMine(ItemStack drill) {
        return ElectricItem.manager.canUse(drill, this.getEnergyCost(drill));
    }

    @Override
    public EnumEnchantmentType getType(ItemStack item) {
        return EnumEnchantmentType.DIGGER;
    }

    @Override
    public boolean canMineBlock(ItemStack drill, IBlockState state, IBlockAccess access, BlockPos pos) {
        return ForgeHooks.canToolHarvestBlock((IBlockAccess)access, (BlockPos)pos, (ItemStack)drill);
    }
}

