/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool.electric;

import com.google.common.collect.Multimap;
import ic2.api.classic.crops.IDropController;
import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.item.base.ItemElectricTool;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.obj.IStaticTexturedItem;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemElectricToolHoe
extends ItemElectricTool
implements IStaticTexturedItem,
IDropController {
    public ItemElectricToolHoe() {
        super(0.0f, -3.0f, Item.ToolMaterial.IRON);
        this.setUnlocalizedName(Ic2ItemLang.hoeElectric);
        this.maxCharge = 10000;
        this.transferLimit = 100;
        this.tier = 1;
        this.field_77864_a = 16.0f;
        this.operationEnergyCost = 50;
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return Ic2Items.bronzeHoe.func_150998_b(state);
    }

    @Override
    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        return true;
    }

    @Override
    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos, EntityLivingBase entityLiving) {
        if ((double)blockIn.func_185887_b(worldIn, pos) != 0.0) {
            if (entityLiving instanceof EntityPlayer) {
                ElectricItem.manager.use(stack, this.operationEnergyCost, entityLiving);
            } else {
                ElectricItem.manager.discharge(stack, this.operationEnergyCost, this.tier, true, false, false);
            }
        }
        return true;
    }

    public boolean func_150897_b(IBlockState blockIn) {
        Material mat = blockIn.func_185904_a();
        return mat == Material.field_151577_b || mat == Material.field_151572_C;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 0.0, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)Item.ToolMaterial.IRON.func_78000_c() - 4.0, 0));
        }
        return multimap;
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int meta) {
        return Ic2Icons.getTextures("i1")[37];
    }

    @Override
    public EnumEnchantmentType getType(ItemStack item) {
        return EnumEnchantmentType.BREAKABLE;
    }

    @Override
    public boolean isSpecialSupported(ItemStack item, Enchantment ench) {
        if (ench == Enchantments.field_185308_t) {
            return true;
        }
        return super.isSpecialSupported(item, ench);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, stack)) {
            return EnumActionResult.FAIL;
        }
        UseHoeEvent event = new UseHoeEvent(player, stack, worldIn, pos);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return EnumActionResult.PASS;
        }
        if (event.getResult() == Event.Result.DENY) {
            return EnumActionResult.PASS;
        }
        if (!ElectricItem.manager.canUse(stack, this.operationEnergyCost)) {
            return EnumActionResult.PASS;
        }
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (facing != EnumFacing.DOWN && worldIn.func_175623_d(pos.func_177984_a())) {
            boolean didHoeBlock = false;
            if (block == Blocks.field_150349_c || block == Blocks.field_185774_da) {
                if (IC2.platform.isSimulating()) {
                    worldIn.func_175656_a(pos, Blocks.field_150458_ak.func_176223_P());
                }
                worldIn.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
                didHoeBlock = true;
            }
            if (block == Blocks.field_150346_d) {
                switch ((BlockDirt.DirtType)iblockstate.func_177229_b((IProperty)BlockDirt.field_176386_a)) {
                    case DIRT: {
                        if (IC2.platform.isSimulating()) {
                            worldIn.func_175656_a(pos, Blocks.field_150458_ak.func_176223_P());
                        }
                        worldIn.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        didHoeBlock = true;
                        break;
                    }
                    case COARSE_DIRT: {
                        if (IC2.platform.isSimulating()) {
                            worldIn.func_175656_a(pos, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT));
                        }
                        worldIn.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        didHoeBlock = true;
                        break;
                    }
                }
            }
            if (didHoeBlock) {
                if (IC2.platform.isSimulating()) {
                    ElectricItem.manager.use(stack, this.operationEnergyCost, (EntityLivingBase)player);
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    @Override
    public boolean isChangingCropDrops(ItemStack stack) {
        return true;
    }
}

