/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool.electric;

import ic2.api.classic.item.IDamagelessElectricItem;
import ic2.api.classic.item.IElectricTool;
import ic2.api.item.ElectricItem;
import ic2.core.item.tool.ItemToolWrench;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.util.misc.StackUtil;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemElectricToolPrecisionWrench
extends ItemToolWrench
implements IDamagelessElectricItem,
IElectricTool {
    public ItemElectricToolPrecisionWrench() {
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.setUnlocalizedName(Ic2ItemLang.wrenchPresision);
        this.setNoRepair();
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        if (nbt.func_74767_n("Lossless")) {
            tooltip.add(Ic2InfoLang.losslessWrenchInfiniteUses.getLocalized());
            return;
        }
        tooltip.add(Ic2InfoLang.losslessWrenchUses.getLocalizedFormatted(30 - nbt.func_74762_e("LossUses")));
    }

    @Override
    public boolean canOverrideLossChance(ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        return nbt.func_74767_n("Lossless") || nbt.func_74762_e("LossUses") < 30;
    }

    @Override
    public void onLossPrevented(EntityPlayer player, ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        if (nbt.func_74767_n("Lossless")) {
            return;
        }
        nbt.func_74768_a("LossUses", nbt.func_74762_e("LossUses") + 1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int meta) {
        return Ic2Icons.getTextures("i1")[44];
    }

    @Override
    public EnumEnchantmentType getType(ItemStack item) {
        return EnumEnchantmentType.BREAKABLE;
    }

    @Override
    public boolean isSpecialSupported(ItemStack item, Enchantment ench) {
        return ench == Enchantments.field_185308_t;
    }

    @Override
    public boolean isExcluded(ItemStack item, Enchantment ench) {
        return ench == Enchantments.field_185296_A;
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxCharge(ItemStack stack) {
        return 40000.0;
    }

    @Override
    public int getTier(ItemStack stack) {
        return 2;
    }

    @Override
    public double getTransferLimit(ItemStack stack) {
        return 350.0;
    }

    @Override
    public double getModifier(ItemStack stack) {
        return 2.0;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ItemStack empty = new ItemStack((Item)this, 1, 0);
        ItemStack full = new ItemStack((Item)this, 1, 0);
        ElectricItem.manager.discharge(empty, 2.147483647E9, Integer.MAX_VALUE, true, false, false);
        ElectricItem.manager.charge(full, 2.147483647E9, Integer.MAX_VALUE, true, false);
        items.add((Object)empty);
        items.add((Object)full);
    }

    @Override
    public boolean canTakeDamage(ItemStack stack, int damage) {
        return ElectricItem.manager.canUse(stack, damage * 100);
    }

    @Override
    public void damageItem(ItemStack stack, int damage, EntityPlayer player) {
        ElectricItem.manager.use(stack, damage * 100, (EntityLivingBase)player);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }
}

