/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.upgrades.subtypes.machine;

import com.google.common.base.Strings;
import ic2.api.classic.item.IMachineUpgradeItem;
import ic2.api.classic.tile.IMachine;
import ic2.core.Direction;
import ic2.core.IC2;
import ic2.core.inventory.base.IHandHeldInventory;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.filters.SpecialItemFilter;
import ic2.core.inventory.transport.IItemTransporter;
import ic2.core.inventory.transport.TransporterManager;
import ic2.core.inventory.transport.wrapper.ChachedInventory;
import ic2.core.item.inv.container.ContainerCraftingUpgrade;
import ic2.core.item.inv.inventories.InventoryCraftingUpgrade;
import ic2.core.item.upgrades.subtypes.machine.BaseMetaUpgrade;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IOutputMachine;
import ic2.core.util.obj.ToolTipType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CraftingUpgrade
extends BaseMetaUpgrade {
    public static final Container nullContainer = new Container(){

        public boolean func_75145_c(EntityPlayer playerIn) {
            return true;
        }
    };

    @Override
    public void addInfo(ItemStack par1, EntityPlayer par2, List<String> par3, Map<ToolTipType, List<String>> toolTips) {
        String output;
        LocaleComp cause;
        par3.add(Ic2InfoLang.craftingDelay.getLocalizedFormatted(this.getCraftingTime(par1)));
        int size = this.getToDoList(par1).size();
        if (size > 0) {
            par3.add(Ic2InfoLang.craftingStuffed.getLocalizedFormatted(size));
        }
        if ((cause = this.getCause(this.getPotentialCause(par1))) != null) {
            par3.add(cause.getLocalized());
        }
        if (!Strings.isNullOrEmpty((String)(output = this.getOutput(par1)))) {
            par3.add(Ic2InfoLang.craftingOutput.getLocalizedFormatted(output));
        }
    }

    public LocaleComp getCause(int type) {
        switch (type) {
            case 0: {
                return Ic2InfoLang.craftingCause0;
            }
            case 1: {
                return Ic2InfoLang.craftingCause1;
            }
            case 2: {
                return Ic2InfoLang.craftingCause2;
            }
            case 3: {
                return Ic2InfoLang.craftingCause3;
            }
            case 4: {
                return Ic2InfoLang.craftingCause4;
            }
        }
        return null;
    }

    @Override
    public boolean hasInventory(ItemStack stack) {
        return true;
    }

    @Override
    public void onInstalling(ItemStack upgrade, IMachine machine) {
        if (!this.isValid(upgrade)) {
            this.setCraftingTime(upgrade, -1, 0);
            return;
        }
        if (!(machine instanceof IOutputMachine)) {
            this.setCraftingTime(upgrade, -1, 1);
            return;
        }
        Direction dir = this.getDirection(upgrade);
        if (dir == null) {
            this.setCraftingTime(upgrade, -1, 2);
            return;
        }
        IHasInventory outputInventory = ((IOutputMachine)machine).getOutputInventory();
        if (outputInventory == null) {
            this.setCraftingTime(upgrade, -1, 3);
            return;
        }
        Map<ItemStack, List<Integer>> map = this.getItems(upgrade);
        if (map.isEmpty() || map.size() > outputInventory.getSlotCount()) {
            this.setCraftingTime(upgrade, -1, 4);
            return;
        }
        this.setCraftingTime(upgrade, 20, -1);
    }

    @Override
    public void onTick(ItemStack upgrade, IMachine machine) {
        int time = this.getCraftingTime(upgrade);
        if (time > 0) {
            long worldTime;
            long lastTime = this.getLastCrafting(upgrade);
            if (lastTime + (long)time >= (worldTime = this.getWorldTime(machine))) {
                return;
            }
            this.setLastCraft(upgrade, worldTime);
            Direction dir = this.getDirection(upgrade);
            List<ItemStack> cached = this.getToDoList(upgrade);
            if (cached.size() > 0) {
                TileEntity tile = dir.applyTo(machine.getMachineWorld(), machine.getMachinePos());
                if (tile == null) {
                    this.increaseDelay(upgrade);
                    return;
                }
                IItemTransporter transporter = TransporterManager.manager.getTransporter(tile, true);
                if (transporter == null) {
                    this.increaseDelay(upgrade);
                    return;
                }
                boolean didAdd = false;
                ArrayList<ItemStack> leaving = new ArrayList<ItemStack>();
                for (ItemStack stack : cached) {
                    ItemStack added = transporter.addItem(stack, dir.getInverse().toFacing(), true);
                    if (added.func_190926_b()) continue;
                    didAdd = didAdd || added.func_190916_E() > 0;
                    stack.func_190918_g(added.func_190916_E());
                    if (stack.func_190916_E() <= 0) continue;
                    leaving.add(stack);
                }
                if (leaving.size() > 0) {
                    this.setToRemove(upgrade, leaving);
                    this.increaseDelay(upgrade);
                } else {
                    this.decreaseDelay(upgrade);
                    StackUtil.getNbtData(upgrade).func_82580_o("ToRemove");
                }
                return;
            }
            IHasInventory outputInventory = ((IOutputMachine)machine).getOutputInventory();
            if (outputInventory == null) {
                this.setCraftingTime(upgrade, -1, 3);
                return;
            }
            Map<ItemStack, List<Integer>> map = this.getItems(upgrade);
            if (map.isEmpty() || map.size() > outputInventory.getSlotCount()) {
                this.setCraftingTime(upgrade, -1, 4);
                return;
            }
            TileEntity tile = dir.applyTo(machine.getMachineWorld(), machine.getMachinePos());
            if (tile == null) {
                this.increaseDelay(upgrade);
                return;
            }
            IItemTransporter transporter = TransporterManager.manager.getTransporter(tile, true);
            if (transporter == null) {
                this.increaseDelay(upgrade);
                return;
            }
            boolean oreDict = this.isOreDicted(upgrade);
            ChachedInventory inv = new ChachedInventory(outputInventory);
            IItemTransporter inTransport = TransporterManager.manager.getTransporter(inv, true);
            InventoryCrafting crafting = new InventoryCrafting(nullContainer, 3, 3);
            for (Map.Entry<ItemStack, List<Integer>> entry : map.entrySet()) {
                for (int slot : entry.getValue()) {
                    ItemStack stack = inTransport.removeItem(new SpecialItemFilter(entry.getKey(), true, true, oreDict), null, entry.getKey().func_190916_E(), true);
                    if (stack.func_190926_b() || stack.func_190916_E() < entry.getKey().func_190916_E()) {
                        this.increaseDelay(upgrade);
                        return;
                    }
                    crafting.func_70299_a(slot, stack.func_77946_l());
                }
            }
            ForgeHooks.setCraftingPlayer((EntityPlayer)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)machine.getMachineWorld())));
            ItemStack result = CraftingManager.func_82787_a((InventoryCrafting)crafting, (World)machine.getMachineWorld());
            if (result == null) {
                ForgeHooks.setCraftingPlayer(null);
                this.increaseDelay(upgrade);
                return;
            }
            result = result.func_77946_l();
            NonNullList remainings = CraftingManager.func_180303_b((InventoryCrafting)crafting, (World)machine.getMachineWorld());
            ForgeHooks.setCraftingPlayer(null);
            ArrayList<ItemStack> toRemove = new ArrayList<ItemStack>();
            ItemStack added = transporter.addItem(result, dir.getInverse().toFacing(), true);
            if (!added.func_190926_b()) {
                result.func_190918_g(added.func_190916_E());
                if (result.func_190916_E() > 0) {
                    toRemove.add(result);
                }
            } else {
                this.increaseDelay(upgrade);
                return;
            }
            if (remainings.size() > 0) {
                for (int i = 0; i < remainings.size(); ++i) {
                    ItemStack stack = (ItemStack)remainings.get(i);
                    if (stack.func_190926_b()) continue;
                    added = transporter.addItem(stack, dir.getInverse().toFacing(), true);
                    if (added.func_190916_E() > 0) {
                        stack.func_190918_g(added.func_190916_E());
                        if (stack.func_190916_E() <= 0) continue;
                        toRemove.add(stack);
                        continue;
                    }
                    this.increaseDelay(upgrade);
                }
            }
            if (toRemove.isEmpty()) {
                this.decreaseDelay(upgrade);
            } else {
                this.setToRemove(upgrade, toRemove);
            }
            inv.applyChanges();
        }
    }

    public Map<ItemStack, List<Integer>> getItems(ItemStack upgrade) {
        if (upgrade == null) {
            return new LinkedHashMap<ItemStack, List<Integer>>();
        }
        LinkedHashMap<ItemStack, List<Integer>> map = new LinkedHashMap<ItemStack, List<Integer>>();
        NBTTagList list = StackUtil.getNbtData(upgrade).func_150295_c("RecipeItems", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            ItemStack stack = new ItemStack(data);
            if (stack.func_190926_b()) continue;
            ArrayList<Integer> slotList = new ArrayList<Integer>();
            NBTTagList slotData = data.func_150295_c("Slots", 3);
            for (int x = 0; x < slotData.func_74745_c(); ++x) {
                slotList.add(slotData.func_186858_c(x));
            }
            map.put(stack, slotList);
        }
        return map;
    }

    public List<ItemStack> getToDoList(ItemStack upgrade) {
        NBTTagCompound nbt = StackUtil.getNbtData(upgrade);
        ArrayList<ItemStack> data = new ArrayList<ItemStack>();
        NBTTagList list = nbt.func_150295_c("ToRemove", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ItemStack stack = new ItemStack(list.func_150305_b(i));
            if (stack.func_190926_b()) continue;
            data.add(stack);
        }
        return data;
    }

    public void setToRemove(ItemStack upgrade, List<ItemStack> items) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < items.size(); ++i) {
            list.func_74742_a((NBTBase)items.get(i).func_77955_b(new NBTTagCompound()));
        }
        StackUtil.getOrCreateNbtData(upgrade).func_74782_a("ToRemove", (NBTBase)list);
    }

    public int getCraftingTime(ItemStack upgrade) {
        return StackUtil.getNbtData(upgrade).func_74762_e("Delay");
    }

    public void setLastCraft(ItemStack upgrade, long lastTime) {
        StackUtil.getOrCreateNbtData(upgrade).func_74772_a("LastCraft", lastTime);
    }

    public long getLastCrafting(ItemStack upgrade) {
        return StackUtil.getNbtData(upgrade).func_74763_f("LastCraft");
    }

    public void setCraftingTime(ItemStack upgrade, int time, int cause) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(upgrade);
        nbt.func_74768_a("Delay", time);
        nbt.func_74774_a("Cause", (byte)cause);
    }

    public int getPotentialCause(ItemStack upgrade) {
        return StackUtil.getNbtData(upgrade).func_74762_e("Cause");
    }

    public void setOutput(ItemStack stack, String text) {
        StackUtil.getOrCreateNbtData(stack).func_74778_a("Output", text);
    }

    public String getOutput(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74779_i("Output");
    }

    public void increaseDelay(ItemStack upgrade) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(upgrade);
        nbt.func_74768_a("Delay", MathHelper.func_76125_a((int)(nbt.func_74762_e("Delay") + 5), (int)5, (int)200));
        nbt.func_74774_a("Cause", (byte)-1);
    }

    public void decreaseDelay(ItemStack upgrade) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(upgrade);
        nbt.func_74768_a("Delay", MathHelper.func_76125_a((int)(nbt.func_74762_e("Delay") - 5), (int)5, (int)200));
    }

    public boolean isOreDicted(ItemStack upgrade) {
        return StackUtil.getNbtData(upgrade).func_74767_n("oreDict");
    }

    public boolean isValid(ItemStack upgrade) {
        return StackUtil.getNbtData(upgrade).func_74767_n("isValid");
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, ItemStack stack, int key) {
        if (player.field_71070_bA instanceof ContainerCraftingUpgrade) {
            InventoryCraftingUpgrade upgrade = (InventoryCraftingUpgrade)((ContainerCraftingUpgrade)player.field_71070_bA).getGuiHolder();
            if (key == 0) {
                upgrade.valdiateRecipe(player);
            } else if (key == 1) {
                upgrade.oreDicted = !upgrade.oreDicted;
            }
        }
    }

    @Override
    public boolean needsTick() {
        return true;
    }

    @Override
    public boolean usesDirection() {
        return true;
    }

    @Override
    public IMachineUpgradeItem.UpgradeType getType() {
        return IMachineUpgradeItem.UpgradeType.Processing;
    }

    @Override
    public LocaleComp getName() {
        return Ic2ItemLang.craftingUpgrade;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture() {
        return Ic2Icons.getTextures("i0")[162];
    }

    @Override
    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    @Override
    public boolean usesExtraRightClick(ItemStack item) {
        return true;
    }

    @Override
    public void onRightClick(ItemStack item, World world, EntityPlayer player, EnumHand hand) {
        if (IC2.keyboard.isSideinventoryKeyDown(player)) {
            IC2.platform.launchGui(player, this.getInventory(player, hand, item), hand);
        }
    }

    @Override
    public IHasGui getInventory(EntityPlayer player, EnumHand hand, ItemStack stack) {
        return new InventoryCraftingUpgrade(player, (IHandHeldInventory)stack.func_77973_b(), stack);
    }
}

