/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network;

import ic2.core.IC2;
import ic2.core.network.ChannelManager;
import ic2.core.network.NetworkManager;
import ic2.core.network.fieldEvents.custom.NBTFieldPacket;
import ic2.core.network.fieldEvents.custom.PayloadFieldPacket;
import ic2.core.network.fieldEvents.item.ObscuratorFieldData;
import ic2.core.network.fieldEvents.item.SlotTypeModifierFieldData;
import ic2.core.network.packets.IC2Packet;
import ic2.core.platform.registry.Ic2People;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ChannelHandler.Sharable
public class PacketManager
extends SimpleChannelInboundHandler<IC2Packet> {
    boolean client;
    UUID owner = null;
    private EnumMap<Side, FMLEmbeddedChannel> channel;
    public static PacketManager instance = new PacketManager();
    List<IC2Packet> clientQuere = new ArrayList<IC2Packet>();

    public void init() {
        this.channel = NetworkRegistry.INSTANCE.newChannel("ic2", new ChannelHandler[]{new ChannelManager(), this});
        NetworkManager manager = IC2.network.get();
        manager.registerEventFieldData(ObscuratorFieldData.class, "ObscuratorData");
        manager.registerEventFieldData(PayloadFieldPacket.class, "PayloadData");
        manager.registerEventFieldData(SlotTypeModifierFieldData.class, "SlotModifierData");
        manager.registerEventFieldData(NBTFieldPacket.class, "NBTPacket");
        this.client = IC2.platform.isRendering();
        if (this.client) {
            this.owner = this.getOwner();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public UUID getOwner() {
        return Minecraft.func_71410_x().func_110432_I().func_148256_e().getId();
    }

    protected void channelRead0(ChannelHandlerContext ctx, final IC2Packet msg) throws Exception {
        try {
            INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
            final EntityPlayer player = this.getPlayer(netHandler);
            if (player == null) {
                if (IC2.platform.isRendering()) {
                    this.clientQuere.add(msg);
                    return;
                }
                throw new RuntimeException("A case which never should happen did happen please Send a message to the ModAuthor and tell him how that Happend! Class: " + msg.getClass() + ", Side: " + FMLCommonHandler.instance().getEffectiveSide());
            }
            IThreadListener thread = FMLCommonHandler.instance().getWorldThread(netHandler);
            if (thread.func_152345_ab()) {
                this.handleMessage(msg, player);
            } else {
                thread.func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        PacketManager.this.handleMessage(msg, player);
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handleMessage(IC2Packet msg, EntityPlayer player) {
        if (this.clientQuere.size() > 0) {
            for (IC2Packet quere : this.clientQuere) {
                try {
                    quere.handlePacket(player);
                    if (!this.client || this.owner == null || !this.owner.equals(Ic2People.greg)) continue;
                    FMLLog.getLogger().info("Packet Data Received: Message: " + quere.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.clientQuere.clear();
        }
        try {
            msg.handlePacket(player);
            if (this.client && this.owner != null && this.owner.equals(Ic2People.greg)) {
                FMLLog.getLogger().info("Packet Data Received: Message: " + msg.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public EntityPlayer getPlayer(INetHandler handler) {
        if (handler instanceof NetHandlerPlayServer) {
            return ((NetHandlerPlayServer)handler).field_147369_b;
        }
        return IC2.platform.getPlayerInstance();
    }

    public void sendToPlayer(IC2Packet par1, EntityPlayer par2) {
        if (!(par2 instanceof EntityPlayerMP)) {
            FMLLog.log.info("Invalid Player Found: " + par2);
            return;
        }
        this.channel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.channel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)par2);
        this.channel.get(Side.SERVER).writeOutbound(new Object[]{par1});
    }

    public void sendToServer(IC2Packet par1) {
        this.channel.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.channel.get(Side.CLIENT).writeOutbound(new Object[]{par1});
    }

    public void sendToAllPlayers(IC2Packet par1) {
        this.channel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.channel.get(Side.SERVER).writeOutbound(new Object[]{par1});
    }
}

