/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.network.packets.server;

import ic2.core.IC2;
import ic2.core.network.packets.IC2Packet;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class BiomeUpdatePacket
extends IC2Packet {
    int dimID;
    ChunkPos pos;
    int index;
    byte biome;

    public BiomeUpdatePacket() {
    }

    public BiomeUpdatePacket(World world, ChunkPos pos, int index, byte biome) {
        this.dimID = world.field_73011_w.getDimension();
        this.pos = pos;
        this.index = index;
        this.biome = biome;
    }

    @Override
    public void read(ByteBuf par1) {
        this.dimID = par1.readInt();
        int x = par1.readInt();
        int z = par1.readInt();
        this.pos = new ChunkPos(x, z);
        this.index = par1.readShort();
        this.biome = par1.readByte();
    }

    @Override
    public void write(ByteBuf par1) {
        par1.writeInt(this.dimID);
        par1.writeInt(this.pos.field_77276_a);
        par1.writeInt(this.pos.field_77275_b);
        par1.writeShort(this.index);
        par1.writeByte((int)this.biome);
    }

    @Override
    public void handlePacket(EntityPlayer par1) {
        World world = IC2.platform.getWorld(this.dimID);
        if (world == null) {
            throw new RuntimeException("Packet Contains Incorrect data");
        }
        world.func_72964_e((int)this.pos.field_77276_a, (int)this.pos.field_77275_b).func_76605_m()[this.index] = this.biome;
        world.func_72975_g(this.pos.func_180334_c(), this.pos.func_180333_d(), this.pos.func_180332_e(), this.pos.func_180330_f());
    }

    public String toString() {
        return "BiomeChange Packet: Pos: " + this.pos.toString() + ", Biome: " + Biome.func_150568_d((int)this.biome).toString() + ", index: " + this.index;
    }
}

