/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.capabilities.provider;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class CapabilityProviderIC2
implements ICapabilitySerializable<NBTTagCompound> {
    Map<EnumFacing, Map<Capability, Object>> containerData = new HashMap<EnumFacing, Map<Capability, Object>>();
    boolean isEmpty = true;

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public <T> void addCapability(EnumFacing par1, Capability<T> par2, T par3) {
        this.isEmpty = false;
        Map<Capability, Object> data = this.containerData.get(par1);
        if (data == null) {
            data = new LinkedHashMap<Capability, Object>();
            this.containerData.put(par1, data);
        }
        data.put(par2, par3);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        Map<Capability, Object> data = this.containerData.get(facing);
        if (data == null) {
            return false;
        }
        return data.containsKey(capability);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        Map<Capability, Object> data = this.containerData.get(facing);
        if (data == null) {
            return null;
        }
        return (T)data.get(capability);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagList mainList = new NBTTagList();
        for (Map.Entry<EnumFacing, Map<Capability, Object>> entry : this.containerData.entrySet()) {
            EnumFacing facing = entry.getKey();
            NBTTagCompound data = new NBTTagCompound();
            for (Map.Entry<Capability, Object> cont : entry.getValue().entrySet()) {
                Capability cap = cont.getKey();
                NBTBase base = cap.writeNBT(cont.getValue(), facing);
                if (base == null) continue;
                data.func_74782_a(cap.getName(), base);
            }
            data.func_74768_a("IC2ProviderSide", facing == null ? 6 : facing.func_176745_a());
            mainList.func_74742_a((NBTBase)data);
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("Data", (NBTBase)mainList);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("Data", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            int side = data.func_74762_e("IC2ProviderSide");
            EnumFacing facing = side == 6 ? null : EnumFacing.field_82609_l[side];
            Map<Capability, Object> cont = this.containerData.get(facing);
            if (cont == null || cont.isEmpty()) continue;
            for (Map.Entry<Capability, Object> cap : cont.entrySet()) {
                Capability key = cap.getKey();
                if (!data.func_74764_b(key.getName())) continue;
                key.readNBT(cap.getValue(), facing, data.func_74781_a(key.getName()));
            }
        }
    }
}

