/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.saveables;

import ic2.core.platform.saveables.IWorldSaveable;
import ic2.core.platform.saveables.saves.TeamSaver;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.event.world.WorldEvent;

public class SaveableManager {
    Map<String, Class<? extends WorldSavedData>> global = new HashMap<String, Class<? extends WorldSavedData>>();
    Map<String, Class<? extends WorldSavedData>> local = new HashMap<String, Class<? extends WorldSavedData>>();
    Set<String> ignoreGlobal = new HashSet<String>();
    Set<String> ignoreLocal = new HashSet<String>();

    public void init() {
        this.registerGlobal("IC2TeamData", TeamSaver.class, false);
    }

    public void registerGlobal(String id, Class<? extends WorldSavedData> clz, boolean ignore) {
        this.global.put(id, clz);
        if (ignore) {
            this.ignoreGlobal.add(id);
        }
    }

    public void registerLocal(String id, Class<? extends WorldSavedData> clz, boolean ignore) {
        this.local.put(id, clz);
        if (ignore) {
            this.ignoreLocal.add(id);
        }
    }

    public void onWorldLoad(WorldEvent.Load event) {
        MapStorage worldStorage;
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        MapStorage globalStorage = world.func_175693_T();
        if (globalStorage != null) {
            for (Map.Entry<String, Class<? extends WorldSavedData>> entry : this.global.entrySet()) {
                WorldSavedData instanced;
                Class<? extends WorldSavedData> data;
                String name = entry.getKey();
                if (this.ignoreGlobal.contains(name) || globalStorage.func_75742_a(data = entry.getValue(), name) != null || (instanced = this.createType(name, data)) == null) continue;
                globalStorage.func_75745_a(name, instanced);
            }
        }
        if ((worldStorage = world.getPerWorldStorage()) != null) {
            for (Map.Entry<String, Class<? extends WorldSavedData>> entry : this.local.entrySet()) {
                String name = entry.getKey();
                if (this.ignoreLocal.contains(name)) continue;
                Class<? extends WorldSavedData> data = entry.getValue();
                WorldSavedData worldData = worldStorage.func_75742_a(data, name);
                if (worldData == null) {
                    worldData = this.createType(name, data);
                    if (worldData == null) continue;
                    worldStorage.func_75745_a(name, worldData);
                }
                if (!(worldData instanceof IWorldSaveable)) continue;
                ((IWorldSaveable)worldData).setWorld(world);
            }
        }
    }

    private WorldSavedData createType(String name, Class<? extends WorldSavedData> clz) {
        try {
            return clz.getConstructor(String.class).newInstance(name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public <T> T getLocalData(World world, String id, Class<T> noUse) {
        WorldSavedData result = world.getPerWorldStorage().func_75742_a(this.local.get(id), id);
        if (result == null && (result = this.createType(id, this.local.get(id))) != null) {
            world.getPerWorldStorage().func_75745_a(id, result);
        }
        return (T)result;
    }

    public <T> T getGlobalData(World world, String id, Class<T> noUse) {
        WorldSavedData result = world.func_72943_a(this.global.get(id), id);
        if (result == null && (result = this.createType(id, this.global.get(id))) != null) {
            world.func_72823_a(id, result);
        }
        return (T)result;
    }
}

