/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.textures;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import ic2.core.IC2;
import ic2.core.block.render.model.BlockCopyModel;
import ic2.core.platform.textures.models.BaseModel;
import ic2.core.platform.textures.models.BasicBlockModel;
import ic2.core.platform.textures.models.BasicItemModel;
import ic2.core.platform.textures.models.LayeredBlockModel;
import ic2.core.platform.textures.models.LayeredItemModel;
import ic2.core.platform.textures.models.TileModel;
import ic2.core.platform.textures.obj.IAdvancedTexturedItem;
import ic2.core.platform.textures.obj.IColorEffectedTexture;
import ic2.core.platform.textures.obj.ICustomItemCameraTransform;
import ic2.core.platform.textures.obj.ICustomModeledBlock;
import ic2.core.platform.textures.obj.ICustomModeledItem;
import ic2.core.platform.textures.obj.ILateModel;
import ic2.core.platform.textures.obj.ILayeredBlockModel;
import ic2.core.platform.textures.obj.ILayeredItemModel;
import ic2.core.platform.textures.obj.IStaticTexturedItem;
import ic2.core.platform.textures.obj.ITexturedBlock;
import ic2.core.platform.textures.obj.ITexturedItem;
import ic2.core.platform.textures.obj.ITileEntityModeledBlock;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Matrix4f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.BlockPart;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.block.model.SimpleBakedModel;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;

@SideOnly(value=Side.CLIENT)
public class Ic2Models {
    static Map<Item, Map<Integer, ModelResourceLocation>> itemLocations = new HashMap<Item, Map<Integer, ModelResourceLocation>>();
    static Map<Block, Map<IBlockState, ModelResourceLocation>> blockMap = new HashMap<Block, Map<IBlockState, ModelResourceLocation>>();
    static IStateMapper blockMapper = new ClassicStateMapper();
    static ItemMeshDefinition itemBlockMesher = new ClassicStateMesher();
    static ItemMeshDefinition itemMesher = new ClassicDefinition();
    static Map<ResourceLocation, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>> cache = new HashMap<ResourceLocation, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>>();
    static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> itemTransforms;
    static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> toolTransforms;
    static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> blockTransforms;
    static FaceBakery bake;
    static Set<BaseModel> modelsToInit;
    static Set<ILateModel> modelsToPostInit;

    public static TextureAtlasSprite getIconSafe(TextureAtlasSprite par1) {
        if (par1 == null) {
            return Minecraft.func_71410_x().func_147117_R().func_174944_f();
        }
        return par1;
    }

    public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getItemTransforms() {
        return itemTransforms;
    }

    public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getToolTransforms() {
        return toolTransforms;
    }

    public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getBlockTransforms() {
        return blockTransforms;
    }

    public static FaceBakery getBakery() {
        return bake;
    }

    static void addModel(BaseModel model) {
        if (model instanceof ILateModel) {
            modelsToPostInit.add((ILateModel)((Object)model));
        } else {
            modelsToInit.add(model);
        }
    }

    static void loadModels(ModelBakeEvent event) {
        cache.clear();
        modelsToInit = new LinkedHashSet<BaseModel>();
        modelsToPostInit = new LinkedHashSet<ILateModel>();
        BlockCopyModel.cleanup();
        toolTransforms = Ic2Models.getMap(new ResourceLocation("minecraft:models/item/handheld"));
        itemTransforms = Ic2Models.getMap(new ResourceLocation("minecraft:models/item/generated"));
        blockTransforms = Ic2Models.getMap(new ResourceLocation("minecraft:models/block/block"));
        Ic2Models.handleBlocks(event);
        Ic2Models.handleItems(event);
    }

    static void handleItems(ModelBakeEvent event) {
        IRegistry registry = event.getModelRegistry();
        for (Item item : Item.field_150901_e) {
            ModelResourceLocation resource;
            BaseModel model;
            Object textured;
            ICustomItemCameraTransform transform;
            LinkedHashMap<Integer, ModelResourceLocation> map = new LinkedHashMap<Integer, ModelResourceLocation>();
            ICustomItemCameraTransform iCustomItemCameraTransform = transform = item instanceof ICustomItemCameraTransform ? (ICustomItemCameraTransform)item : null;
            if (item instanceof IStaticTexturedItem) {
                textured = (IStaticTexturedItem)item;
                for (Integer meta : textured.getValidVariants()) {
                    ItemStack stack = new ItemStack(item, 1, meta.intValue());
                    BaseModel model2 = Ic2Models.isLayeredModel(stack) ? new LayeredItemModel(Ic2Models.getTransforms(transform, meta, itemTransforms), stack, (ILayeredItemModel)stack.func_77973_b(), textured.getTexture(meta)) : new BasicItemModel(Ic2Models.getTransforms(transform, meta, itemTransforms), textured.getTexture(meta), item instanceof IColorEffectedTexture);
                    Ic2Models.addModel(model2);
                    ModelResourceLocation resource2 = Ic2Models.getItemInventoryResourceLocation(stack);
                    ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{resource2});
                    registry.func_82595_a((Object)resource2, (Object)model2);
                    map.put(meta, resource2);
                }
            }
            if (item instanceof ITexturedItem) {
                textured = (ITexturedItem)item;
                for (ItemStack stack : textured.getValidItemVariants()) {
                    model = Ic2Models.isLayeredModel(stack) ? new LayeredItemModel(Ic2Models.getTransforms(transform, stack.func_77960_j(), itemTransforms), stack, (ILayeredItemModel)stack.func_77973_b(), textured.getTexture(stack)) : new BasicItemModel(Ic2Models.getTransforms(transform, stack.func_77960_j(), itemTransforms), textured.getTexture(stack), item instanceof IColorEffectedTexture);
                    Ic2Models.addModel(model);
                    resource = Ic2Models.getItemInventoryResourceLocation(stack);
                    ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{resource});
                    registry.func_82595_a((Object)resource, (Object)model);
                    map.put(stack.func_77960_j(), resource);
                }
            }
            if (item instanceof ICustomModeledItem) {
                ICustomModeledItem custom = (ICustomModeledItem)item;
                for (ItemStack stack : custom.getValidItemTypes()) {
                    model = custom.getModelFromItem(stack);
                    Ic2Models.addModel(model);
                    resource = Ic2Models.getItemInventoryResourceLocation(stack);
                    ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{resource});
                    registry.func_82595_a((Object)resource, (Object)model);
                    map.put(stack.func_77960_j(), resource);
                }
            }
            if (map.size() <= 0) continue;
            ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)itemMesher);
            itemLocations.put(item, map);
            registry.func_82595_a((Object)Ic2Models.getItemInventoryResourceLocation(item), registry.func_82594_a(map.values().iterator().next()));
        }
    }

    static void handleBlocks(ModelBakeEvent event) {
        IRegistry registry = event.getModelRegistry();
        for (Block block : Block.field_149771_c) {
            ModelResourceLocation resourceLocation;
            BaseModel model;
            LinkedHashMap<IBlockState, ModelResourceLocation> map = new LinkedHashMap<IBlockState, ModelResourceLocation>();
            if (block instanceof ITexturedBlock) {
                ITexturedBlock textured = (ITexturedBlock)block;
                if (block instanceof ILayeredBlockModel) {
                    ILayeredBlockModel layer = (ILayeredBlockModel)block;
                    for (IBlockState state : textured.getValidStates()) {
                        BaseModel model2 = layer.isLayered(state) ? new LayeredBlockModel(layer, state) : new BasicBlockModel(textured, state);
                        Ic2Models.addModel(model2);
                        ModelResourceLocation resourceLocation2 = Ic2Models.getModelResourceLocation(state);
                        registry.func_82595_a((Object)resourceLocation2, (Object)model2);
                        map.put(state, resourceLocation2);
                    }
                } else {
                    for (IBlockState state : textured.getValidStates()) {
                        model = new BasicBlockModel(textured, state);
                        Ic2Models.addModel(model);
                        resourceLocation = Ic2Models.getModelResourceLocation(state);
                        registry.func_82595_a((Object)resourceLocation, (Object)model);
                        map.put(state, resourceLocation);
                    }
                }
            }
            if (block instanceof ICustomModeledBlock) {
                ICustomModeledBlock custom = (ICustomModeledBlock)block;
                for (IBlockState state : custom.getValidModelStates()) {
                    model = custom.getModelFromState(state);
                    Ic2Models.addModel(model);
                    resourceLocation = Ic2Models.getModelResourceLocation(state);
                    registry.func_82595_a((Object)resourceLocation, (Object)model);
                    map.put(state, resourceLocation);
                }
            }
            if (block instanceof ITileEntityModeledBlock) {
                ITileEntityModeledBlock tile = (ITileEntityModeledBlock)block;
                for (IBlockState state : tile.getTileStates()) {
                    model = new TileModel(tile.getParticalTexture(state));
                    Ic2Models.addModel(model);
                    resourceLocation = Ic2Models.getModelResourceLocation(state);
                    registry.func_82595_a((Object)resourceLocation, (Object)model);
                    map.put(state, resourceLocation);
                    ForgeHooksClient.registerTESRItemStack((Item)Item.func_150898_a((Block)block), (int)block.func_176201_c(state), tile.getClassFromState(state));
                }
            }
            if (map.size() <= 0) continue;
            blockMap.put(block, map);
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)blockMapper);
            ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)block), (ItemMeshDefinition)itemBlockMesher);
            registry.func_82595_a((Object)Ic2Models.getBlockInventoryResourceLocation(block), registry.func_82594_a(map.values().iterator().next()));
        }
    }

    private static boolean isLayeredModel(ItemStack stack) {
        return stack.func_77973_b() instanceof ILayeredItemModel && ((ILayeredItemModel)stack.func_77973_b()).isLayered(stack);
    }

    public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getTransforms(ICustomItemCameraTransform transform, int meta, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> defaultValue) {
        if (transform != null && transform.hasCustomTransform(meta)) {
            return Ic2Models.getMap(transform.getCustomTransform(meta));
        }
        return defaultValue;
    }

    private static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getMapSpecail(IModelState defaultState) {
        return PerspectiveMapWrapper.getTransforms((IModelState)defaultState);
    }

    public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getMap(ResourceLocation par1) {
        ImmutableMap result = cache.get(par1);
        if (result == null) {
            EnumMap<ItemCameraTransforms.TransformType, TRSRTransformation> map = new EnumMap<ItemCameraTransforms.TransformType, TRSRTransformation>(ItemCameraTransforms.TransformType.class);
            map.putAll((Map<ItemCameraTransforms.TransformType, TRSRTransformation>)PerspectiveMapWrapper.getTransforms((ItemCameraTransforms)Ic2Models.getTransformFromJson(par1)));
            ItemCameraTransforms trans = Ic2Models.getTransformFromJson(new ResourceLocation("minecraft:models/item/generated"));
            for (ItemCameraTransforms.TransformType type : ItemCameraTransforms.TransformType.values()) {
                map.putIfAbsent(type, TRSRTransformation.blockCenterToCorner((TRSRTransformation)TRSRTransformation.from((ItemTransformVec3f)trans.func_181688_b(type))));
            }
            result = ImmutableMap.copyOf(map);
            cache.put(par1, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)result);
        }
        return result;
    }

    private static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> getMap(ItemCameraTransforms par1) {
        return PerspectiveMapWrapper.getTransforms((ItemCameraTransforms)par1);
    }

    private static ItemCameraTransforms getTransformFromJson(ResourceLocation par1) {
        try {
            return ModelBlock.func_178307_a((Reader)Ic2Models.getReaderForResource(par1)).func_181682_g();
        }
        catch (Exception e) {
            IC2.platform.displayError("Error during loading Transformations");
            e.printStackTrace();
            return ItemCameraTransforms.field_178357_a;
        }
    }

    public static ModelResourceLocation getModelResourceLocation(IBlockState state) {
        return new ModelResourceLocation((ResourceLocation)Block.field_149771_c.func_177774_c((Object)state.func_177230_c()), new DefaultStateMapper().func_178131_a((Map)state.func_177228_b()));
    }

    public static ModelResourceLocation getBlockInventoryResourceLocation(Block block) {
        return new ModelResourceLocation((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block), "inventory");
    }

    public static ModelResourceLocation getItemInventoryResourceLocation(ItemStack item) {
        if (item.func_77973_b() instanceof IAdvancedTexturedItem) {
            return ((IAdvancedTexturedItem)item.func_77973_b()).createResourceLocationForStack(item);
        }
        String name = item.func_77977_a();
        ResourceLocation resource = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)item.func_77973_b());
        return new ModelResourceLocation(resource.func_110624_b() + name.substring(name.indexOf(".") + 1), "inventory");
    }

    public static ModelResourceLocation getItemInventoryResourceLocation(Item item) {
        return new ModelResourceLocation((ResourceLocation)Item.field_150901_e.func_177774_c((Object)item), "inventory");
    }

    private static Reader getReaderForResource(ResourceLocation location) throws IOException {
        ResourceLocation file = new ResourceLocation(location.func_110624_b(), location.func_110623_a() + ".json");
        IResource iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(file);
        return new BufferedReader(new InputStreamReader(iresource.func_110527_b(), Charsets.UTF_8));
    }

    public static IBakedModel loadMinecraftModelVariant(Variant model) {
        ModelBlock block = Ic2Models.getModelBlock(model);
        if (block != null) {
            TextureMap map = Minecraft.func_71410_x().func_147117_R();
            TextureAtlasSprite textureatlassprite = map.func_110572_b(new ResourceLocation(block.func_178308_c("particle")).toString());
            SimpleBakedModel.Builder simplebakedmodel$builder = new SimpleBakedModel.Builder(block, block.func_187967_g()).func_177646_a(textureatlassprite);
            ModelRotation modelRotationIn = model.func_188048_b();
            if (block.func_178298_a().isEmpty()) {
                return null;
            }
            for (BlockPart blockpart : block.func_178298_a()) {
                for (EnumFacing enumfacing : blockpart.field_178240_c.keySet()) {
                    BlockPartFace blockpartface = (BlockPartFace)blockpart.field_178240_c.get(enumfacing);
                    TextureAtlasSprite textureatlassprite1 = map.func_110572_b(new ResourceLocation(block.func_178308_c(blockpartface.field_178242_d)).toString());
                    if (blockpartface.field_178244_b == null || !TRSRTransformation.isInteger((Matrix4f)modelRotationIn.getMatrix())) {
                        simplebakedmodel$builder.func_177648_a(bake.func_178414_a(blockpart.field_178241_a, blockpart.field_178239_b, blockpartface, textureatlassprite1, enumfacing, modelRotationIn, blockpart.field_178237_d, model.func_188049_c(), blockpart.field_178238_e));
                        continue;
                    }
                    simplebakedmodel$builder.func_177650_a(modelRotationIn.rotate(blockpartface.field_178244_b), bake.func_178414_a(blockpart.field_178241_a, blockpart.field_178239_b, blockpartface, textureatlassprite1, enumfacing, modelRotationIn, blockpart.field_178237_d, model.func_188049_c(), blockpart.field_178238_e));
                }
            }
            return simplebakedmodel$builder.func_177645_b();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModelBlock getModelBlock(Variant model) {
        block5: {
            ModelBlock modelBlock;
            InputStream stream = null;
            InputStreamReader reader = null;
            try {
                ResourceLocation location = new ResourceLocation(model.func_188046_a().func_110624_b(), "models/" + model.func_188046_a().func_110623_a() + ".json");
                stream = Minecraft.func_71410_x().func_110442_L().func_110536_a(location).func_110527_b();
                reader = new InputStreamReader(stream, Charsets.UTF_8);
                ModelBlock block = ModelBlock.func_178307_a((Reader)reader);
                block.field_178317_b = model.func_188046_a().toString();
                stream.close();
                ((Reader)reader).close();
                modelBlock = block;
                IOUtils.closeQuietly((Reader)reader);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly(stream);
            }
            IOUtils.closeQuietly((InputStream)stream);
            return modelBlock;
        }
        return null;
    }

    static {
        bake = new FaceBakery();
        modelsToInit = new LinkedHashSet<BaseModel>();
        modelsToPostInit = new LinkedHashSet<ILateModel>();
    }

    public static class ModelReloader
    implements IResourceManagerReloadListener {
        public void func_110549_a(IResourceManager resourceManager) {
            Set<BaseModel> models = modelsToInit;
            for (BaseModel model : models) {
                model.init();
            }
            Set<ILateModel> lateModels = modelsToPostInit;
            for (ILateModel model : lateModels) {
                model.onLaterLoad();
            }
        }
    }

    public static class ClassicStateMesher
    implements ItemMeshDefinition {
        public ModelResourceLocation func_178113_a(ItemStack stack) {
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            Map<IBlockState, ModelResourceLocation> storage = blockMap.get(block);
            if (storage == null) {
                return null;
            }
            if (block instanceof ITexturedBlock) {
                return storage.get(((ITexturedBlock)block).getStateFromStack(stack));
            }
            if (block instanceof ICustomModeledBlock) {
                return storage.get(((ICustomModeledBlock)block).getStateFromStack(stack));
            }
            if (block instanceof ITileEntityModeledBlock) {
                return storage.get(((ITileEntityModeledBlock)block).getStateFromStack(stack));
            }
            return null;
        }
    }

    public static class ClassicStateMapper
    implements IStateMapper {
        public Map<IBlockState, ModelResourceLocation> func_178130_a(Block blockIn) {
            Map<IBlockState, ModelResourceLocation> states = blockMap.get(blockIn);
            if (states == null) {
                states = new HashMap<IBlockState, ModelResourceLocation>();
                blockMap.put(blockIn, states);
            }
            return states;
        }
    }

    public static class ClassicDefinition
    implements ItemMeshDefinition {
        public ModelResourceLocation func_178113_a(ItemStack stack) {
            Item item = stack.func_77973_b();
            if (item instanceof IAdvancedTexturedItem) {
                return ((IAdvancedTexturedItem)item).getResourceLocationForStack(stack);
            }
            Map<Integer, ModelResourceLocation> baseMap = itemLocations.get(item);
            if (baseMap == null || baseMap.isEmpty()) {
                return null;
            }
            int meta = stack.func_77981_g() ? stack.func_77960_j() : 0;
            return baseMap.get(meta);
        }
    }
}

