/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.textures;

import ic2.core.platform.textures.Ic2Icons;
import java.util.Objects;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Sprites {

    public static class CustomIconIndex {
        String sheetID;
        int x;
        int z;

        public CustomIconIndex(String id, int x, int z) {
            this.sheetID = id;
            this.x = x;
            this.z = z;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CustomIconIndex) {
                CustomIconIndex index = (CustomIconIndex)obj;
                return index.sheetID.equals(this.sheetID) && index.x == this.x && index.z == this.z;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.sheetID, this.x, this.z);
        }
    }

    public static class TextureEntry {
        String sheetID;
        int xMin;
        int xMax;
        int yMin;
        int yMax;

        public TextureEntry(String icon, int x, int y, int xM, int yM) {
            this.sheetID = icon;
            this.xMin = x;
            this.xMax = xM;
            this.yMin = y;
            this.yMax = yM;
        }

        @SideOnly(value=Side.CLIENT)
        public void load(TextureMap par1) {
            SpriteData sprite = Ic2Icons.iconIDToData.get(this.sheetID);
            for (int y = this.yMin; y < this.yMax; ++y) {
                for (int x = this.xMin; x < this.xMax; ++x) {
                    Ic2Icons.loadIcon(par1, sprite, x, y);
                }
            }
        }
    }

    public static class SpriteInfo {
        int maxX;
        int maxY;
        int spriteAmount;

        public SpriteInfo(int maxX, int maxY) {
            this.maxX = maxX;
            this.maxY = maxY;
            this.spriteAmount = maxX * maxY;
        }
    }

    public static class SpriteData {
        String modID;
        String spriteID;
        String texture;
        SpriteInfo info;

        public SpriteData(String spriteID, String texture, SpriteInfo info) {
            this.modID = texture.split(":")[0];
            this.spriteID = spriteID;
            this.texture = texture;
            this.info = info;
        }
    }

    public static class SpecialEntry {
        String sheetID;
        int xCoord;
        int yCoord;
        int modify;

        public SpecialEntry(String icon, int x, int y, int mod) {
            this.sheetID = icon;
            this.xCoord = x;
            this.yCoord = y;
            this.modify = mod;
        }

        @SideOnly(value=Side.CLIENT)
        public void load(TextureMap par1) {
            Ic2Icons.loadSpecialIcon(par1, Ic2Icons.iconIDToData.get(this.sheetID), this.xCoord, this.yCoord, this.modify);
        }
    }
}

