/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.textures.models;

import ic2.core.Direction;
import ic2.core.platform.textures.Ic2Models;
import ic2.core.platform.textures.models.BaseModel;
import ic2.core.platform.textures.obj.IBlockTextureModifier;
import ic2.core.platform.textures.obj.IColorEffectedTexture;
import ic2.core.platform.textures.obj.IFacingBlock;
import ic2.core.platform.textures.obj.ITexturedBlock;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import org.apache.commons.lang3.tuple.Pair;

public class BasicBlockModel
extends BaseModel {
    public List<BakedQuad>[] quads = this.createList(7);
    public ITexturedBlock block;
    public IBlockState meta;

    public BasicBlockModel(ITexturedBlock par1, IBlockState par2) {
        super(Ic2Models.getBlockTransforms());
        this.block = par1;
        this.meta = par2;
    }

    @Override
    public void init() {
        IFacingBlock facing;
        this.setParticalTexture(this.block.getParticleTexture(this.meta));
        boolean full = this.meta.func_185913_b();
        boolean color = this.block instanceof IColorEffectedTexture;
        EnumFacing blockFacing = EnumFacing.NORTH;
        ModelRotation rotation = ModelRotation.X0_Y0;
        if (this.block instanceof IFacingBlock && (facing = (IFacingBlock)((Object)this.block)).hasRotation(this.meta)) {
            blockFacing = facing.getRotation(this.meta);
            Tuple<Integer, Integer> result = Direction.getModelRotation(blockFacing);
            rotation = ModelRotation.func_177524_a((int)((Integer)result.func_76341_a()), (int)((Integer)result.func_76340_b()));
        }
        IBlockTextureModifier modifier = (IBlockTextureModifier)(this.block instanceof IBlockTextureModifier ? this.block : null);
        AxisAlignedBB box = this.block.getRenderBoundingBox(this.meta);
        if (full) {
            for (EnumFacing side : EnumFacing.field_82609_l) {
                ModelRotation sideRotation = this.getRotation(blockFacing, side, rotation);
                BlockPartFace face = this.createBlockFace(side, color, modifier);
                TextureAtlasSprite sprite = Ic2Models.getIconSafe(this.block.getTextureFromState(this.meta, side));
                this.quads[side.func_176745_a()].add(this.getBakery().func_178414_a(this.getMinBox(side, box), this.getMaxBox(side, box), face, sprite, side, sideRotation, null, false, true));
            }
        } else {
            for (EnumFacing side : EnumFacing.field_82609_l) {
                ModelRotation sideRotation = this.getRotation(blockFacing, side, rotation);
                BlockPartFace face = this.createBlockFace(side, color, modifier);
                TextureAtlasSprite sprite = Ic2Models.getIconSafe(this.block.getTextureFromState(this.meta, side));
                this.quads[6].add(this.getBakery().func_178414_a(this.getMinBox(side, box), this.getMaxBox(side, box), face, sprite, side, sideRotation, null, false, true));
            }
        }
    }

    protected ModelRotation getRotation(EnumFacing facing, EnumFacing side, ModelRotation defaultRotation) {
        if (facing.func_176740_k().func_176722_c() && side.func_176740_k().func_176720_b()) {
            return defaultRotation;
        }
        if (facing.func_176740_k().func_176720_b() && side.func_176740_k() == EnumFacing.Axis.X) {
            return defaultRotation;
        }
        return ModelRotation.X0_Y0;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        return this.quads[side == null ? 6 : side.func_176745_a()];
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return Pair.of((Object)((Object)this), (Object)PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.getCamera(), (ItemCameraTransforms.TransformType)cameraTransformType).getRight());
    }

    protected BlockPartFace createBlockFace(EnumFacing side, boolean color, IBlockTextureModifier mod) {
        if (mod != null) {
            int rotation = 0;
            float[] uvs = new float[]{0.0f, 0.0f, 16.0f, 16.0f};
            if (mod.hasTextureRotation(this.meta, side)) {
                rotation = mod.getTextureRotation(this.meta, side);
            }
            if (mod.hasCustomTextureUV(this.meta, side)) {
                uvs = mod.getCustomTextureUV(this.meta, side);
            }
            return new BlockPartFace(null, color ? 0 : -1, "", new BlockFaceUV(uvs, rotation));
        }
        return new BlockPartFace(null, color ? 0 : -1, "", new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0));
    }
}

