/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.platform.wind.worlds;

import ic2.api.classic.wind.IWindHandlerInfo;
import ic2.api.classic.wind.IWindStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WindHandlerNether
implements IWindHandlerInfo {
    static final double maxWind = 180.0;
    World world;
    List<IWindStream> streams = new ArrayList<IWindStream>();

    public WindHandlerNether(World par1) {
        this.world = par1;
        this.streams.add(new NetherWindStream(this.world.field_73011_w.getActualHeight(), 0.0f));
        this.streams.add(new NetherWindStream(this.world.field_73011_w.getActualHeight(), 180.0f));
    }

    @Override
    public void onTick() {
    }

    @Override
    public double getWindStrenght(BlockPos pos, float rotation, float angle) {
        if (angle <= 95.0f && angle >= 85.0f || angle >= 265.0f && angle <= 275.0f) {
            return 0.0;
        }
        double vertical = this.getVertical(angle);
        double height = 1.0 - (double)pos.func_177956_o() / (double)this.world.field_73011_w.getActualHeight();
        double currentWind = 180.0;
        currentWind *= height;
        return currentWind *= vertical;
    }

    private double getVertical(float angle) {
        if (angle < 90.0f) {
            return 1.0 - (double)angle / 90.0;
        }
        if (angle > 270.0f) {
            return (double)(angle -= 270.0f) / 90.0;
        }
        if (angle > 180.0f) {
            return 1.0 - (double)(angle -= 180.0f) / 90.0;
        }
        return (double)(angle -= 90.0f) / 90.0;
    }

    @Override
    public double getMaxWind() {
        return 180.0;
    }

    @Override
    public List<IWindStream> getStreams() {
        return this.streams;
    }

    @Override
    public void onUnloaded() {
        this.streams.clear();
        this.world = null;
    }

    public static class NetherWindStream
    implements IWindStream {
        int maxY;
        float angle;

        public NetherWindStream(int maxY, float angle) {
            this.maxY = maxY;
            this.angle = angle;
        }

        @Override
        public boolean isAxisSupported(EnumFacing.Axis axis) {
            return axis == EnumFacing.Axis.Y;
        }

        @Override
        public AxisAlignedBB getBoundingBox() {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, (double)this.maxY, 0.0);
        }

        @Override
        public boolean hasDirection() {
            return false;
        }

        @Override
        public float getDirection() {
            return 0.0f;
        }

        @Override
        public boolean hasAngle() {
            return true;
        }

        @Override
        public float getAngle() {
            return this.angle;
        }

        @Override
        public double getWindSpeed() {
            return 180.0;
        }
    }
}

