/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util.misc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class IC2Command
extends CommandBase {
    private List<String> entities;

    public IC2Command() {
        Set names = EntityList.func_180124_b();
        this.entities = new ArrayList<String>(names.size());
        for (ResourceLocation loc : names) {
            this.entities.add(loc.toString());
        }
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71517_b() {
        return "ic2";
    }

    public String func_71518_a(ICommandSender sender) {
        return "Custom IC2Command with for Speigers Use";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Arguments are needed!"));
            return;
        }
        if (args.length == 1) {
            if (args[0].equals("KillEntities")) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Arguments are needed!"));
                return;
            }
            if (args[0].equals("KillItems")) {
                World world = sender.func_130014_f_();
                if (world == null) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Command Sender Needs to be in a world"));
                    return;
                }
                int added = 0;
                LinkedList<Entity> list = new LinkedList<Entity>();
                for (int i = 0; i < world.field_72996_f.size(); ++i) {
                    Entity entity = (Entity)world.field_72996_f.get(i);
                    if (!(entity instanceof EntityItem)) continue;
                    ++added;
                    entity.func_70106_y();
                    list.add(entity);
                }
                sender.func_145747_a((ITextComponent)new TextComponentString("Entity Items Killed: " + added));
                world.func_175681_c(list);
            }
        } else if (args.length == 2) {
            if (args[0].equals("KillEntities") || args[0].equals("CountEntities")) {
                boolean kill = args[0].equals("KillEntities");
                World world = sender.func_130014_f_();
                if (world == null) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Command Sender Needs to be in a world"));
                    return;
                }
                Class<?> clz = EntityList.func_192839_a((String)args[1]);
                if (clz == null) {
                    boolean found = false;
                    try {
                        clz = Class.forName(args[1]);
                        found = clz != null;
                    }
                    catch (Exception entity) {
                        // empty catch block
                    }
                    if (!found) {
                        sender.func_145747_a((ITextComponent)new TextComponentString("Invalid EntityID!"));
                        return;
                    }
                }
                LinkedList<Entity> list = new LinkedList<Entity>();
                for (int i = 0; i < world.field_72996_f.size(); ++i) {
                    Entity entity = (Entity)world.field_72996_f.get(i);
                    if (!clz.isInstance(entity)) continue;
                    if (kill) {
                        entity.func_70106_y();
                    }
                    list.add(entity);
                }
                sender.func_145747_a((ITextComponent)new TextComponentString("Entitys Killed: " + list.size()));
                if (kill) {
                    world.func_175681_c(list);
                }
            } else if (args[0].equals("RemoveTiles")) {
                World world = sender.func_130014_f_();
                if (world == null) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Command Sender Needs to be in a world"));
                    return;
                }
                Map map = (Map)ReflectionHelper.getPrivateValue(TileEntity.class, null, (int)1);
                if (map == null) {
                    return;
                }
                Class clz = (Class)map.get(args[1]);
                if (clz == null) {
                    return;
                }
                LinkedHashSet<BlockPos> toRemove = new LinkedHashSet<BlockPos>();
                for (int i = 0; i < world.field_147482_g.size(); ++i) {
                    TileEntity tile = (TileEntity)world.field_147482_g.get(i);
                    if (!clz.isInstance(tile)) continue;
                    toRemove.add(tile.func_174877_v());
                }
                for (BlockPos pos : toRemove) {
                    world.func_175698_g(pos);
                }
                sender.func_145747_a((ITextComponent)new TextComponentString("Tiles Killed: " + toRemove.size()));
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return Arrays.asList("KillEntities", "KillItems", "RemoveTiles", "CountEntities");
        }
        if (args.length == 2) {
            if (args[0].equals("KillEntities") || args[0].equals("CountEntities")) {
                return IC2Command.func_175762_a((String[])args, new ArrayList<String>(this.entities));
            }
            if (args[0].equals("RemoveTiles")) {
                Map map = (Map)ReflectionHelper.getPrivateValue(TileEntity.class, null, (int)1);
                return IC2Command.func_175762_a((String[])args, new ArrayList(map.keySet()));
            }
        }
        return super.func_184883_a(server, sender, args, pos);
    }
}

