/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.json;

import alexiil.mc.mod.load.CLSLog;
import alexiil.mc.mod.load.ClsManager;
import alexiil.mc.mod.load.json.Area;
import alexiil.mc.mod.load.json.InvalidSourceException;
import alexiil.mc.mod.load.json.JsonAction;
import alexiil.mc.mod.load.json.JsonConfig;
import alexiil.mc.mod.load.json.JsonConfigurable;
import alexiil.mc.mod.load.json.JsonFactory;
import alexiil.mc.mod.load.json.JsonInsn;
import alexiil.mc.mod.load.json.JsonRender;
import alexiil.mc.mod.load.json.JsonRenderingPart;
import alexiil.mc.mod.load.json.JsonVariable;
import alexiil.mc.mod.load.json.ResourceWrappingInputStream;
import alexiil.mc.mod.load.json.serial.ConfigDeserialiser;
import alexiil.mc.mod.load.json.serial.FactoryDeserialiser;
import alexiil.mc.mod.load.json.serial.ImageDeserialiser;
import alexiil.mc.mod.load.json.serial.InstructionDeserialiser;
import alexiil.mc.mod.load.json.serial.RenderingPartDeserialiser;
import alexiil.mc.mod.load.json.serial.VariableArrayDeserialiser;
import alexiil.mc.mod.load.repackage.buildcraft.lib.expression.api.InvalidExpressionException;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class ConfigManager {
    public static final Gson GSON_ADAPTORS;
    public static final Gson GSON_DEFAULT;
    private static final Map<Class<? extends JsonConfigurable<?, ?>>, EType> types;
    private static IResourceManager resManager;
    private static final Map<ResourceLocation, String> cache;
    private static final Map<ResourceLocation, String> failedCache;

    /*
     * Loose catch block
     */
    private static String getFirst(ResourceLocation identifier, boolean firstAttempt, boolean hasDefaut) {
        String string;
        Throwable throwable;
        InputStream stream;
        Throwable throwable2;
        IResource res;
        block58: {
            block59: {
                block56: {
                    block57: {
                        block60: {
                            String string2;
                            Throwable throwable3;
                            FileInputStream fis;
                            File file;
                            block54: {
                                block55: {
                                    if (identifier == null) {
                                        throw new NullPointerException("Identifier provided shouldn't have been null!");
                                    }
                                    if (!"config".equals(identifier.func_110624_b())) break block60;
                                    file = new File("config/customloadingscreen", identifier.func_110623_a());
                                    fis = new FileInputStream(file);
                                    throwable3 = null;
                                    string2 = IOUtils.toString((InputStream)fis, (Charset)StandardCharsets.UTF_8);
                                    if (fis == null) break block54;
                                    if (throwable3 == null) break block55;
                                    try {
                                        fis.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable3.addSuppressed(throwable4);
                                    }
                                    break block54;
                                }
                                fis.close();
                            }
                            return string2;
                            catch (Throwable throwable5) {
                                try {
                                    try {
                                        throwable3 = throwable5;
                                        throw throwable5;
                                    }
                                    catch (Throwable throwable6) {
                                        if (fis != null) {
                                            if (throwable3 != null) {
                                                try {
                                                    fis.close();
                                                }
                                                catch (Throwable throwable7) {
                                                    throwable3.addSuppressed(throwable7);
                                                }
                                            } else {
                                                fis.close();
                                            }
                                        }
                                        throw throwable6;
                                    }
                                }
                                catch (IOException e) {
                                    if (firstAttempt) {
                                        String real = file.toString();
                                        try {
                                            real = file.getCanonicalPath();
                                        }
                                        catch (IOException iOException) {
                                            // empty catch block
                                        }
                                        if (!hasDefaut) {
                                            CLSLog.warn("Tried to get the resource but failed! (" + real + ") because " + e.getClass());
                                        }
                                    }
                                    return null;
                                }
                            }
                        }
                        res = ClsManager.getResource(identifier);
                        throwable2 = null;
                        stream = res.func_110527_b();
                        throwable = null;
                        string = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                        if (stream == null) break block56;
                        if (throwable == null) break block57;
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable8) {
                            throwable.addSuppressed(throwable8);
                        }
                        break block56;
                    }
                    stream.close();
                }
                if (res == null) break block58;
                if (throwable2 == null) break block59;
                try {
                    res.close();
                }
                catch (Throwable throwable9) {
                    throwable2.addSuppressed(throwable9);
                }
                break block58;
            }
            res.close();
        }
        return string;
        {
            catch (Throwable throwable10) {
                try {
                    try {
                        try {
                            throwable = throwable10;
                            throw throwable10;
                        }
                        catch (Throwable throwable11) {
                            if (stream != null) {
                                if (throwable != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable throwable12) {
                                        throwable.addSuppressed(throwable12);
                                    }
                                } else {
                                    stream.close();
                                }
                            }
                            throw throwable11;
                        }
                    }
                    catch (IOException e) {
                        CLSLog.warn("Tried to access \"" + identifier + "\", but an IO exception occoured!", e);
                        throwable = null;
                        if (res != null) {
                            if (throwable2 != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable13) {
                                    throwable2.addSuppressed(throwable13);
                                }
                            } else {
                                res.close();
                            }
                        }
                        return throwable;
                    }
                }
                catch (Throwable throwable14) {
                    try {
                        try {
                            throwable2 = throwable14;
                            throw throwable14;
                        }
                        catch (Throwable throwable15) {
                            if (res != null) {
                                if (throwable2 != null) {
                                    try {
                                        res.close();
                                    }
                                    catch (Throwable throwable16) {
                                        throwable2.addSuppressed(throwable16);
                                    }
                                } else {
                                    res.close();
                                }
                            }
                            throw throwable15;
                        }
                    }
                    catch (IOException e) {
                        if (firstAttempt && !hasDefaut) {
                            CLSLog.warn("Tried to get the resource but failed! (" + identifier + ") because " + e.getClass());
                        }
                        return null;
                    }
                }
            }
        }
    }

    public static InputStream getInputStream(ResourceLocation identifier) throws FileNotFoundException {
        if (identifier == null) {
            throw new NullPointerException("Identifier provided shouldn't have been null!");
        }
        if ("config".equals(identifier.func_110624_b())) {
            File file = new File("config/customloadingscreen", identifier.func_110623_a());
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException fnfe) {
                throw fnfe;
            }
            catch (IOException io) {
                FileNotFoundException fnfe = new FileNotFoundException();
                fnfe.initCause(io);
                throw fnfe;
            }
        }
        try {
            IResource res = ClsManager.getResource(identifier);
            return new ResourceWrappingInputStream(res);
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (IOException io) {
            FileNotFoundException fnfe = new FileNotFoundException();
            fnfe.initCause(io);
            throw fnfe;
        }
    }

    private static String getTextResource(ResourceLocation identifier, boolean hasDefaut) {
        if (identifier == null) {
            throw new NullPointerException("Identifier provided shouldn't have been null!");
        }
        if (cache.containsKey(identifier)) {
            return cache.get(identifier);
        }
        if (failedCache.containsKey(identifier)) {
            String attempt = ConfigManager.getFirst(identifier, false, hasDefaut);
            if (attempt != null) {
                failedCache.remove(identifier);
                cache.put(identifier, attempt);
            }
            return attempt;
        }
        String actual = ConfigManager.getFirst(identifier, true, hasDefaut);
        if (actual == null) {
            failedCache.put(identifier, null);
        } else {
            cache.put(identifier, actual);
        }
        return actual;
    }

    static <T extends JsonConfigurable<T, ?>> T getAsT(EType type, String location) throws InvalidExpressionException {
        if (StringUtils.isEmpty((CharSequence)location)) {
            CLSLog.warn("Location was given as null!", new Throwable());
            throw new JsonSyntaxException("Invalid location '" + location + "'");
        }
        CLSLog.info("Getting " + location + " as " + (Object)((Object)type));
        ResourceLocation loc = ConfigManager.getLocation(type, location);
        String text = ConfigManager.getTextResource(loc, type.hasDefault());
        if (text == null) {
            JsonConfigurable<?, ?> failed = type.getNotFound(location);
            if (failed != null) {
                failed.setLocation(loc);
                return (T)failed;
            }
            CLSLog.warn("The text inside of \"" + loc + "\" was null!");
            throw new JsonSyntaxException("Invalid location '" + location + "': the text inside it was null!");
        }
        try {
            JsonConfigurable t = (JsonConfigurable)GSON_ADAPTORS.fromJson(text, type.clazz);
            t.setLocation(loc);
            t.setSource(text);
            return (T)t;
        }
        catch (JsonSyntaxException t) {
            throw new InvalidSourceException("Failed to read from " + loc + "\n" + text, t);
        }
    }

    public static JsonRenderingPart getAsRenderingPart(String location) throws InvalidExpressionException {
        return (JsonRenderingPart)ConfigManager.getAsT(EType.RENDERING_PART, location);
    }

    public static JsonFactory getAsFactory(String location) throws InvalidExpressionException {
        return (JsonFactory)ConfigManager.getAsT(EType.FACTORY, location);
    }

    public static JsonRender getAsImage(String location) throws InvalidExpressionException {
        return (JsonRender)ConfigManager.getAsT(EType.IMAGE, location);
    }

    public static JsonInsn getAsInsn(String location) throws InvalidExpressionException {
        return (JsonInsn)ConfigManager.getAsT(EType.INSTRUCTION, location);
    }

    public static JsonAction getAsAction(String location) throws InvalidExpressionException {
        return (JsonAction)ConfigManager.getAsT(EType.ACTION, location);
    }

    public static JsonConfig getAsConfig(String location) throws InvalidExpressionException {
        return (JsonConfig)ConfigManager.getAsT(EType.CONFIG, location);
    }

    public static void getAsScript(String location) {
    }

    public static ResourceLocation getLocation(EType type, String base) {
        String path;
        String namespace = "customloadingscreen";
        int colon = base.indexOf(58);
        int slash = base.indexOf(47);
        if (colon > 0 && (colon < slash || slash < 0)) {
            namespace = base.substring(0, colon);
            base = base.substring(colon + 1);
            path = "config".equals(namespace) && type == EType.CONFIG ? base : type.resourceBase + "/" + base;
        } else if (base.startsWith("builtin/")) {
            path = "builtin/" + type.resourceBase + base.substring(slash);
        } else if (base.startsWith("sample/")) {
            path = "sample/" + type.resourceBase + base.substring(slash);
        } else if (base.startsWith("config/")) {
            path = type == EType.CONFIG ? base.substring(slash + 1) : type.resourceBase + base.substring(slash);
            namespace = "config";
        } else {
            path = type.resourceBase + "/" + base;
        }
        return new ResourceLocation(namespace, path + ".json");
    }

    static {
        types = Maps.newHashMap();
        resManager = Minecraft.func_71410_x().func_110442_L();
        cache = Maps.newHashMap();
        failedCache = Maps.newHashMap();
        GSON_ADAPTORS = new GsonBuilder().registerTypeAdapter(JsonConfig.class, (Object)ConfigDeserialiser.INSTANCE).registerTypeAdapter(JsonRenderingPart.class, (Object)RenderingPartDeserialiser.INSTANCE).registerTypeAdapter(JsonRender.class, (Object)ImageDeserialiser.INSTANCE).registerTypeAdapter(JsonInsn.class, (Object)InstructionDeserialiser.INSTANCE).registerTypeAdapter(JsonVariable[].class, (Object)VariableArrayDeserialiser.VARIABLES).registerTypeAdapter(JsonVariable.JsonConstant[].class, (Object)VariableArrayDeserialiser.CONSTANTS).registerTypeAdapter(JsonFactory.class, (Object)FactoryDeserialiser.INSTANCE).registerTypeAdapter(Area.class, Area.DESERIALISER).create();
        GSON_DEFAULT = new GsonBuilder().setPrettyPrinting().create();
    }

    public static enum EType {
        FACTORY(JsonFactory.class, "factory"),
        ACTION(JsonAction.class, "action"),
        RENDERING_PART(JsonRenderingPart.class, "imagemeta"),
        IMAGE(JsonRender.class, "image"),
        INSTRUCTION(JsonInsn.class, "instruction"),
        CONFIG(JsonConfig.class, "config");

        public final Class<? extends JsonConfigurable<?, ?>> clazz;
        public final String resourceBase;

        public static EType valueOf(Class<? extends JsonConfigurable<?, ?>> configurable) {
            return (EType)((Object)types.get(configurable));
        }

        private <T extends JsonConfigurable<T, ?>> EType(Class<T> clazz, String resourceBase) {
            this.clazz = clazz;
            this.resourceBase = resourceBase;
            types.put(clazz, this);
        }

        public boolean hasDefault() {
            return this == RENDERING_PART;
        }

        public JsonConfigurable<?, ?> getNotFound(String location) throws InvalidExpressionException {
            JsonRender ji;
            if (this == RENDERING_PART && (ji = ConfigManager.getAsImage(location)) != null) {
                JsonRenderingPart jrp = new JsonRenderingPart(ji, new JsonInsn[0], "true");
                jrp.setSource(("{#-'image':'" + location + "'#}").replace('\'', '\"').replace('#', '\n').replace('-', '\t'));
                jrp.setLocation(ji.resourceLocation);
                return jrp;
            }
            return null;
        }
    }
}

