/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.render;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.ScaledResolution;

@Deprecated
public class RenderingStatus {
    public final ProgressState progressState;
    private int screenWidth;
    private int screenHeight;
    private double seconds = 0.0;
    public final Map<String, Object> tempVariables = new HashMap<String, Object>();
    public final Map<String, Object> definedVariables = new HashMap<String, Object>();

    public RenderingStatus(int width, int height) {
        this.progressState = new ProgressState();
        this.screenWidth = width;
        this.screenHeight = height;
    }

    public void tick(ScaledResolution res, double addedTime) {
        this.seconds += addedTime;
        this.screenWidth = res.func_78326_a();
        this.screenHeight = res.func_78328_b();
    }

    public double getSeconds() {
        return this.seconds;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }

    public static class ProgressState {
        private final ChangingField<ProgressPair> progress = new ChangingField();
        private final ChangingField<ProgressState> children = new ChangingField();

        public void changeFieldProgress(ProgressPair field, double now) {
            this.progress.changeField(field, now);
        }

        public void endCurrentProgress(double now) {
            this.progress.endCurrent(now);
        }

        public void moveProgressOn(double now) {
            this.progress.moveOn(now);
        }

        public void addFutureProgress(ProgressPair field) {
            this.progress.addFuture(field);
        }

        public boolean hasMoreProgress() {
            return this.progress.hasMore();
        }

        public ProgressPair getCurrentProgress() {
            return this.progress.getCurrent();
        }

        public double getLength(int diff, double now) {
            return this.progress.getLength(diff, now);
        }

        public double getStartDiff(int diff, double now) {
            return this.progress.getStartDiff(diff, now);
        }

        public double getEndDiff(int diff, double now) {
            return this.progress.getEndDiff(diff, now);
        }

        public void pushChild(ProgressPair startingPair, double now) {
            this.popChild(now);
            ProgressState child = new ProgressState();
            child.changeFieldProgress(startingPair, now);
            this.children.changeField(child, now);
        }

        public void popChild(double now) {
            ProgressState prevChild = this.children.getCurrent();
            if (prevChild == null) {
                return;
            }
            while (prevChild.progress.hasMore()) {
                prevChild.progress.moveOn(now);
            }
        }

        public ProgressState getCurrentChild() {
            return this.getCurrentChild(0);
        }

        public ProgressState getCurrentChild(int diff) {
            return this.children.getCurrentDiff(diff);
        }

        public boolean hasMoreChildren() {
            return this.children.hasMore();
        }
    }

    public static class ProgressPair {
        public final String status;
        public final double percentage;

        public ProgressPair(String status, double percentage) {
            if (status == null) {
                throw new IllegalArgumentException("Cannot have an empty progress!");
            }
            if (percentage < 0.0 || percentage > 1.0) {
                new IllegalArgumentException("Percentage should be between 0 and 1! (was " + percentage + ")").printStackTrace();
            }
            this.status = status;
            this.percentage = percentage;
        }
    }

    public static class ChangingField<T> {
        private final List<FieldState<T>> history = new ArrayList<FieldState<T>>();
        private int current = -1;

        public void changeField(T field, double now) {
            this.addFuture(field);
            this.moveOn(now);
        }

        public void endCurrent(double now) {
            if (this.current != -1) {
                FieldState<T> currentField = this.history.get(this.current);
                currentField.end(now);
            }
        }

        public void moveOn(double now) {
            this.endCurrent(now);
            if (this.history.size() == this.current + 1) {
                return;
            }
            ++this.current;
            this.history.get(this.current).start(now);
        }

        public void addFuture(T field) {
            this.history.add(new FieldState<T>(field));
        }

        private FieldState<T> getChanged(int diff) {
            if (this.current + diff < 0) {
                return FieldState.getEmptyState();
            }
            if (this.current + diff > this.history.size()) {
                return FieldState.getEmptyState();
            }
            return this.history.get(this.current + diff);
        }

        public T getCurrent() {
            return this.getCurrentDiff(0);
        }

        public T getCurrentDiff(int diff) {
            return this.getChanged((int)diff).field;
        }

        public double getLength(int diff, double now) {
            return ((FieldState)this.getChanged(diff)).getLength(now);
        }

        public double getStartDiff(int diff, double now) {
            return ((FieldState)this.getChanged(diff)).getStartDiff(now);
        }

        public double getEndDiff(int diff, double now) {
            return ((FieldState)this.getChanged(diff)).getEndDiff(now);
        }

        public boolean hasMore() {
            return this.current + 1 < this.history.size();
        }
    }

    public static class FieldState<T> {
        public final T field;
        private double start;
        private double end;

        public static <T> FieldState<T> getEmptyState() {
            return new FieldState<Object>(null).end(0.0);
        }

        public FieldState(T field) {
            this(field, -1.0);
        }

        public FieldState(T field, double now) {
            this.field = field;
            this.start = now;
            this.end = -1.0;
        }

        public FieldState<T> start(double now) {
            this.start = now;
            return this;
        }

        public FieldState<T> end(double now) {
            if (this.start == -1.0) {
                this.start = now;
            }
            this.end = now;
            return this;
        }

        private double getLength(double now) {
            return this.end == -1.0 ? now - this.start : this.end - this.start;
        }

        private double getEndDiff(double now) {
            return this.end == -1.0 ? -1.0 : now - this.end;
        }

        private double getStartDiff(double now) {
            return this.start == -1.0 ? -1.0 : now - this.start;
        }
    }
}

