/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.load.render;

import alexiil.mc.mod.load.CLSLog;
import alexiil.mc.mod.load.CustomLoadingScreen;
import alexiil.mc.mod.load.json.ResourceWrappingInputStream;
import alexiil.mc.mod.load.render.ClsTexture;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.AbstractResourcePack;
import net.minecraft.client.resources.FallbackResourceManager;
import net.minecraft.client.resources.FileResourcePack;
import net.minecraft.client.resources.FolderResourcePack;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.LegacyV2Adapter;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.KHRDebug;

public final class TextureLoader {
    private static final Field FIELD_RES_MANAGER_MAP;
    private static final Field FIELD_FALLBACK_LIST;
    private static final Field FIELD_ABS_PACK_FILE;
    private static final Field FIELD_LEGACY_ADAPTOR_PACK;
    private static final Method METHOD_FILE_PACK_GETTER;

    private static Field getField(Class<?> in, Class<?> fldType) {
        for (Field f : in.getDeclaredFields()) {
            if ((f.getModifiers() & 8) != 0 || !f.getType().equals(fldType)) continue;
            f.setAccessible(true);
            return f;
        }
        throw new IllegalStateException("Failed to find a field!");
    }

    @Nullable
    public static InputStream openResourceStream(ResourceLocation location) throws IOException {
        IResourceManager resManager;
        block42: {
            if (CustomLoadingScreen.debugResourceLoading) {
                CLSLog.info("[debug] Opening resource " + location);
            }
            if ("config".equals(location.func_110624_b())) {
                File fle = new File("config/customloadingscreen/" + location.func_110623_a());
                if (fle.exists()) {
                    if (CustomLoadingScreen.debugResourceLoading) {
                        CLSLog.info("[debug]   - Found resource file at " + fle);
                    }
                    try {
                        return new FileInputStream(fle);
                    }
                    catch (FileNotFoundException fnfe) {
                        if (CustomLoadingScreen.debugResourceLoading) {
                            CLSLog.warn("[debug]   x Missing file!!", fnfe);
                        }
                    }
                } else if (CustomLoadingScreen.debugResourceLoading) {
                    CLSLog.info("[debug]   x Missing file at " + fle + ", falling back to resources.");
                }
            }
            resManager = Minecraft.func_71410_x().func_110442_L();
            try {
                IResource res = resManager.func_110536_a(location);
                if (res != null) {
                    if (CustomLoadingScreen.debugResourceLoading) {
                        CLSLog.info("[debug]   - Found resource: " + res.func_177240_d() + " : " + res);
                    }
                    return new ResourceWrappingInputStream(res);
                }
            }
            catch (IOException e) {
                if (!CustomLoadingScreen.debugResourceLoading) break block42;
                CLSLog.warn("[debug]   x Failed to find resource, falling back to manual iteration....", e);
            }
        }
        if (resManager instanceof SimpleReloadableResourceManager) {
            List list;
            Map map;
            SimpleReloadableResourceManager srm = (SimpleReloadableResourceManager)resManager;
            if (CustomLoadingScreen.debugResourceLoading) {
                CLSLog.info("[debug]   Manually interating over MC's SimpleResourceManager");
            }
            try {
                map = (Map)FIELD_RES_MANAGER_MAP.get(srm);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                if (CustomLoadingScreen.debugResourceLoading) {
                    CLSLog.warn("[debug]   x Failed to retrieve the map!", e);
                }
                return null;
            }
            Object value = map.get(location.func_110624_b());
            if (CustomLoadingScreen.debugResourceLoading) {
                CLSLog.info("[debug]   - Looking at " + value);
            }
            FallbackResourceManager fallback = (FallbackResourceManager)value;
            try {
                list = (List)FIELD_FALLBACK_LIST.get(fallback);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                CLSLog.warn("[debug]    x Failed to retrieve the list!", e);
                return null;
            }
            for (Object o : list) {
                IResourcePack pack = (IResourcePack)o;
                if (pack instanceof LegacyV2Adapter) {
                    try {
                        pack = (IResourcePack)FIELD_LEGACY_ADAPTOR_PACK.get(pack);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        CLSLog.warn("[debug]    x Failed to retrieve the backing resource pack!", e);
                    }
                }
                if (pack instanceof AbstractResourcePack) {
                    File file;
                    try {
                        file = (File)FIELD_ABS_PACK_FILE.get(pack);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        CLSLog.warn("[debug]     x Failed to retrieve the file!", e);
                        continue;
                    }
                    String realPath = "assets/" + location.func_110624_b() + "/" + location.func_110623_a();
                    if (pack instanceof FileResourcePack) {
                        ZipFile zip;
                        FileResourcePack frp = (FileResourcePack)pack;
                        CLSLog.info("[debug]   - Looking at FileResourcePack " + file);
                        try {
                            zip = (ZipFile)METHOD_FILE_PACK_GETTER.invoke((Object)pack, new Object[0]);
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                            CLSLog.warn("[debug]     x Failed to retrieve the ZipFile!", e);
                            continue;
                        }
                        ZipEntry entry = zip.getEntry(realPath);
                        if (entry == null) continue;
                        if (CustomLoadingScreen.debugResourceLoading) {
                            CLSLog.info("[debug]   - Found ZipEntry " + entry);
                        }
                        try {
                            return zip.getInputStream(entry);
                        }
                        catch (IOException e) {
                            CLSLog.warn("[debug]   - Failed to open ZipEntry ", e);
                            continue;
                        }
                    }
                    if (pack instanceof FolderResourcePack) {
                        File target;
                        FolderResourcePack fldr = (FolderResourcePack)pack;
                        if (CustomLoadingScreen.debugResourceLoading) {
                            CLSLog.info("[debug]   - Looking at FolderResourcePack " + file);
                        }
                        if (!(target = new File(file, realPath)).isFile()) continue;
                        if (CustomLoadingScreen.debugResourceLoading) {
                            CLSLog.info("[debug]   - Found target file " + target);
                        }
                        return new FileInputStream(target);
                    }
                }
                if (CustomLoadingScreen.debugResourceLoading) {
                    CLSLog.info("[debug]   - Looking at unknown ResourcePack " + pack.getClass());
                }
                try {
                    return pack.func_110590_a(location);
                }
                catch (IOException e) {
                    CLSLog.warn("[debug]   - Failed to open stream as " + e.getClass() + ":" + e.getMessage());
                }
            }
        } else if (CustomLoadingScreen.debugResourceLoading) {
            CLSLog.info("[debug]   Unknown IResourceManager " + resManager.getClass() + ", aborting manual iteration!");
        }
        return null;
    }

    public static void bindTexture(TextureManager manager, ResourceLocation location) {
        ITextureObject current = manager.func_110581_b(location);
        if (current != null) {
            GL11.glBindTexture((int)3553, (int)current.func_110552_b());
            return;
        }
        ClsTexture texture = new ClsTexture(location);
        if (GLContext.getCapabilities().GL_KHR_debug) {
            KHRDebug.glPushDebugGroup((int)33354, (int)10, (CharSequence)"CLS_LoadCustomTexture");
        }
        manager.func_110579_a(location, (ITextureObject)texture);
        GL11.glBindTexture((int)3553, (int)texture.func_110552_b());
        if (GLContext.getCapabilities().GL_KHR_debug) {
            KHRDebug.glPopDebugGroup();
        }
        if (GLContext.getCapabilities().GL_KHR_debug) {
            KHRDebug.glPushDebugGroup((int)33354, (int)10, (CharSequence)"CLS_Render");
        }
    }

    public static PreScannedImageData preScan(ResourceLocation res) {
        try {
            ClsTexture clsTexture = new ClsTexture(res);
            clsTexture.loadImage(Minecraft.func_71410_x().func_110442_L());
            return new PreScannedImageData(clsTexture);
        }
        catch (IOException io) {
            CLSLog.warn("Failed to pre-load the texture " + res, io);
            return null;
        }
    }

    static {
        Class<FileResourcePack> filePack = FileResourcePack.class;
        Method filePackGetter = null;
        FIELD_RES_MANAGER_MAP = TextureLoader.getField(SimpleReloadableResourceManager.class, Map.class);
        FIELD_FALLBACK_LIST = TextureLoader.getField(FallbackResourceManager.class, List.class);
        FIELD_ABS_PACK_FILE = TextureLoader.getField(AbstractResourcePack.class, File.class);
        FIELD_LEGACY_ADAPTOR_PACK = TextureLoader.getField(LegacyV2Adapter.class, IResourcePack.class);
        for (Method m : filePack.getDeclaredMethods()) {
            if ((m.getModifiers() & 8) != 0 || !m.getReturnType().equals(ZipFile.class) || m.getParameterCount() != 0) continue;
            filePackGetter = m;
            break;
        }
        filePackGetter.setAccessible(true);
        METHOD_FILE_PACK_GETTER = filePackGetter;
    }

    public static class PreScannedImageData {
        public final ClsTexture texture;

        public PreScannedImageData(ClsTexture texture) {
            this.texture = texture;
        }

        public void bind(TextureManager manager) {
            ITextureObject current = manager.func_110581_b(this.texture.location());
            if (current != null) {
                GL11.glBindTexture((int)3553, (int)current.func_110552_b());
            } else {
                manager.func_110579_a(this.texture.location(), (ITextureObject)this.texture);
            }
        }
    }
}

