/*
 * Decompiled with CFR 0.152.
 */
package org.silvercatcher.reforged.api;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentDamage;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;

public interface ItemExtension {
    public static final UUID ATTACK_DAMAGE_MODIFIER_RF = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    public static final UUID ATTACK_SPEED_MODIFIER_RF = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");
    public static final int USE_DURATON = 72000;

    default public double getAttackSpeed(ItemStack stack) {
        return -2.4f;
    }

    default public Multimap getAttributeModifiers(ItemStack stack) {
        HashMultimap modifiers = HashMultimap.create();
        modifiers.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(ATTACK_DAMAGE_MODIFIER_RF, "Weapon Damage", (double)this.getHitDamage(stack), 0));
        modifiers.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(ATTACK_SPEED_MODIFIER_RF, "Weapon modifier", this.getAttackSpeed(stack), 0));
        return modifiers;
    }

    default public DamageSource getDamage(EntityLivingBase p) {
        if (p instanceof EntityPlayer) {
            return DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)p));
        }
        return DamageSource.func_76358_a((EntityLivingBase)p);
    }

    default public float getEnchantmentBonus(ItemStack stack, EntityPlayer player, Entity entity) {
        float extraDamage = 0.0f;
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)entity;
            for (Map.Entry o : EnchantmentHelper.func_82781_a((ItemStack)stack).entrySet()) {
                Enchantment e = (Enchantment)o.getKey();
                if (!(e instanceof EnchantmentDamage)) continue;
                EnchantmentDamage ed = (EnchantmentDamage)e;
                if (ed.field_77361_a == 0) continue;
                extraDamage += e.func_152376_a(EnchantmentHelper.func_77506_a((Enchantment)e, (ItemStack)stack), living.func_70668_bt());
            }
        }
        return extraDamage;
    }

    public float getHitDamage();

    default public float getHitDamage(ItemStack stack) {
        float enchantDamage = 0.0f;
        for (Map.Entry o : EnchantmentHelper.func_82781_a((ItemStack)stack).entrySet()) {
            Enchantment e = (Enchantment)o.getKey();
            if (!(e instanceof EnchantmentDamage)) continue;
            EnchantmentDamage ed = (EnchantmentDamage)e;
            if (ed.field_77361_a != 0) continue;
            enchantDamage += ed.func_152376_a(((Integer)o.getValue()).intValue(), null);
        }
        return this.getHitDamage() + enchantDamage;
    }
}

