/*
 * Decompiled with CFR 0.152.
 */
package org.silvercatcher.reforged.items.weapons;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.silvercatcher.reforged.ReforgedMod;
import org.silvercatcher.reforged.api.CompoundTags;
import org.silvercatcher.reforged.api.ItemExtension;
import org.silvercatcher.reforged.api.ReforgedAdditions;
import org.silvercatcher.reforged.entities.EntityCrossbowBolt;
import org.silvercatcher.reforged.util.Helpers;

public class ItemCrossbow
extends ItemBow
implements ItemExtension {
    public static final byte empty = 0;
    public static final byte loading = 1;
    public static final byte loaded = 2;

    public ItemCrossbow() {
        this.func_77625_d(1);
        this.func_77656_e(100);
        this.func_77655_b("crossbow");
        this.func_77637_a(ReforgedMod.tabReforged);
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                float mrl = 0.0f;
                if (entityIn != null && entityIn instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)entityIn;
                    if (stack.func_77973_b() instanceof ItemCrossbow && player.func_184600_cs() == EnumHand.MAIN_HAND) {
                        if (ItemCrossbow.this.getLoadState(stack) == 1) {
                            int left = ItemCrossbow.this.getReloadLeft(stack, player);
                            if (left > 14) {
                                mrl = 1.0f;
                            } else if (left > 9) {
                                mrl = 2.0f;
                            } else if (left > 4) {
                                mrl = 4.0f;
                            } else if (left >= 0) {
                                mrl = 5.0f;
                            }
                        } else if (ItemCrossbow.this.getLoadState(stack) == 2) {
                            mrl = 3.0f;
                        }
                    }
                }
                return mrl;
            }
        });
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag advanced) {
        byte loadState = this.giveCompound(stack).func_74771_c("ammo");
        tooltip.add(I18n.func_135052_a((String)"item.musket.loadstate", (Object[])new Object[0]) + ": " + (loadState == 0 ? I18n.func_135052_a((String)"item.musket.loadstate.empty", (Object[])new Object[0]) : (loadState == 2 ? I18n.func_135052_a((String)"item.musket.loadstate.loaded", (Object[])new Object[0]) : I18n.func_135052_a((String)"item.musket.loadstate.loading", (Object[])new Object[0]))));
    }

    private ItemStack findAmmo(EntityPlayer player) {
        if (this.func_185058_h_(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.func_185058_h_(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.func_185058_h_(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public Multimap getAttributeModifiers(ItemStack stack) {
        return ItemExtension.super.getAttributeModifiers(stack);
    }

    @Override
    public float getHitDamage() {
        return 2.0f;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        byte loadState = this.getLoadState(stack);
        if (loadState == 1) {
            if (ReforgedMod.battlegearDetected) {
                return EnumAction.BOW;
            }
            return EnumAction.BLOCK;
        }
        if (loadState == 2) {
            return EnumAction.BOW;
        }
        return EnumAction.NONE;
    }

    public byte getLoadState(ItemStack stack) {
        return this.giveCompound(stack).func_74771_c("ammo");
    }

    public int func_77626_a(ItemStack stack) {
        byte loadState = this.giveCompound(stack).func_74771_c("ammo");
        if (loadState == 1) {
            return this.getReloadTotal();
        }
        return super.func_77626_a(stack);
    }

    public int getReloadLeft(ItemStack stack, EntityPlayer player) {
        return this.getReloadTotal() - this.getReloadTime(stack);
    }

    public int getReloadTime(ItemStack stack) {
        return this.giveCompound(stack).func_74762_e("time");
    }

    public int getReloadTotal() {
        return 20;
    }

    public NBTTagCompound giveCompound(ItemStack stack) {
        NBTTagCompound compound = CompoundTags.giveCompound(stack);
        if (!compound.func_74764_b("ammo")) {
            compound.func_74774_a("ammo", (byte)0);
        }
        return compound;
    }

    protected boolean func_185058_h_(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemArrow;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND) {
            NBTTagCompound compound = this.giveCompound(playerIn.func_184614_ca());
            byte loadState = compound.func_74771_c("ammo");
            if (loadState == 0) {
                if (playerIn.field_71075_bZ.field_75098_d || Helpers.consumeInventoryItem(playerIn, ReforgedAdditions.CROSSBOW_BOLT)) {
                    loadState = 1;
                    if (compound.func_74771_c("ammo") == 0) {
                        compound.func_74757_a("started", true);
                        compound.func_74768_a("time", 0);
                    }
                } else {
                    Helpers.playSound(worldIn, (Entity)playerIn, "crossbow_reload", 1.0f, 0.7f);
                }
            }
            compound.func_74774_a("ammo", loadState);
            if (compound.func_74762_e("time") <= 0 || !worldIn.field_72995_K || worldIn.field_72995_K && compound.func_74762_e("time") >= this.getReloadTotal() - 1) {
                playerIn.func_184598_c(hand);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184614_ca());
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)playerIn.func_184592_cb());
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.PASS;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase playerIn) {
        byte loadState = this.giveCompound(stack).func_74771_c("ammo");
        if (loadState == 1) {
            loadState = 2;
        }
        this.giveCompound(stack).func_74774_a("ammo", loadState);
        return stack;
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase playerInl, int timeLeft) {
        if (!worldIn.field_72995_K && playerInl instanceof EntityPlayer) {
            EntityPlayer playerIn = (EntityPlayer)playerInl;
            NBTTagCompound compound = this.giveCompound(stack);
            byte loadState = compound.func_74771_c("ammo");
            if (loadState == 2) {
                Helpers.playSound(worldIn, (Entity)playerIn, "crossbow_shoot", 1.0f, 1.0f);
                this.shoot(worldIn, (EntityLivingBase)playerIn, new ItemStack(ReforgedAdditions.CROSSBOW_BOLT));
                if (!playerIn.field_71075_bZ.field_75098_d && stack.func_77973_b().func_77645_m() && stack.func_96631_a(5, field_77697_d, null)) {
                    playerIn.func_70669_a(stack);
                    Helpers.destroyCurrentEquippedItem(playerIn);
                }
                compound.func_74774_a("ammo", (byte)0);
                compound.func_74757_a("started", false);
            }
            compound.func_74768_a("time", -1);
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (this.giveCompound(stack).func_74767_n("started") && this.getLoadState(stack) == 1) {
            this.giveCompound(stack).func_74768_a("time", this.getReloadTime(stack) + 1);
        }
    }

    public void shoot(World worldIn, EntityLivingBase playerIn, ItemStack stack) {
        EntityCrossbowBolt a = new EntityCrossbowBolt(worldIn, playerIn);
        a.setAim((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, 0.0f, ItemCrossbow.func_185059_b((int)40) * 3.0f, 1.0f);
        a.pickupStatus = EntityArrow.PickupStatus.func_188795_a((int)new Random().nextInt(2));
        a.setDamage(8.0);
        worldIn.func_72838_d((Entity)a);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !slotChanged;
    }
}

